<?php
require_once("../includes/auth.php");

function input_val($name)
{
	$val = DUtil::getGoodVal(DUtil::grab_input('GET', $name));
	if ($val == null) {
		die("missing param $name");
	}
	return $val;
}

function php_to_javascript($JScode)
{
	echo "<script>" . $JScode . "</script>\n";
}

function js_var($vars)
{
	$JScode = '';
	foreach ($vars as $k => $v) {
		$JScode .= "var $k='$v';";
	}
	echo '<script>' . $JScode . "</script>\n";
}

$graph_type = input_val('gtype');
$jsvars = ['graph_type' => $graph_type];
switch ($graph_type) {
	case 'Server':
		$title = 'Server';
		break;
	case 'VH':
		$vhost = input_val('vhost');
		$jsvars['vhost'] = $vhost;
		$title = "VHost $vhost";
		break;
	case 'EXTAPP':
		$vhost = input_val('vhost');
		$extapp = input_val('extapp');
		$jsvars['vhost'] = $vhost;
		$jsvars['extapp'] = $extapp;
		$title = ($vhost == '_Server') ? 'Server Level' : "VHost $vhost";
		$title .= " -> $extapp";
		break;

	default: die('illegal access');
}
$jsvars['graph_title'] = $title;
js_var($jsvars);


echo GUI::header();
?>

<div class="bottom_Bar"><span class="h2_font">Real-Time Statistics</span></div>
<div>
    <table border="0">
        <tbody>
            <tr>
                <td>
                    <label>Refresh Interval</label>
                </td class="xtbl_value">
                <td colspan="3">
                    <select id="refresh_period" name="refresh_period">
                        <option value="0">Stop</option>
                        <option value="10">10 Seconds</option>
						<option value="15" selected>15 Seconds</option>
                        <option value="30">30 Seconds</option>
                        <option value="60">60 Seconds</option>
                        <option value="120">2 Minutes</option>
                        <option value="300">5 Minutes</option>
                    </select>
                </td>
            </tr>
        </tbody>
	</table>
</div>

<canvas id="realtimeChart" width="400" height="200"></canvas>
<?php
if ($graph_type == 'Server') {
	?>

	<table id="t_server" border="1" width="100%" class="chart-table">
		<tr>
			<td>
				<table class="chart-inner-table">
					<tr><td>Requests in Processing:</td><td><span id='label_REQ_PROCESSING'>0</span></td></tr>
					<tr><td>Requests/Sec:</td><td id='label_REQ_PER_SEC'>0</span></td></tr>
					<tr><td>Total Requests:</td><td><span id='label_TOT_REQS'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Total Static Hits:</td><td><span id='label_TOTAL_STATIC_HITS'>0</span></td><td><span style="color:green" id='label_STATIC_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
					<tr><td>Total Public Cache Hits:</td><td><span id='label_TOTAL_CACHE_HITS'>0</span></td><td><span style="color:green" id='label_CACHE_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
					<tr><td>Total Private Cache Hits:</td><td><span id='label_TOTAL_PRIVATE_CACHE_HITS'>0</span></td><td><span style="color:green" id='label_PRIVATE_CACHE_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Free Conn:</td><td><span id='label_AVAILCONN'>0</span></td></tr>
					<tr><td>HTTP Used:</td><td><span id='label_PLAINCONN'>0</span></td></tr>
					<tr><td>Max Conn:</td><td><span id='label_MAXCONN'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Free SSL Conn:</td><td><span id='label_AVAILSSL'>0</span></td></tr>
					<tr><td>HTTPS Used:</td><td><span id='label_SSLCONN'>0</span></td></tr>
					<tr><td>Max SSL Conn:</td><td><span id='label_MAXSSL_CONN'>0</span></td></tr>
				</table>
			</td>
		</tr>
	</table>

	<?php
} elseif ($graph_type == 'VH') {
	?>

	<table id="t_virtualhost" border="1" width="100%" class="chart-table">
		<tr>
			<td>
				<table class="chart-inner-table">
					<tr><td>Requests in Processing:</td><td><span id='label_REQ_PROCESSING'>0</span></td></tr>
					<tr><td>Requests/Sec:</td><td id='label_REQ_PER_SEC'>0</span></td></tr>
					<tr><td>Total Requests:</td><td><span id='label_TOT_REQS'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Total Static Hits:</td><td><span id='label_TOTAL_STATIC_HITS'>0</span></td><td><span style="color:green" id='label_STATIC_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
					<tr><td>Total Public Cache Hits:</td><td><span id='label_TOTAL_CACHE_HITS'>0</span></td><td><span style="color:green" id='label_CACHE_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
					<tr><td>Total Private Cache Hits:</td><td><span id='label_TOTAL_PRIVATE_CACHE_HITS'>0</span></td><td><span style="color:green" id='label_PRIVATE_CACHE_HITS_PER_SEC'>0</span> Hits/Sec</td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>ExtApp Processes:</td><td><span id='label_EAP_PROCESS'>0</span></td></tr>
					<tr><td>EAProc In Use:</td><td id='label_EAP_INUSE'>0</span></td></tr>
					<tr><td>EAProc Idle:</td><td><span id='label_EAP_IDLE'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>EAProc WaitQ:</td><td><span id='label_EAP_WAITQ'>0</span></td></tr>
					<tr><td>EAProc Req/Sec:</td><td><span id='label_EAP_REQ_PER_SEC'>0</span></td></tr>
					<tr><td>&nbsp</td><td>&nbsp</td></tr>
				</table>
			</td>
		</tr>
	</table>

	<?php
} elseif ($graph_type == 'EXTAPP') {
	?>

	<table id="t_externalapplication" border="1" width="100%" class="chart-table">
		<tr>
			<td>
				<table class="chart-inner-table">
					<tr><td>Max Conn:</td><td><span id='label_CONFIG_MAX_CONN'>0</span></td></tr>
					<tr><td>Effective Max Conn:</td><td><span id='label_EFFECT_MAX_CONN'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Pool:</td><td><span id='label_POOL_SIZE'>0</span></td></tr>
					<tr><td>In Use:</td><td><span id='label_INUSE_CONN'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Idle:</td><td><span id='label_IDLE_CONN'>0</span></td></tr>
					<tr><td>WaitQ:</td><td><span id='label_WAITQUEUE_DEPTH'>0</span></td></tr>
				</table>
			</td>
			<td>
				<table class="chart-inner-table">
					<tr><td>Req/Sec:</td><td><span id='label_REQ_PER_SEC'>0</span></td></tr>
					<tr><td>&nbsp</td><td>&nbsp</td></tr>
				</table>
			</td>
		</tr>
	</table>

	<?php
}
?>


<style>
    .chart-table, .chart-inner-table {
        border-collapse: collapse;
        border-color: #a5c1dd;
        border: none;
    }

    .chart-table{
        margin-top:15px;
        margin-bottom: 25px;
    }

    .chart-table td {
        padding: 0;
        border: none;
    }

    .chart-inner-table {
        width: 100%;
        padding: 0;
    }

    .chart-inner-table td {
        padding: 2px 5px;
        border: 1px solid #a5c1dd;
    }

    .chart-table table td:first-child {
        background-color: #f5f9fc;
    }
</style>

<script type="text/javascript" src="/static/scripts/jquery-3.6.1.min.js" ></script>
<script type="text/javascript" src="/static/scripts/chart.umd.min.js" ></script>
<script type="text/javascript" src="/static/scripts/realtime_stats.js" ></script>
