<?php
require_once('includes/global.php');
require_once('blowfish.php');
$client = CLIENT::singleton();
$is_https = (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on'));

if(isset($_GET['generateKeypair'])) {
	$keyLength = 512;
	$cc = ConfCenter::singleton();
	$keyfile = $cc->GetConfFilePath('admin', 'key');
	$mykeys = null;
	if (file_exists($keyfile)) {
		$str = file_get_contents($keyfile);
		if ($str != '') {
			$mykeys = unserialize($str);
		}
	}
	if ($mykeys == null) {
		$jCryption = new jCryption();
 		$keys = $jCryption->generateKeypair($keyLength);
		$e_hex = $jCryption->dec2string($keys['e'],16);
		$n_hex = $jCryption->dec2string($keys['n'],16);
		$mykeys = array( 'e_hex' => $e_hex, 'n_hex' => $n_hex, 'd_int' => $keys['d'], 'n_int' => $keys['n']);
		$serialized_str = serialize($mykeys);
		file_put_contents($keyfile, $serialized_str);
		chmod($keyfile, 0600);
	}
	$_SESSION['d_int'] = $mykeys['d_int'];
	$_SESSION['n_int'] = $mykeys['n_int'];

	echo '{"e":"'.$mykeys['e_hex'].'","n":"'.$mykeys['n_hex'].'","maxdigits":"'.intval($keyLength*2/16+3).'"}';
	exit;
}


$timedout = DUtil::grab_input('get','timedout','int');
$logoff = DUtil::grab_input('get','logoff','int');
$msg = "";

if($timedout > 0 || $logoff  == 1) {
	$client->clear();
    if($timedout == 1) {
		$msg = 'Your session has timed out.';
	} elseif ($timedout == 2) {
        $msg = 'Your credential has changed, please login in again.';
    } else {
		$msg = 'You have logged off.';
	}
}
else if($client->isValid()) {
	header('location:/index.php');
	exit();
}

$userid = null;
$pass = null;

if ( isset($_POST['jCryption']) && isset($_SESSION['d_int']) && isset($_SESSION['n_int'])) {
	$jCryption = new jCryption();
	$var = $jCryption->decrypt($_POST['jCryption'], $_SESSION['d_int'], $_SESSION['n_int']);
	unset($_SESSION['d_int']);
	unset($_SESSION['n_int']);
	parse_str($var,$result);
	$userid = $result['userid'];
	$pass = $result['pass'];
}
else if ($is_https && isset($_POST['userid'])) {
	$userid = DUtil::grab_input('POST','userid');
	$pass = DUtil::grab_input('POST','pass');
}

if ($userid != null) {
	if ( $client->authenticate($userid, $pass) === TRUE ) {
		$temp=gettimeofday();
		$start=(int)$temp['usec'];
		$secretKey0 = mt_rand(). $start . mt_rand();
		$secretKey1 = mt_rand(). mt_rand() . $start;
		$client->setSecret(array($secretKey0, $secretKey1));
		$client->store(PMA_blowfish_encrypt($userid, $secretKey0), PMA_blowfish_encrypt($pass, $secretKey1));

		header('location:/index.php');
		exit();
	}
	else {
		$msg = 'Invalid credentials.';
	}
}


echo GUI::header();

if (!$is_https) {
?>
<script type="text/javascript" src="/static/scripts/jquery-3.6.1.min.js" ></script>
<script type="text/javascript" src="/static/scripts/jcryption/jquery.jcryption.js" ></script>
<script type="text/javascript">
$(document).ready(function() {
	$("#login").jCryption()
	$("input,select,textarea").removeAttr("disabled");
});
</script>

<?php } ?>
            <style>
                html,
                body {
                    margin: 0;
                    font-size: 16px;
                    height:100%;
                }
                form {
                    margin:0;
                }
                #main-wrapper {
                    width:auto;
                    margin:0;
                    height:100%;
                }
                .center-wrapper {
                    display: flex;
                    justify-content: center;
                    min-height: 100%;
                    padding: 20vh 1rem 1rem 1rem;
                    box-sizing: border-box;
                }
                .login-form-inner {
                    width: 100%;
                    box-sizing: border-box;
                    max-width: 320px;
                    margin: 0 auto;
                    padding: 1.25rem 1.5rem 1.5rem 1.5rem;
                    border: 1px solid #ced4da;
                    background-color: #f5f9fc;
                    box-shadow: 0 .55rem 1.25rem rgba(0, 65, 98, .04);
                }
                .login-form-input {
                    width: 100%;
                }
                .login-form-logo {
                    text-align: center;
                    margin-bottom: 1rem;
                }
                .login-form h1 {
                    border-bottom: 1px solid #ced4da;
                    font-size: .938rem;
                    padding: 1.15rem 1.5rem 1rem 1.5rem;
                    margin: -1.25rem -1.5rem 1.75rem -1.5rem;
                    color: #0a2246;
                    background-color: #cbddec;
                    line-height: 1;
                }
                .login-form-label {
                    font-size: .938rem;
                }
                .login-form-input {
                    display: block;
                    width: 100%;
                    height: calc(1.5rem + .75rem + 2px);
                    padding: .375rem .75rem;
                    font-size: 1rem;
                    font-weight: 400;
                    line-height: 1.5;
                    color: #495057;
                    background-color: #fff;
                    background-clip: padding-box;
                    border: 1px solid #ced4da;
                    border-radius: 0;
                    margin-top: 0.25rem;
                    margin-bottom: 1.25rem;
                }
                .text-center {
                    text-align: center;
                }
                .login-button {
                    color: #fff;
                    background-color: #142c4e;
                    border-color: #142c4e;
                    padding: .275rem .75rem;
                    font-size: 1rem;
                    line-height: 1.5;
                    border-radius: 0;
                    box-shadow: none;
                    min-width: 8rem;
                    cursor: pointer;
                    transition:.3s;
                }
                .login-button:hover {
                    background-color: #165180;
                }
                .login-form-msg {
                    font-size: .864rem;
                    margin-bottom: 1.5rem;
                    color: #5d6879;
                }
            </style>
            <div class="center-wrapper">
                <div>
                    <form id="login" action="login.php" method="post">
                        <div class="login-form">
                            <div class="login-form-logo"><img src="/static/images/logo/product_logo.svg" width="300px" border="0"></div>
                            <div class="login-form-inner">
                                <h1>WebAdmin Console</h1>
<?php
if (strlen($msg)) {
                                        echo "<p class='login-form-msg'>{$msg}</p>";
}
?>
                                <div class="">
                                    <label for="uid" class="login-form-label">Username</label>
                                    <input name="userid" id="uid" type="text" class="login-form-input">
                                </div>
                                <div class="">
                                    <label for="pass" class="login-form-label">Password</label>
                                    <input name="pass" id="pass" type="password" class="login-form-input">
                                </div>
                                <div class="">
                                    <input type="submit" class="login-button" value="Login">
                                </div>
                            </div>
                        </div>
</form>
                    <div id="copyright" class="text-center">Copyright &copy; 2002-<?php echo date('Y');?> <a href="https://www.litespeedtech.com">LiteSpeed Technologies, Inc.</a> All Rights Reserved.</div>
                </div>
            </div>
        </div>
    </body>
</html>
