<?php

class DUtil
{

	public static function grab_input($origin, $name, $type = '')
	{
		if ($name == '' || $origin == '') {
			die("input error");
		}
		$vars = null;

		switch (strtoupper($origin)) {
			case "REQUEST":
			case "ANY":
				$vars = $_REQUEST;
				break;
			case "GET":
				$vars = $_GET;
				break;
			case "POST":
				$vars = $_POST;
				break;
			case "COOKIE":
				$vars = $_COOKIE;
				break;
			case "FILE":
				$vars = $_FILES;
				break;
			case "SERVER":
				$vars = $_SERVER;
				break;
			default:
				die("input extract error.");
		}

		$val = array_key_exists($name, $vars) ? $vars[$name] : null;

		switch ($type) {
			case "int": 
				return (int) $val;

			case "float": 
				return (float) $val;

			case "array": 
				return (is_array($val) ? $val : null);
				
			case "object": 
				return (is_object($val) ? $val : null);

			case "string":
			default:
				return trim((string) $val); //default string
		}
	}

	public static function genOptions($options, $selValue)
	{
		$buf = '';
		if ($options) {
			foreach ($options as $k => $val) {
				$buf .= sprintf('<option value="%s" %s>%s</option>',
						$k, (($k == $selValue) ? 'selected' : ''), $val);
			}
		}
		return $buf;
	}

	public static function getGoodVal($val)
	{
		if ( $val != null && strpos($val, '<') !== false ) {
			return null;
		}
		return $val;
	}

	public static function getGoodVal1(&$val)
	{
		if ( $val != null && strpos($val, '<') !== false ) {
			$val = null;
			return null;
		}
		return $val;
	}

	public static function getLastId($id)
	{
		if ( $id == null ) {
			return null;
		}

		$pos = strrpos($id, '`');
		if ( $pos === false ) {
			return $id;
		}
		return substr($id, $pos+1);
	}

	public static function trimLastId(&$id)
	{
		$pos = false;
		if ($id) {
			$pos = strrpos($id, '`');
		}
		if ( $pos !== false ) {
			$id = substr($id, 0, $pos);
		} else {
			$id = null;
		}
	}

	public static function switchLastId(&$curId, $newId)
	{
		$pos = false;
		if ($curId) {
			$pos = strrpos($curId, '`');
		}
		if ( $pos !== false ) {
			$curId = substr($curId, 0, $pos+1) . $newId;
		} else {
			$curId = $newId;
		}
	}

	public static function &locateData0(&$holder, $dataloc, $ref = null)
	{
		$data = &$holder;

		if ($dataloc) {
			$datalocs = explode(':', $dataloc);

			foreach ($datalocs as $loc) {
				$data = &$data[$loc];
			}
			if ($ref) {
				$data = &$data[$ref];
			}
		}
		return $data;
	}

	public static function &locateData(&$holder, $dataloc, $ref = null)
    {
        $data = &$holder;
        if ($ref != null) {
            $refs = explode('`', $ref);
        }

        if ($dataloc != null) {
            $datalocs = explode(':', $dataloc);
            foreach ($datalocs as $loc) {
                $r = strpos($loc, '!$');

                if ($r > 0) {
                    $a = substr($loc, $r + 2);
                    $loc = substr($loc, 0, $r);
                    $data = &$data[$loc][$refs[$a]];
                } else {
                    $data = &$data[$loc];
                }
            }
        }
        return $data;
    }

    public static function getSubTid($subTbls, $data)
	{
		$key = $subTbls[0];
		if ( !isset($data[$key]) ) {
			return $subTbls[1];
		}

		$newkey = $data[$key]->GetVal();
		if ( ($newkey == '0') || !isset($subTbls[$newkey]) ) {
			return $subTbls[1];
		}
		return $subTbls[$newkey];
	}

	public static function splitMultiple($val)
	{
		return preg_split("/, /", $val, -1, PREG_SPLIT_NO_EMPTY);
	}

	public static function array_string_keys($input)
	{
		$output = [];
		if ($input != null && is_array($input)) {
			foreach($input as $k => $v) {
				$output[] = (string)$k;
			}
		}
		return $output;
	}

	public static function getDataVal(&$holderArray, $key)
	{
		if ($holderArray == null
				|| ! is_array($holderArray)
				|| empty($holderArray[$key])
				|| ! is_a($holderArray[$key], 'CVal')) {
			return null;
		}
		return $holderArray[$key]->GetVal();
	}

	public static function dbg_out($tag, &$obj, $visible=true)
	{
		if ($visible) {
			echo "<pre> $tag \n" . print_r($obj, true) . "\n</pre>";
		} else {
			echo "<!-- $tag --\n" . print_r($obj, true) . "-->\n";
		}
	}

	public static function dbg_tag($tag, $visible=true)
	{
		if ($visible) {
			echo "<pre>$tag \n</pre>";
		} else {
			echo "<!-- $tag -->\n";
		}
	}


}
