import importlib.util
import os
from collections import namedtuple


ENTRYPOINT = "im_hook"
ModuleInfo = namedtuple("ModuleInfo", ("object", "mtime", "ctime"))
modules: dict[str, ModuleInfo] = {}


def import_hook(path):
    file_stat = os.stat(path)
    if (
        path in modules
        and modules[path].mtime == file_stat.st_mtime
        and modules[path].ctime == file_stat.st_ctime
    ):
        return modules[path].object

    spec = importlib.util.spec_from_file_location(path, path)
    hook_module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(hook_module)
    modules[path] = ModuleInfo(
        object=hook_module, mtime=file_stat.st_mtime, ctime=file_stat.st_ctime
    )
    return hook_module


def remove_hook(path):
    if path in modules:
        modules.pop(path)


def execute_hook(path, dict_param):
    hook_module = import_hook(path)
    entrypoint = getattr(hook_module, ENTRYPOINT)
    return entrypoint(dict_param)
