# PHP type names ⚡️

*Get all valid PHP type names with constants* ✅

## 📄 Overview

*Simple library containing the list of constants for the available PHP data types. Use those constant types in your project when you need to mention a data type, use those constants instead of hardcoding them.*


## ⚙️ Requirements

* [PHP 7.3](https://www.php.net/releases/7_3_0.php) or newer.

## ⚙️ Installation

Install it easily with [Composer](https://getcomposer.org/doc/00-intro.md)

```bash
composer require ph-7/datatype
```

## 🤠 Example

```php
require_once __DIR__ . '/vendor/autoload.php';

use PH7\Datatype\Type;

$id = settype($_GET['id'], Type::STRING);

$name = settype($inputName, Type::STRING);
```


## 😋 Who cooked it?

[![Pierre-Henry Soria](https://s.gravatar.com/avatar/a210fe61253c43c869d71eaed0e90149?s=200)](https://ph7.me "Pierre-Henry Soria personal website")

**[Pierre-Henry Soria](https://ph7.me)**, a highly passionate, zen &amp; pragmatic software engineer 😊

[![@phenrysay][twitter-image]](https://twitter.com/phenrysay) [![pH-7][github-image]](https://github.com/pH-7)


## 📺 The Video

[![Watch the video][video-thumbnail]](https://youtu.be/9v9g722dulE?t=453)

👉 **[Watch on YouTube](https://youtu.be/9v9g722dulE?t=453)** 👈

## ⚖️ License

**PHP type names** is generously distributed under the *[MIT](https://opensource.org/licenses/MIT)*.


<!-- GitHub's Markdown reference links -->
[twitter-image]: https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white
[github-image]: https://img.shields.io/badge/GitHub-100000?style=for-the-badge&logo=github&logoColor=white
[video-thumbnail]: https://i1.ytimg.com/vi/9v9g722dulE/sddefault.jpg

<!-- Generated by https://github.com/pH-7/cool-readme-generator -->
