from typing import Dict, Optional, TypedDict, Union

from pydantic import BaseModel
from typing_extensions import NotRequired

MetadataType = TypedDict(
    "MetadataType",
    {
        "entityId": str,
        "entityName": str,
        "eventName": str,
        "publisherName": NotRequired[str],
        "publishDate": NotRequired[str],
        "authorization": NotRequired[str],
        "traceparent": NotRequired[str],
        "tracestate": NotRequired[str],
        "containsPersonalData": NotRequired[bool],
        "token": NotRequired[str],
    },
)
ParamsType = TypedDict(
    "ParamsType", {"metadata": MetadataType, "payload": Dict[str, str]}
)


class Metadata(BaseModel):
    entityId: str
    entityName: str
    eventName: str
    publisherName: str = ""
    publishDate: str = ""
    authorization: Optional[str] = None
    traceparent: str = ""
    tracestate: str = ""
    containsPersonalData: bool = False
    token: str = ""


class Params(BaseModel):
    metadata: Metadata
    payload: dict = {}

    @staticmethod
    def from_dict(data: Union[dict, ParamsType]):
        return Params(
            metadata=Metadata(**data.get("metadata", {})),
            payload=data.get("payload", {}),
        )


class Payload(BaseModel):
    method: str
    params: Params
    jsonrpc: str
    id: int
