/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Config, Listener, ObservableListenerOpts } from "../Observable.js";
import { Component, ComponentEventMap } from "../Component.js";
/**
 * @inheritDoc
 */
export interface ColorPickerEventMap<Type> extends ComponentEventMap<Type> {
    /**
     * Fires when color is selected
     *
     * @param colorPicker
     * @param color Hexadecimal color. eg. "000000"
     */
    select: (colorPicker: Type, color: string) => void;
}
export interface ColorPicker extends Component {
    on<K extends keyof ColorPickerEventMap<ColorPicker>, L extends Listener>(eventName: K, listener: Partial<ColorPickerEventMap<ColorPicker>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof ColorPickerEventMap<this>>(eventName: K, listener: Partial<ColorPickerEventMap<this>>[K]): boolean;
    fire<K extends keyof ColorPickerEventMap<ColorPicker>>(eventName: K, ...args: Parameters<ColorPickerEventMap<Component>[K]>): boolean;
}
/**
 * Color menu component
 *
 * @example
 * ```
 * Button.create({
 * 	text: "Color",
 * 	menu: ColorPicker.create()
 * });
 * ```
 */
export declare class ColorPicker extends Component {
    private _value;
    /**
     * Set color value as button text color if this menu belongs to a button
     */
    updateButton: boolean;
    protected baseCls: string;
    protected colors: string[];
    getText(): string;
    setValue(val: string): void;
    constructor();
    private static rgb2hex;
    /**
     * Color hex value eg. #000000
     */
    set value(color: string);
    get value(): string;
}
/**
 * Shorthand function to create {@see ColorPicker}
 *
 * @param config
 */
export declare const colorpicker: (config?: Config<ColorPicker, ColorPickerEventMap<ColorPicker>>) => ColorPicker;
//# sourceMappingURL=ColorPicker.d.ts.map