/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Form, FormEventMap } from "./Form";
import { AbstractDataSource, BaseEntity, DefaultEntity, EntityID } from "../../data";
import { Config, Listener, ObservableListenerOpts } from "../Observable";
import { Component } from "../Component";
import { ContainerFieldValue } from "./ContainerField";
export interface DataSourceFormEventMap<Type, ValueType extends ContainerFieldValue = ContainerFieldValue> extends FormEventMap<Type> {
    /**
     * Fires when the entity is saved successfully
     * @param form
     * @param data
     * @param isNew
     */
    save: (form: Type, data: ValueType, isNew: boolean) => any;
    /**
     * Fires when an error occurred when saving
     *
     * If a listener returns "false", the standard error dialog
     * is not shown.
     *
     * @param form
     * @param data
     */
    saveerror: (form: Type, error: any) => any;
    /**
     * When the data is fetched from the store. but before it is put into the fields
     * @param form
     * @param data the entity from the store
     */
    load: (form: Type, data: ValueType) => any;
    /**
     * Fires when an error occurred when loading.
     *
     * If a listener returns "false", the standard error dialog
     * is not shown.
     *
     * @param form
     * @param data
     */
    loaderror: (form: Type, error: any) => any;
    /**
     * When the data in the fields is serialized to a single json object to be posted to the server.
     * @param form
     * @param data
     */
    beforesave: (form: Type, data: Partial<ValueType>) => void;
}
export interface DataSourceForm<ValueType extends BaseEntity = DefaultEntity> extends Form<ValueType> {
    on<K extends keyof DataSourceFormEventMap<this, ValueType>, L extends Listener>(eventName: K, listener: Partial<DataSourceFormEventMap<this, ValueType>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof DataSourceFormEventMap<this, ValueType>>(eventName: K, listener: Partial<DataSourceFormEventMap<this, ValueType>>[K]): boolean;
    fire<K extends keyof DataSourceFormEventMap<this, ValueType>>(eventName: K, ...args: Parameters<DataSourceFormEventMap<any, ValueType>[K]>): boolean;
}
export declare class DataSourceForm<ValueType extends BaseEntity = DefaultEntity> extends Form<ValueType> {
    dataSource: AbstractDataSource<ValueType>;
    protected currentId?: EntityID;
    constructor(dataSource: AbstractDataSource<ValueType>);
    private handleServerValidation;
    create(data: any): void;
    reset(): void;
    get isNew(): boolean;
    /**
     * Load an entity into the form
     *
     * @param id
     */
    load(id: EntityID): Promise<void>;
}
/**
 * Shorthand function to create {@see DataSourceForm}
 *
 * @param config
 * @param items
 */
export declare const datasourceform: <ValueType extends BaseEntity = DefaultEntity>(config: Config<DataSourceForm<ValueType>, DataSourceFormEventMap<DataSourceForm<ValueType>, ContainerFieldValue>, "dataSource">, ...items: Component[]) => DataSourceForm<ValueType>;
//# sourceMappingURL=DataSourceForm.d.ts.map