import { Component } from "@intermesh/goui";
/**
 * MainThreeColumnPanel class
 *
 * Base class for modules that use a typical 3 column layout:
 *
 * west: navigation
 * center: main grid
 * east: Show detail
 */
export declare abstract class MainThreeColumnPanel extends Component {
    protected readonly center: Component;
    protected readonly west: Component;
    protected readonly east: Component;
    /**
     * Constructor
     *
     * @param idAndRoute Used for state saving and also as the route to the main panel
     * @protected
     */
    protected constructor(idAndRoute: string);
    /**
     * Button to show the west panel. Use in overrides.
     *
     * @protected
     */
    protected showWestButton(): import("@intermesh/goui").Button;
    /**
     * Button to show the center panel. Use in overrides.
     * @protected
     */
    protected showCenterButton(): import("@intermesh/goui").Button;
    /**
     * Create west panel
     *
     * @protected
     */
    protected abstract createWest(): Component;
    /**
     * Create east panel
     *
     * @protected
     */
    protected abstract createEast(): Component;
    /**
     * Create center panel
     *
     * @protected
     */
    protected abstract createCenter(): Component;
    /**
     * Activate the given panel
     *
     * @param active
     */
    activatePanel(active: Component): void;
}
//# sourceMappingURL=MainThreeColumnPanel.d.ts.map