import { Router as GouiRouter } from "@intermesh/goui";
/**
 * Router adapter class that uses the old router
 */
class Router extends GouiRouter {
    add(re, handler) {
        go.Router.add(re, handler);
        return this;
    }
    setPath(path) {
        const oldPath = this.getPath();
        go.Router.setPath(path);
        this.fire("change", this.getPath(), oldPath);
    }
    start() {
        return Promise.resolve();
    }
    reload() {
        go.Router.check();
    }
}
export const router = new Router();
//# sourceMappingURL=Router.js.map