/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { TextField } from "./TextField.js";
import { Config, Listener, ObservableEventMap, ObservableListenerOpts } from "../Observable.js";
import { FieldEventMap } from "./Field.js";
import { Button } from "../Button.js";
import { Component } from "../Component.js";
import { List, listStoreType } from "../List";
import { Menu } from "../menu";
import { storeRecordType } from "../../data";
export interface AutocompleteEventMap<Type> extends FieldEventMap<Type> {
    /**
     * Fires when suggestions need to load
     *
     * @param form
     */
    autocomplete: (field: Type, input: string) => any;
    /**
     * Fires when an item is selected from the list
     */
    select: (field: Type, record: any) => any;
}
export interface AutocompleteField<T extends List = List> extends TextField {
    on<K extends keyof AutocompleteEventMap<this>, L extends Listener>(eventName: K, listener: Partial<AutocompleteEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof AutocompleteEventMap<this>>(eventName: K, listener: Partial<AutocompleteEventMap<this>>[K]): boolean;
    fire<K extends keyof AutocompleteEventMap<this>>(eventName: K, ...args: Parameters<AutocompleteEventMap<Component>[K]>): boolean;
}
/**
 * Autocomplete field
 */
export declare class AutocompleteField<T extends List = List> extends TextField {
    readonly list: T;
    private buffer;
    readonly menu: Menu;
    protected readonly menuButton: Button;
    readonly picker: import("../picker").ListPicker<T>;
    /**
     *
     * @param list The table to use for suggestions
     * @param buffer Buffer typing in the input in ms
     */
    constructor(list: T, buffer?: number);
    /**
     * Method that transforms a record from the TablePicker store to a value for this field.
     * This is not necessarily a text value. In conjunction with {@see valueToTextField()} this
     * could also be an ID of an object for example.
     *
     * @param field
     * @param record
     */
    pickerRecordToValue(field: this, record: storeRecordType<listStoreType<T>>): any;
    /**
     * This method transforms the value in to a text representation for the input field
     *
     * @param field
     * @param value
     */
    valueToTextField(field: this, value: any): Promise<string>;
    protected internalSetValue(v?: string): void;
    get value(): any;
    set value(v: any);
    protected internalRender(): HTMLElement;
    private onInput;
}
type AutoCompleteConfig<T extends List, Map extends ObservableEventMap<any>, Required extends keyof AutocompleteField<T>> = Config<AutocompleteField<T>, Map, Required> & Partial<Pick<AutocompleteField<T>, "pickerRecordToValue" | "valueToTextField">>;
/**
 * Shorthand function to create an {@see AutocompleteField}
 *
 * @param config
 */
export declare const autocomplete: <T extends List<import("../../data").Store<import("../../data").StoreRecord>>>(config: AutoCompleteConfig<T, AutocompleteEventMap<AutocompleteField<T>>, "list">) => AutocompleteField<T | (undefined & T)>;
export {};
//# sourceMappingURL=AutocompleteField.d.ts.map