import { ChipsField } from "./ChipsField";
import { List, listStoreType } from "../List";
import { FieldEventMap } from "./Field";
import { Config, Listener, ObservableListenerOpts } from "../Observable";
import { Component } from "../Component";
import { storeRecordType } from "../../data";
export interface AutocompleteChipsEventMap<Type> extends FieldEventMap<Type> {
    /**
     * Fires when suggestions need to load
     *
     * @param form
     */
    autocomplete: (field: Type, input: string) => any;
}
export interface AutocompleteChips<T extends List> extends ChipsField {
    on<K extends keyof AutocompleteChipsEventMap<this>, L extends Listener>(eventName: K, listener: Partial<AutocompleteChipsEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof AutocompleteChipsEventMap<this>>(eventName: K, listener: Partial<AutocompleteChipsEventMap<this>>[K]): boolean;
    fire<K extends keyof AutocompleteChipsEventMap<this>>(eventName: K, ...args: Parameters<AutocompleteChipsEventMap<Component>[K]>): boolean;
}
/**
 * Chips component that auto completes user input
 */
export declare class AutocompleteChips<T extends List = List> extends ChipsField {
    readonly list: T;
    private buffer;
    private readonly menu;
    private readonly menuButton;
    private valuesToCompare?;
    textInputToValue: (text: string) => Promise<any>;
    /**
     * Constructor
     *
     * @param list The drop down list or {@see Table}.
     * @param buffer
     */
    constructor(list: T, buffer?: number);
    private initList;
    private isPickerRecordInValue;
    /**
     * Method that transforms a record from the TablePicker store to a value for this field.
     * This is not necessarily a text value. In conjunction with {@see valueToTextField()} this
     * could also be an ID of an object for example.
     *
     * @param field
     * @param record
     */
    pickerRecordToValue(field: this, record: storeRecordType<listStoreType<T>>): any;
    protected internalRender(): HTMLElement;
    private onInput;
    private onMenuHide;
}
type AutoCompleteChipsConfig<ListType extends List = List> = Config<AutocompleteChips<ListType>, AutocompleteChipsEventMap<AutocompleteChips<ListType>>, "list"> & Partial<Pick<AutocompleteChips<ListType>, "textInputToValue" | "chipRenderer" | "pickerRecordToValue">>;
/**
 * Shorthand function to create {@see AutocompleteChips}
 *
 * @param config
 */
export declare const autocompletechips: <ListType extends List<import("../../data").Store<import("../../data").StoreRecord>> = List<import("../../data").Store<import("../../data").StoreRecord>>>(config: AutoCompleteChipsConfig<ListType>) => AutocompleteChips<ListType>;
export {};
//# sourceMappingURL=AutocompleteChips.d.ts.map