/* global Ext, go */

Ext.ns("go.modules.business.projects2.customfield");

go.modules.business.projects2.customfield.Project = Ext.extend(go.customfields.type.Text, {

	name: "Project",

	label: t("Project"),

	iconCls: "ic-assignment",

	currentProject: null,

	// TODO: Replace this ugly-ass code with a simple go.Db.store("project').single()
	getCurrentProject: function(id, callbackFn) {
		return go.Db.store("Project").single(id);
	},

	/**
	 * Return dialog to edit this type of field
	 *
	 * @returns {go.customfields.FieldDialog}
	 */
	getDialog: function () {
		return new go.modules.business.projects2.customfield.ProjectDialog();
	},

	/**
	 * Render's the custom field value for the detail views
	 *
	 * @param {mixed} value
	 * @param {object} data Complete entity
	 * @param {object} customfield Field entity from custom fields
	 * @param {go.detail.Property} cmp The property component that renders the value
	 * @returns {unresolved}
	 */
	renderDetailView: function (value, data, customfield, cmp) {
		cmp.setVisible(false);
		cmp.setValue(t("Not found or no access"));
		if(!parseInt(value)) {
			return "";
		}
		return this.getCurrentProject(value).then((p)=> {
			cmp.setValue('<a href="#' + go.Entities.get("Project").getRouterPath(p.id) + '">' + p.name + '</a>')
			cmp.setVisible(true);
		})
	},

	/**
	 * Returns config object to create the form field
	 *
	 * @param {object} customfield customfield Field entity from custom fields
	 * @param {object} config Extra config options to apply to the form field
	 * @returns {Object}
	 */
	createFormFieldConfig: function (customfield, config) {
		var c = go.modules.business.projects2.customfield.Project.superclass.createFormFieldConfig.call(this, customfield, config);
		c.xtype = "projectcombo";
		var baseParams = {};
		if (!go.util.empty(customfield.options.statusId)) {
			baseParams.status_id = customfield.options.statusId;
		}
		baseParams.permissionLevel = customfield.options.permissionLevel
		c.storeBaseParams = baseParams;

		c.hiddenName = c.name;
		delete c.name;

		return c;
	},


	getFieldDefinition: function (field) {
		var me = this;
		//Use a promise type to prefetch the contact data before store loads
		var def = this.supr().getFieldDefinition(field);
		def.type = 'promise';
		def.promise = function (record) {
			// 	old framework has record["customFields.name"] = data;
			var id = record[this.name];
			if (!id && record.customFields) {
				// 	new framework has record.customFields.name = data
				id = record.customFields[this.customField.databaseName];
			}
			if (!id) {
				return Promise.resolve(null);
			} else {

				return go.Db.store("Project").single(id);

			}
		}
		return def;
	},

	getRelations: function (customfield) {
		var r = {};
		r[customfield.databaseName] = {store: "Project", fk: customfield.databaseName};
		return r;
	},

	getColumn: function (field) {
		var me = this;
		var c = go.modules.business.projects2.customfield.Project.superclass.getColumn.call(this, field);
		c.renderer = function (v) {
			return v ? v.name : "";
		};
		return c;
	},

	getFilter: function (field) {
		return {
			name: field.databaseName,
			type: "GO.projects2.SelectProject",
			typeConfig: this.createFormFieldConfig(field),
			multiple: true,
			wildcards: true,
			title: field.name
		};
	}
});

// go.customfields.CustomFields.registerType(new go.modules.business.projects2.customfield.Project());

