<?php


namespace GO\Professional;
use GO;

abstract class Module extends \GO\Base\Module {
	
	public function appCenter(){
		return true;
	}
	
	public function package(){
		return 'Business';
	}


	/**
	 * Check if a file is encoded and if so check if it can be decrypted with
	 * Ioncube.
	 *
	 * @param StringHelper $path
	 * @return boolean
	 */
	public function hasLicense($packagename="Professional"){

		if(!go()->getEnvironment()->hasIoncube()) {
			return false;
		}

		switch($packagename){
			case 'Billing':
				$license = 'billing';
				break;

			case 'Documents':
				$license = 'documents';
				break;

			default:
				$license = 'groupoffice-pro';
		}

		return \go\modules\business\license\model\License::has($license);
	}
	
	public function isInstallable(){
		return $this->hasLicense($this->package());
	}
	
	public function isAvailable() {
		
		return $this->hasLicense($this->package());
		
	}
}
