GO.leavedays.LeavedayDialog = Ext.extend(GO.dialog.TabbedFormDialog , {
		
	enableApplyButton: false,

	actsAsManager: false,
		
	initComponent : function(){
		Ext.apply(this, {
			titleField:'user_name',
			height: dp(700),
			width: dp(800),
			updateAction: 'update',
			createAction: 'create',
			goDialogId:'leaveday',
			title:t("Holiday", "leavedays"),
			formControllerUrl: 'leavedays/leaveday',
			endDateRequired:true
		});
		
		GO.leavedays.LeavedayDialog.superclass.initComponent.call(this);
		
	},
	
	afterLoad : function(remoteModelId, config, action){
		this.yearField.setValue(GO.leavedays.activeYear);
		this.userIdField.setValue(GO.leavedays.activeUserId);

		// Admins and people who open other employees' leave day requests are managers
		if (go.User.isAdmin || go.User.id !== GO.leavedays.activeUserId) {
			this.actsAsManager = true;
		} else {
			// Check whether employee manages themselves
			for(const m of go.User.employee.managers) {
				if(m.subjectId == go.User.id && m.managerId == go.User.id) {
					this.actsAsManager = true;
					break;
				}
			}
		}

		if (!(remoteModelId > 0)) {
			const now = new Date();
			const theDate = new Date(GO.leavedays.activeYear,now.getMonth(),now.getDate());
			this.firstDateField.setValue(theDate);
			this.lastDateField.setValue(theDate);
		} else {
			const activityTypeId = this.type.getValue();
			go.Db.store('Activity').single(activityTypeId).then((data) => {
				if(parseInt(data.type) === 4) {
					const slbc = this.specialLeaveBudgetCombo
					slbc.store.baseParams = {
						activeOnly:true,
						user_id: GO.leavedays.activeUserId,
						activity_id: activityTypeId,
						year: GO.leavedays.activeYear
					};
					slbc.store.load({callback: function(r, options, success) {
						// Fugly hack to prevent only the id field to show in the combobox
						if(slbc.getValue()) {
							slbc.setValue(slbc.getValue());
						}
						slbc.show();
						slbc.enable();
						slbc.allowBlank = !this.actsAsManager;
						this.formPanel.doLayout();
					}, scope: this});
				}
			});
		}
		
		this._checkDateInput(true);
	},

	
	buildForm : function () {
		this.propertiesPanel = new Ext.form.FieldSet({
			autoScroll: true,
			layout: 'column',
			items: [new Ext.Panel({
				columnWidth: .7,
				border: false,
				layout:'form',
				waitMsgTarget:true,			
				items:[this.userIdField = new Ext.form.NumberField({
					hidden: true,
					decimals: 0,
					name: 'user_id'
				}),{
					xtype:'plainfield',
					name:'user_name',
					fieldLabel:t("Employee", "leavedays")
				},
				this.yearField = new GO.form.PlainField({
					fieldLabel: t("Year", "leavedays"),
					decimals: 0,
					name: 'year'
				}),
				this.firstDateField = new Ext.form.DateField({
					fieldLabel : t("First date", "leavedays"),
					name : 'first_date',
					format : GO.settings['date_format'],
					allowBlank : false,			
					listeners : {
						change : {
							fn : this._checkDateInput,
							scope : this
						}
					}
				}), this.lastDateField = new Ext.form.DateField({
					fieldLabel : t("Last date", "leavedays"),
					name : 'last_date',
					format : GO.settings['date_format'],
					allowBlank : !this.endDateRequired,			
					listeners : {
						change : {
							fn : this._checkDateInput,
							scope : this
						}
					}
				}),
				
				this.hoursCompositeField = new Ext.Container({
					cls: "go-hbox",
					layout:"form",
					items:[
						this.hoursField = new GO.form.NumberField({
							fieldLabel : t("Leave hours", "leavedays"),
							name : 'n_hours',
							width : dp(160),
							decimals: 2,
							maxValue: 8784,
							minValue: GO.leavedays.currentUserIsManager ? Number.NEGATIVE_INFINITY : 0,
							allowBlank : true
						}), 
						this.fromTimeField = new GO.form.TimeField({
							name : 'from_time',
							fieldLabel: t("Start time for calendar", "leavedays"),
							width : dp(200),
						})
					]
				}),
				
				this.nationalHolidayHoursField = new GO.form.NumberField({
					fieldLabel : t("National holiday hours", "leavedays"),
					name : 'n_nat_holiday_hours',
					width : dp(160),
					decimals: 2,
					maxValue: 8784
				}), this.commentsField = new Ext.form.TextField({
					fieldLabel : t("Description", "leavedays"),
					name : 'description',
					anchor: "100%",
					maxLength : 50
				}),
				this.type = new go.modules.business.business.ActivityCombo({
					fieldLabel: t("Type", "leavedays"),
					hiddenName: 'ld_credit_type_id',
					activityType: '!work',
					emptyText: t("Please select..."),
					listeners: {
						select: function(cb,record,idx) {
							if (record.json.type === 4) { // i.e. special leave!
								this.specialLeaveBudgetCombo.allowBlank = !this.actsAsManager;
								this.specialLeaveBudgetCombo.store.baseParams = {
									activeOnly:true,
									user_id: GO.leavedays.activeUserId,
									activity_id: record.id,
									year: GO.leavedays.activeYear
								},
								this.specialLeaveBudgetCombo.show()
							} else {
								this.specialLeaveBudgetCombo.clearInvalid();
								this.specialLeaveBudgetCombo.allowBlank = true;
								this.specialLeaveBudgetCombo.hide().setValue(null);
							}
						},
						scope: this
					},
				}),
				this.specialLeaveBudgetCombo = new GO.form.ComboBoxReset({
					fieldLabel: t('Special leave budget', 'leavedays'),
					hiddenName: 'special_budget_id',
					width : dp(450),
					emptyText: t("Please select..."),
					hint: t("Select existing budget or create a new budget in the \'Leave Budgets\' tab"),
					store: new GO.data.JsonStore({
						url:GO.url("leavedays/specialleavebudget/store"),
						baseParams:{
							activeOnly:true,
							user_id: GO.leavedays.activeUserId,
							activity_id: this.type.getValue(),
							year: GO.leavedays.activeYear
						},
						fields:['id', 'description', 'start_date', 'finish_date', 'n_hours', 'spent_hours'],
						remoteSort:true
					}),
					pageSize: parseInt(GO.settings.max_rows_list),
					valueField: 'id',
					displayField: 'description',
					mode: 'remote',
					triggerAction: 'all',
					editable: false,
					selectOnFocus: true,
					forceSelection: true,
					allowBlank: this.type.activityType !== "special" || !this.actsAsManager,
					hidden: this.type.activityType !== "special",
					tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<div ext:qtip="{description} ({start_date} - {finish_date}, ({spent_hours} / {n_hours})" class="x-combo-list-item">{description} ({spent_hours} / {n_hours})</div>',
						'</tpl>'
				 )
				})
			]
			}),new Ext.form.FieldSet({
				columnWidth: .3,
				title:t("Working hours", "leavedays"),
				border: false,
				layout:'form',
				waitMsgTarget:true,
				defaults: {
					setValue: function(v) {
						if(parseInt(v) > 0) {
							v *= 60;
						}
						var d = go.util.Format.duration(v);
						this.setRawValue(v ? d : '0:00');
						return this;
					}
				},
				items:[this.wwMoField = new Ext.form.DisplayField({
						fieldLabel: t("Monday", "leavedays"), 
						name:'workweek.mo'
					}),this.wwTuField = new Ext.form.DisplayField({

						fieldLabel: t("Tuesday", "leavedays"),
						name:'workweek.tu'
					}),this.wwWeField = new Ext.form.DisplayField({
						fieldLabel: t("Wednesday", "leavedays"), 
						name:'workweek.we'
					}),this.wwThField = new Ext.form.DisplayField({
						fieldLabel: t("Thursday", "leavedays"), 
						name:'workweek.th'
					}),this.wwFrField = new Ext.form.DisplayField({
						fieldLabel: t("Friday", "leavedays"),
						name:'workweek.fr'
					}),this.wwSaField = new Ext.form.DisplayField({
						fieldLabel: t("Saturday", "leavedays"), 
						name:'workweek.sa'
					}),this.wwSuField = new Ext.form.DisplayField({
						fieldLabel: t("Sunday", "leavedays"), 
						name:'workweek.su'
					})]
			})]
		});

		this.addPanel(this.propertiesPanel);
	},
					
	_checkDateInput : function(loading) {
		
		loading = loading || false;

		var eD = this.lastDateField.getValue();
		var sD = this.firstDateField.getValue();

		if (!GO.util.empty(sD) && sD.getFullYear()!=this.yearField.getValue()) {
			Ext.MessageBox.alert('',t("The holiday entry must be completely in the year %y.", "leavedays").replace('%y',this.yearField.getValue()));
			this.firstDateField.reset();
		} else if (!GO.util.empty(eD) && eD.getFullYear()!=this.yearField.getValue()) {
			Ext.MessageBox.alert('',t("The holiday entry must be completely in the year %y.", "leavedays").replace('%y',this.yearField.getValue()));
			this.lastDateField.reset();
		}

		if (!GO.util.empty(sD) && GO.util.empty(eD) && this.endDateRequired) {
			this.lastDateField.setValue(sD);
		}

		if (!GO.util.empty(sD) && !GO.util.empty(eD)) {
			if (sD > eD) {
				this.lastDateField.setValue(sD);
			}
			eD = this.lastDateField.getValue();
			sD = this.firstDateField.getValue();
		}
		
		if(loading === true) {
			return;
		}

		var params = {
				'leaveday_id' : this.remoteModelId,
				'user_id': this.userIdField.getValue(),
				'first_date' : sD.format(GO.settings.date_format)
			};
			
		if(this.endDateRequired){
			params.last_date = eD.format(GO.settings.date_format);
		} else {
			params.last_date = 0;
		}
		
		GO.request({
			url: 'leavedays/leaveday/defaultWorkingHours',
			params: params,
			success: function(options, response, result) {
				if (!GO.util.empty(result.feedback)) {
					Ext.MessageBox.alert('', result.feedback);
				}

				this.hoursField.setValue(result.data['n_leave_hours']);
				this.nationalHolidayHoursField.setValue(result.data['national_holiday_hours']);
			},
			scope: this
		});

	}
	
});
