import {
	BaseEntity,
	column,
	Config,
	createComponent,
	DataSourceStore,
	datasourcestore,
	t,
	Table
} from "@intermesh/goui";
import {JmapDataSource, jmapds} from "@intermesh/groupoffice-core";

interface TaskList extends BaseEntity {
	name:string,
	group:any
}
export class TasklistTable extends Table<DataSourceStore<JmapDataSource<TaskList>>> {
	constructor() {

		const store = datasourcestore<JmapDataSource<TaskList>, TaskList>({
			dataSource: jmapds("TaskList"),
			relations: {
				group: {
					path: "groupingId",
					dataSource: jmapds("TaskListGrouping")
				}
			},
			queryParams: {
				limit: 20,
				filter: {
					forSupport: true,
					role: "support", //support tasklists
				}
			},
			sort: [{property: "group", isAscending: true},{property: "name", isAscending: true}]
		});

		const columns = [
			column({
				header: t("Name"),
				id:"name",
				resizable: true,
				width: 312,
				sortable: true
			})
		];
		
		super(store, columns );

		this.groupBy = "group.name";

		// this.groupByRenderer = async (grouping, record, th, table) => {
		//
		// 	if(!grouping) {
		// 		return t("None");
		// 	}
		//
		// 	return grouping.name;
		// }

		this.rowSelectionConfig =  {
			multiSelect: true
		};

	}
}

export const tasklisttable = (config?: Config<TasklistTable>) => createComponent(new TasklistTable(), config);