/* global go, Ext */

go.modules.business.paypal.SystemSettingsPanel = Ext.extend(go.systemsettings.Panel, {

    title: "PayPal",
    iconCls: 'ic-euro-symbol',
    labelWidth: 125,
    layout: "form",
    autoScroll: true,

    initComponent: function () {

        this.items = [
            {
                xtype: "fieldset",
                 defaults: {
                    allowBlank: false,
                    anchor: '100%',
                },
                items: [
                    {
                        xtype: 'textfield',
                        name: 'clientId',
                        fieldLabel: "Client ID",
                        spellcheck: false
                    },
                    {
                        xtype: 'textfield',
                        inputType: "password",
                        name: 'secret',
                        fieldLabel: "Secret",
                    },
                    {
                        xtype: 'checkbox',
                        name: 'sandbox',
                        fieldLabel: "Sandbox",
                    }
                ]
            }
        ];

        this.supr().initComponent.call(this);
    }
});