/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */
//TODO MAKE WINDOW
go.modules.business.finance.PaymentMainPanel = Ext.extend(go.modules.ModulePanel, {
	layout: 'responsive',


	initComponent: function () {
		this.createPaymentGrid();

		this.sidePanel = new Ext.Panel({

			width: dp(300),
			cls: 'go-sidenav',
			region: "west",
			split: true,
			autoScroll: true,
			layout: "anchor",
			defaults: {
				anchor: "100%"
			},
			tbar: [
				{
					scope: this,
					handler: function() {
						this.ownerCt.getLayout().setActiveItem(0);
					},
					text: t("Close payments"),
					iconCls: "ic-close"
				}
			],
			items: [
				this.createBusinessPanel(),
				this.createFilterPanel()
			]
		});


		this.items = [
			this.sidePanel,
			this.grid, //first is default in narrow mode

		];

		go.modules.business.finance.PaymentMainPanel.superclass.initComponent.call(this);

		this.on("show", () => {
				this.runModule();
		});
	},


	createFilterPanel: function () {
		return new Ext.form.FieldSet({
			labelAlign: "top",
				region: "center",
				minHeight: dp(200),
				autoScroll: true,
				title: t("Filters"),

				items: [
					{
						hideLabel: true,
						xtype: "checkbox",
						boxLabel: t("Incomplete"),
						listeners: {
							scope: this,
							check: function(f, val) {
								this.grid.store.setFilter("incomplete", val ? {documentId: null} : null);
								this.grid.store.load();
							}
						}
					},
					{
						hideLabel: true,
						xtype: "checkbox",
						boxLabel: t("Unverified only"),
						listeners: {
							scope: this,
							check: function(f, val) {
								this.grid.store.setFilter("checked", val ? {checked: false} : null);
								this.grid.store.load();
							}
						}
					},
					new go.form.DateRangeField({
						anchor: "100%",
						fieldLabel: t("Date"),
						listeners: {
							scope: this,
							change: function(f, val) {
								this.grid.store.setFilter("date", {date: val});
								this.grid.store.load();
							}
						}
					})
				]

			}
		);
	},

	runModule: function () {

		var me = this;
		this.documentBusinessGrid.store.load().then(function() {
			me.documentBusinessGrid.getSelectionModel().selectRow(0);
		});
	},

	createBusinessPanel : function() {
		this.documentBusinessGrid = new go.modules.business.finance.FinanceBusinessGrid({
			region: "north",
			autoHeight: true,
			title: t("Business")
		});
		this.documentBusinessGrid.getSelectionModel().on('selectionchange', this.onFinanceBusinessSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first

		return this.documentBusinessGrid;
	},

	onFinanceBusinessSelectionChange : function (sm) {
		var selected = sm.getSelected();
		if(!selected) {
			Ext.MessageBox.alert(t("No business", "There are no businesses defined yet in the system settings"));
			this.setDisabled(true);
		}

		go.modules.business.finance.business = selected.data;

		this.businessId = selected.id;
		this.addButton.setDisabled(!this.businessId);
		this.grid.store.setFilter("business", {businessId: this.businessId});
		this.grid.store.load();

	},



	createPaymentGrid: function () {
		this.grid = new go.modules.business.finance.PaymentGrid({
			region: 'center',
		
			tbar: [{
				cls: 'go-narrow', //Shows on mobile only
				iconCls: "ic-menu",
				handler: function () {
					this.sidePanel.show();
				},
				scope: this
			},
				'->',
				{
					xtype: 'tbsearch'
				},

				{
					iconCls: 'ic-cloud-upload',
					text: t("Import"),
					handler: function () {
						go.util.importFile(
							'Payment',
							'.csv,.xlsx,.swi,.mt940,.mta',
							{
								businessId: this.businessId
							},
							{}
						);
					},
					scope: this
				},


				this.addButton = new Ext.Button({
					iconCls: 'ic-add',
					tooltip: t('Add'),
					cls: "primary",
					handler: function (btn) {
						var d = new go.modules.business.finance.PaymentDialog();
						d.setValues({
							businessId: this.businessId
						})
						d.show();
					},
					scope: this
				}),
				this.moreBtn = new Ext.Button({
					iconCls: 'ic-more-vert',
					menu: []
				})]
		});



			this.moreBtn.menu.add(
				this.exportButton = new Ext.menu.Item({
					iconCls: 'ic-cloud-download',
					text: t("Export"),
					menu: [
						{
							text: 'Microsoft Excel',
							iconCls: 'filetype filetype-xls',
							handler: function() {
								go.util.exportToFile(
									'Payment',
									Object.assign(go.util.clone(this.grid.store.baseParams), this.grid.store.lastOptions.params, {limit: 0, position: 0}),
									'xlsx');
							},
							scope: this
						},{
							text: 'Comma Separated Values',
							iconCls: 'filetype filetype-csv',
							handler: function() {
								go.util.exportToFile(
									'Payment',
									Object.assign(go.util.clone(this.grid.store.baseParams), this.grid.store.lastOptions.params, {limit: 0, position: 0}),
									'csv');
							},
							scope: this
						},
						{
							iconCls: 'filetype filetype-json',
							text: 'JSON',
							handler: function() {
								go.util.exportToFile(
									'Payment',
									Ext.apply(go.util.clone(this.grid.store.baseParams), this.grid.store.lastOptions.params, {limit: 0, start: 0}),
									'json');
							},
							scope: this
						}
					]
				})

			);


		return this.grid;
	}
});