go.modules.business.catalog.ArticleDetail = Ext.extend(go.detail.Panel, {
	entityStore: "Article",
	stateId: 'no-Article-detail',
	relations: ["business", "supplier"],

	initComponent: function () {
		this.frontendConfig = go.modules.business.catalog.ModuleConfig.frontendOptions;

		this.tbar = this.initToolbar();

		Ext.apply(this, {
			items: [{
				title: t("Article"),
				onLoad: function (detailView) {

					let title = detailView.data.name;
					if(detailView.data.number) {
						title += " - " + detailView.data.number;
					}

					this.setTitle(title);
				},
				tpl: new Ext.XTemplate(
					'<div class="icons">' +

					'<p class="s6">' +
					'<i class="icon label">attach_money</i>' +
					'<span>€ {[go.util.Format.number(values.cost, 2)]}</span></span>' +
					'<label>' + t("Cost") + '</label>' +
					'</p>'+

						'<p class="s6" >' +
							'<i class="icon label">star</i>' +
							'<span>{supplierNumber}</span>	' +
							'<label>{[t("Supplier number")]}</label>' +
						'</p>' +

						'<tpl if="supplier" for="supplier"><p class="s6" >' +
							'<i class="icon label">business</i>' +
							'<span>{name}</span>	' +
							'<label>{[t("Supplier")]}</label>' +
						'</p></tpl>' +

						'<p class="s6">' +
							'<i class="icon label">attach_money</i>' +
							'<span>€ {[go.util.Format.number(values.price, 2)]}</span></span>' +
							'<label>' + t("Price") + '</label>' +
					 	'</p>'+

					'</div>'

				)
			}]
		});

		go.modules.business.catalog.ArticleDetail.superclass.initComponent.call(this);

		this.addCustomFields();

		if(this.frontendConfig.showLinks) {
			this.addLinks();
		}
		if(this.frontendConfig.showComments) {
			this.addComments();
		}
		if(this.frontendConfig.showFileUploads) {
			this.addFiles();
		}
		if(this.frontendConfig.showModifyPanel) {
			this.add(new go.detail.CreateModifyPanel());
		}
	},


	onLoad: function () {
		this.getTopToolbar().getComponent("edit").setDisabled(this.data.permissionLevel < go.permissionLevels.write);
		this.deleteItem.setDisabled(this.data.permissionLevel < go.permissionLevels.writeAndDelete);

		go.modules.business.catalog.ArticleDetail.superclass.onLoad.call(this);
	},

	initToolbar: function () {
		var items = this.tbar || [];
		items = items.concat([
			'->',
			{
				itemId: "edit",
				iconCls: 'ic-edit',
				tooltip: t("Edit"),
				handler: function (btn, e) {
					var editDlg = new go.modules.business.catalog.ArticleDialog();
					editDlg.load(this.data.id).show();
				},
				scope: this
			},

			this.moreMenu = {
				iconCls: 'ic-more-vert',
				menu: [{
				iconCls: "btn-print",
				text: t("Print"),
				handler: function () {
					this.body.print({title: this.data.name});
				},
				scope: this
			},
			"-",
			this.deleteItem = new Ext.menu.Item({
				itemId: "delete",
				iconCls: 'ic-delete',
				text: t("Delete"),
				handler: function () {
					Ext.MessageBox.confirm(t("Confirm delete"), t("Are you sure you want to delete this item?"), function (btn) {
						if (btn !== "yes") {
						return;
					}
					this.entityStore.set({destroy: [this.currentId]});
				}, this);
				},
				scope: this
			})
		]
		}]);
		if(this.frontendConfig.showLinks) {
			items.splice(3, 0, new go.detail.addButton({
				detailView: this
			}), {xtype: "linkbrowserbutton"});
		}

		if(this.frontendConfig.showFileUploads && go.Modules.isAvailable("legacy", "files")) {
			items.splice(items.length - 1, 0,{
				xtype: "detailfilebrowserbutton"
			});
		}

		var tbarCfg = {
			disabled: true,
			items: items
		};
		return new Ext.Toolbar(tbarCfg);
	}
});
