/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component } from "../Component.js";
import { Field, FieldEventMap } from "./Field.js";
import { Button } from "../Button.js";
import { Menu } from "../menu/Menu.js";
import { Config, Listener, ObservableListenerOpts } from "../Observable";
import { List } from "../List";
export interface ListFieldEventMap<Type> extends FieldEventMap<Type> {
    /**
     * Fires when an item is selected from the list
     */
    select: (field: Type, record: any) => any;
}
export interface ListField<ListType extends List> extends Field {
    on<K extends keyof ListFieldEventMap<this>, L extends Listener>(eventName: K, listener: Partial<ListFieldEventMap<this>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof ListFieldEventMap<this>>(eventName: K, listener: Partial<ListFieldEventMap<this>>[K]): boolean;
    fire<K extends keyof ListFieldEventMap<this>>(eventName: K, ...args: Parameters<ListFieldEventMap<Component>[K]>): boolean;
}
/**
 * ColorField component
 *
 * @see Form
 */
export declare class ListField<ListType extends List> extends Field {
    readonly list: ListType;
    readonly valueProperty: string;
    readonly menu: Menu;
    protected readonly menuButton: Button;
    readonly picker: import("../picker").ListPicker<ListType>;
    private container?;
    protected baseCls: string;
    constructor(list: ListType, valueProperty?: string);
    protected internalRender(): HTMLElement;
    pickerRecordToValue(_field: this, record: any): string;
    protected createControl(): HTMLDivElement;
    protected internalSetValue(v?: string): void;
    /**
     * This method transforms the value in to a HTML representation
     *
     * @param field
     * @param value
     */
    renderValue(field: this, value: any): Promise<string>;
}
export type ListFieldConfig<T extends List> = Config<ListField<T>, ListFieldEventMap<ListField<T>>, "list"> & Partial<Pick<ListField<T>, "pickerRecordToValue" | "renderValue">>;
/**
 * Shorthand function to create {@link ListField}
 *
 * @param config
 */
export declare const listfield: <T extends List<import("../../index.js").Store<import("../../index.js").StoreRecord>>>(config: ListFieldConfig<T>) => ListField<T>;
//# sourceMappingURL=ListField.d.ts.map