/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component, createComponent } from "./Component.js";
export class Avatar extends Component {
    constructor() {
        super(...arguments);
        this.baseCls = "goui-avatar";
    }
    set displayName(displayName) {
        this.text = this.initials(displayName);
        this.title = displayName;
        let j = 0;
        for (let i = 0, l = this.displayName.length; i < l; i++) {
            j += displayName.charCodeAt(i);
        }
        this.el.style.backgroundColor = "#" + Avatar.colors[j % Avatar.colors.length];
    }
    get displayName() {
        return this.title;
    }
    set backgroundImage(imgUrl) {
        this.el.style.backgroundImage = imgUrl ? "url(" + imgUrl + ")" : "none";
        if (imgUrl) {
            this.text = "";
        }
    }
    get backgroundImage() {
        return this.el.style.backgroundImage;
    }
    /**
     * Grabs the first char of the first and last word.
     *
     * @param {string} name
     * @returns {string}
     */
    initials(name) {
        const parts = name.split(" "), l = parts.length;
        if (l > 2) {
            parts.splice(1, l - 2);
        }
        return parts.map((name) => name.substr(0, 1).toUpperCase()).join("");
    }
}
Avatar.colors = [
    'C62828', 'AD1457', '6A1B9A', '4527A0', '283593', '1565C0', '0277BD', '00838F',
    '00695C', '2E7D32', '558B2F', '9E9D24', 'F9A825', 'FF8F00', 'EF6C00', '424242'
];
/**
 * Shorthand function to create {@see Avatar}
 *
 * @param config
 */
export const avatar = (config) => createComponent(new Avatar(), config);
//# sourceMappingURL=Avatar.js.map