import { BaseEntity, Component, ComponentEventMap, DefaultEntity, EntityID, Listener, ObservableListenerOpts, Toolbar } from "@intermesh/goui";
export interface DetailPanelEventMap<Type, EntityType extends BaseEntity = DefaultEntity> extends ComponentEventMap<Type> {
    /**
     * Fires when entity is loaded
     */
    load: (detailPanel: Type, entity: EntityType) => false | void;
    /**
     * Fires when the panel is reset
     *
     * @param detailPanel
     */
    reset: (detailPanel: Type) => void;
}
export interface DetailPanel<EntityType extends BaseEntity = DefaultEntity> extends Component {
    on<K extends keyof DetailPanelEventMap<this, EntityType>, L extends Listener>(eventName: K, listener: Partial<DetailPanelEventMap<this, EntityType>>[K], options?: ObservableListenerOpts): L;
    un<K extends keyof DetailPanelEventMap<this>>(eventName: K, listener: Partial<DetailPanelEventMap<this>>[K]): boolean;
    fire<K extends keyof DetailPanelEventMap<this, EntityType>>(eventName: K, ...args: Parameters<DetailPanelEventMap<any, EntityType>[K]>): boolean;
}
/**
 * Detail panel
 *
 * Used to show an entity when selected in the grid.
 */
export declare abstract class DetailPanel<EntityType extends BaseEntity = DefaultEntity> extends Component {
    entityName: string;
    protected titleCmp?: Component;
    protected entity?: EntityType;
    protected readonly scroller: Component;
    private detailView;
    readonly toolbar: Toolbar;
    protected constructor(entityName: string);
    private get legacyDetailView();
    protected addCustomFields(): void;
    protected addLinks(): void;
    protected addComments(): void;
    protected addFiles(): void;
    protected addHistory(): void;
    private createToolbar;
    set title(title: string);
    get title(): string;
    load(id: EntityID): Promise<this>;
    reset(): void;
    private legacyOnLoad;
}
//# sourceMappingURL=DetailPanel.d.ts.map