import { TextField } from "./TextField";
import { Config } from "../Observable";
import { FieldEventMap } from "./Field";
import { DateTime } from "../../util";
import { InputField } from "./InputField";
export interface TimeField {
    get input(): HTMLInputElement;
}
/**
 * TimeField component
 *
 * Time input based on the browser's locale.
 *
 * @property value Outputs time in "H:i" format. eg. 09:30 or 15:30 {@link DateTime.format}
 *
 * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/time
 */
export declare class TimeField extends InputField {
    protected baseCls: string;
    constructor();
    set step(v: number);
    get step(): number;
    /**
     * The minimum number allowed
     *
     * The value of the time input is always in 24-hour format that includes leading zeros: hh:mm
     *
     * @param min
     */
    set min(min: string);
    get min(): string;
    /**
     * The maximum number allowed
     *
     * The value of the time input is always in 24-hour format that includes leading zeros: hh:mm
     *
     * @param max
     */
    set max(max: string);
    protected outputFormat(): string;
    /**
     * Get the date as DateTime object
     */
    getValueAsDateTime(): DateTime | undefined;
    set value(v: string | undefined);
    get value(): string | undefined;
}
/**
 * Shorthand function to create {@see TextField}
 *
 * @param config
 */
export declare const timefield: (config?: Config<TimeField, FieldEventMap<TextField>>) => TimeField;
//# sourceMappingURL=TimeField.d.ts.map