Ext.namespace('GO.leavedays');

GO.leavedays.UserPanel = function(config) {
	
	config = config || {};

	this.disapproveReason = "";
	
	config.layout = 'fit';
	config.width = 700;
	this.msgWindow = new Ext.Window({
		title: t("Reason why", "leavedays"),
		width: 400,
		height: 260,
		layout: 'form',
		modal: false,
		resizable: false,
		closeAction: 'hide',
		items: [
			new Ext.form.FormPanel({
				hideLabels: true,
				cls:'go-form-panel',
				items: [{
					xtype:'textarea',
					id:'ld-reason-why',
					name: 'comment',
					height: 155,
					anchor: '100%',
					listeners: {
						// Dirty hack; Ext.getCmp().getValue() does not work. See msgWindow.onSend below
						change: function(t, value) {
							this.disapproveReason = value;
						},
						scope: this
					}
				}]
			})
		],
		listeners: {
			show: function() {
				Ext.getCmp('ld-reason-why').focus(true, 100);
			},
			scope: this
		},
		buttons: [
			this.msgWindowSend = new Ext.Button({
				text: t('Send'),
				iconCls: 'ic-send',
				handler: function(){
					// this.msgWindow.onSend(this.msgWindow);
					this.msgWindow.onSend(this);
					this.msgWindow.hide();
				},scope:this
			})
		],
		onSend: Ext.emptyFn,
		onHide: function() {
			if(!this.switchbackRadio) {return;}
			this.switchbackRadio.setValue(true);
			Ext.getCmp('ld-reason-why').setValue('');
			this.disapproveReason = "";
		}
	});
	
	
	this.gridPanel = this._buildGridPanel();

	this.specialLeavePanel = new GO.leavedays.SpecialLeaveBudgetGrid();
	
	config.items = [
		new Ext.TabPanel({
			activeTab: 0,
			items: [
				this.gridPanel,
				this.specialLeavePanel,
				this.summaryPanel = new Ext.Panel({
					layout: "fit",
					title: t("Year summary", "leavedays"),
					autoScroll: true
				})
			]
		})
		
		
	];
	
	 
	this.summaryPanel.on('render', function(panel) {
		this._loadYearSummary();
	}, this);
	
	GO.leavedays.UserPanel.superclass.constructor.call(this,config);
	
	this.addEvents({'leavedaySaved':true});

}

Ext.extend( GO.leavedays.UserPanel, Ext.Panel, {
	
	_user_name : '',


	show : function(config) {
		GO.leavedays.UserPanel.superclass.show.call(this);
		
		if(this.gridPanel.store.baseParams['user_id'] != GO.leavedays.activeUserId || this.gridPanel.store.baseParams['year'] != GO.leavedays.activeYear){
			this.gridPanel.store.baseParams['user_id'] = GO.leavedays.activeUserId;
			this.gridPanel.store.baseParams['year'] = GO.leavedays.activeYear;
			this.gridPanel.store.load();

			this.specialLeavePanel.store.baseParams['user_id'] = GO.leavedays.activeUserId;
			this.specialLeavePanel.store.baseParams['year'] = GO.leavedays.activeYear;

			this._loadYearSummary();

			this._user_name = config['user_name'];
			this.summaryPanel.setTitle(t("Year summary", "leavedays")+': '+this._user_name+' ('+GO.leavedays.activeYear+')');
			this.specialLeavePanel.store.load();
		} else if (!GO.util.empty(config['empty'])) {
			this.gridPanel.store.baseParams['user_id'] = 0;
			this.gridPanel.store.load();
			this._user_name = '';
			this.summaryPanel.setTitle(t("Year summary", "leavedays"));
			this._loadYearSummary();
		}
	},

	reload : function() {
		this.gridPanel.store.load();

		this._loadYearSummary();
	},

	_buildGridPanel : function() {

		var columns = [{
			header: t("ID", "leavedays"),
			dataIndex: 'id',
			width:20,
			hidden: true
		},{
			header: t("First date", "leavedays"),
			dataIndex: 'first_date',
			xtype:'datecolumn',
			format: GO.settings.date_format,
			dateOnly: true,
		},{
			header: t("Last date", "leavedays"),
			dataIndex: 'last_date',
			xtype:'datecolumn',
			format: GO.settings.date_format,
			dateOnly: true,
		},{
			header: t("Type", "leavedays"),
			dataIndex: 'credit_type_name',
			sortable:false,
			align: 'right'
		},{
			header: t("Hours", "leavedays"),
			dataIndex: 'n_hours',
			width:dp(80),
			align: 'right'
		},{
			header: t("Hours nat. holidays", "leavedays"),
			dataIndex: 'n_nat_holiday_hours',
			width:dp(80),
			align: 'right'
		},{
			header: t("Description", "leavedays"),
			dataIndex: 'description',
			width:120,
			align: 'right'
		},{
			header: t("Created at"),
			dataIndex: 'ctime',
			xtype: "datecolumn",
			align: 'right',
			hidden: true
		},{
			header: t("Modified at"),
			dataIndex: 'mtime',
			xtype: "datecolumn",
			align: 'right',
			hidden: true
		}];
			
		const icons = {
			appr: '<i class="icon">check</i>',
			disa: '<i class="icon">clear</i>',
			none: '<i class="icon">warning</i>'
		};
		
		if(GO.leavedays.currentUserIsManager){
			
			const radioRenderer = function(value, meta, r, row, col) {
				let managerUserIds = [];
				const muid = r.get('manager_user_id');
				if(typeof muid === 'number') {
					managerUserIds.push(muid);
				} else if (typeof muid === 'string') { // In theory, an employee has more managers as per 6.5-ish
					managerUserIds = muid.split(',');
				}
				if(managerUserIds.indexOf(GO.settings.user_id) === -1 && !GO.settings.modules.leavedays.write_permission) {
					return '';
				}
				
				
				const id = Ext.id();
				Ext.defer(function () {
					new Ext.form.Radio({
						renderTo: id,
						name: 'ld-status-'+row,
						checked: r.get('status')===columns[col].emptyGroupText,
						handler: function (me, checked) { 
							
							if(!checked) {
								this.msgWindow.switchbackRadio = me;
								return;
							}
							
							this.msgWindow.onSend = function(scope) {
								// Ext.getCmp().getValue() returns undefined, so we set an attribute to the scope and retrieve it below instead
								GO.request({
									url:'leavedays/leaveday/update',
									params:{
										id:r.id,
										user_id:r.data.user_id,
										status:columns[col].emptyGroupText,
										reasonWhyMsg: scope.disapproveReason || ""
									},
									success:function(){
										scope.disapproveReason = "";
										Ext.getCmp('ld-reason-why').setValue('')
									}
								});
								scope.switchbackRadio = null;
							};
							
							if(columns[col].emptyGroupText == 2) {
								this.msgWindow.show();
								
							} else {
								GO.request({
									url:'leavedays/leaveday/update',
									params:{
										id:r.id,
										user_id:r.data.user_id,
										status:columns[col].emptyGroupText
									},
									scope: this,
									success:function(response, options, result){
									},
									fail: function(response, options, result) {
										Ext.MessageBox.alert(t('Warning'), t(result.data.feedback));
										this.gridPanel.store.reload();
									}
								});
							}
						},
						scope: this
					});
				}, 50, this);
				return String.format('<div id="{0}"></div>', id);
			};
			
			
			columns.push({
				header:icons['appr'],
				width: dp(64),
				style: {
					"overflow" : "visible"
				},
				emptyGroupText: 1, //abusing this property to pass value to radio select
				sortable:false,
				align:"center",
				hideable:false,
				menuDisabled:true,
				resizable:false,
				renderer:{
					fn: radioRenderer,
					scope: this 
				} 
			},{
				header:icons['disa'],
				width: dp(64),
				align:"center",
				emptyGroupText: 2,
				sortable:false,
				hideable:false,
				menuDisabled:true,
				resizable:false,
				renderer:{
					fn: radioRenderer,
					scope: this 
				} 
			},{
				header:icons['none'],
				width: dp(64),
				align:"center",
				emptyGroupText: 0,
				sortable:false,
				hideable:false,
				menuDisabled:true,
				resizable:false,
				renderer:{
					fn: radioRenderer,
					scope: this 
				} 
			});
		} else {
			columns.push({ 
				header: t("Status"), 
				renderer:function(v, meta, record){

				  if(record.get('status')==0) {
					  return '';
				  }
				  if(record.get('status')==1) {
					  return icons['appr'];
				  }
				  if(record.get('status')==2) {
					  return icons['disa'];
				  }
			  }
			});
		}
						
		var gridPanelConfig = {
			plugins: this.checkColumn ? this.checkColumn : [],
			autoScroll: true,
			layout: "fit",
			store: new GO.data.JsonStore({
				url: GO.url('leavedays/leaveday/store'),
				remoteSort:true,
				fields: ['id', 'user_id', 'first_date', 'last_date','n_hours', 'n_nat_holiday_hours', 'description','ctime','mtime', 'status', 'has_negative_credit', 'credit_type_name', 'manager_user_id'],
				listeners: {
					load: function() {
						this.enable();
					},
					scope: this
				},
				scope: this
			}),
			noDelete: !GO.settings.modules.leavedays.write_permission,
			paging: true,
			cm: new Ext.grid.ColumnModel({
				defaults:{
					sortable:true
				},
				columns:columns
			}),
			view: new Ext.grid.GridView({
				emptyText: t("No items to display"),
				getRowClass: function(record, rowIndex, rp, ds){ // rp = rowParams
					if(record.data.has_negative_credit) {
						rp.tstyle += 'color:red;';
					}
				}
			}),
			sm: new Ext.grid.RowSelectionModel(),
			loadMask: true,
			clicksToEdit: 1
		};
		
		
			this.addButton = new Ext.Button({
				iconCls: 'ic-add',
				text: t("Add"),
				handler: function(){
					GO.leavedays.showLeavedayDialog(0);
					
					if(!this.saveListenerAdded){
						this.saveListenerAdded=true;
						GO.leavedays.leavedayDialog.on('save',function(){
							this.gridPanel.store.load();
							this._loadYearSummary();
						}, this);
					}
				},
				scope: this
			});
			this.delButton = new Ext.Button({
				iconCls: 'ic-delete',
				text: t("Delete"),
				handler: function(){
					this.gridPanel.deleteSelected();
				},
				scope: this
			});
			
			gridPanelConfig.tbar = [this.addButton,this.delButton];
		
		gridPanelConfig.title =  t("Holiday request", "leavedays");
		
		var gridPanel = new GO.grid.GridPanel(gridPanelConfig);
				
		gridPanel.store.on('load',function(){
			this._loadYearSummary();
		}, this);
		
		gridPanel.on('rowdblclick',function(grid,rowIndex,event){
			var record = grid.store.getAt(rowIndex);

			if(record.get('status') != 0 && !GO.settings.modules.leavedays.write_permission) {
				return false;
			}
			GO.leavedays.showLeavedayDialog(record.data['id']);

			if(!this.saveListenerAdded){
				this.saveListenerAdded=true;
				GO.leavedays.leavedayDialog.on('save',function(){
					this.gridPanel.store.load();
					this._loadYearSummary();
				}, this);
			}

		}, this);
				
		return gridPanel;
		
	},
	
	
	_loadYearSummary : function() {
		
		if(this.summaryPanel.rendered) {
			this.summaryPanel.load({
				url: GO.url('leavedays/leaveday/yearInfo'),
				params: {
					'userId' : GO.leavedays.activeUserId,
					'selectedYear' : GO.leavedays.activeYear
				}
				,scope: this
				,callback: function(panel,success,action) {

					if(typeof(this.addButton)=='object') {
						this.addButton.setDisabled(GO.util.empty(action.responseText));
					}
					if(typeof(this.delButton)=='object') {
						this.delButton.setDisabled(GO.util.empty(action.responseText));
					}
				}
			});
		}
	}
	
});
