go.Modules.register("business", "support", {
	mainPanel: "go.modules.business.support.MainPanel",
	title: t("Support"),
	systemSettingsPanels: [
		"go.modules.business.support.SystemSettingsPanel",
	],
	userSettingsPanels: [
		"go.modules.business.support.SettingsPanel"
	],
	initModule: function () {

		go.Entities.get("Task").links.push({
			filter: "support",
			iconCls: "entity ic-live-help red",
			entity: "Task",
			title: t("Ticket", "support", "business"),
			linkWindow: function (entity, entityId) {
				return new go.modules.community.tasks.TaskDialog({
					role: "support"
				});
			},

			linkDetail: function () {
				return new go.modules.community.tasks.TaskDetail({
					role: "support"
				});
			}
		});

		go.Alerts.on("beforeshow", function(alerts, alertConfig) {
			const alert = alertConfig.alert;
			if(alert.entity == "Task") {

				//replace panel promise
				alertConfig.panelPromise = alertConfig.panelPromise.then(async (panelCfg) => {
					const task =  await go.Db.store("Task").single(alert.entityId);
					const tasklist = await go.Db.store("Tasklist").single(task.tasklistId);

					if(tasklist.role == "support") {
						panelCfg.handler = function() {
							go.Router.goto("support/" + alert.entityId);
						}
					}

					return panelCfg;
				});
			}
		});


		async function showBadge() {
			const count = await go.Jmap.request({method: "Task/countMine", params: {role: "support"}});

			GO.mainLayout.setNotification('support', count,'orange');
		}




		GO.mainLayout.on("authenticated", () => {
			if(go.Modules.isAvailable("business", "support")) {

				go.Db.store("Task").on("changes", () => {
					showBadge();
				});

				showBadge();
			}
		})



	},
});

