go.modules.business.newsletters.SentItemsGrid = Ext.extend(go.grid.GridPanel, {
	disabled: true,
	mobile: {
		title: t("Send"),
	},
	initComponent: function() {
		this.tbar = [
			{
				xtype: 'tbtitle',
				desktop: {
					text: t('Sent items')
				}
      },
			'->',
      {
        xtype:"button",
        iconCls: "ic-send",
        text: t("Compose"),
        handler: this.compose,
        scope: this
      },{
				iconCls: 'ic-settings',
				tooltip: t("Manage"),
				handler: function() {
					const win = new go.modules.business.newsletters.TemplatesWindow();
					win.show();
				}
			}
    ];


		this.store = new go.data.Store({
			fields: [
				'id',
				'subject',
				'numSent',
				'numTotal',
				'addressListId',
				{
					name: 'paused',
					type: 'bool'
				},
				{
					name: 'startedAt',
					type: 'date'
				}, {
					name: 'finishedAt',
					type: 'date'
				},
				{
					name: 'creator',
					type: 'relation'
				}
			],
			entityStore: "Newsletter",
			sortInfo: {
				field: "startedAt",
				direction: "DESC"
			}
		});

		const actions = this.initRowActions();

		this.plugins = [actions];

		this.columns = [
			{
				id: 'subject',
				header: t('Subject'),
				dataIndex: 'subject',
				sortable: true
			},
			{
				header: t('Status'),
				dataIndex: 'paused',
				renderer: function (v, meta, record) {
					meta.style = 'cursor:pointer';
					let s = record.data.numSent + " / " + record.data.numTotal;

					if (record.data.numSent < record.data.numTotal) {
						s += record.data.paused ? ' <i class="icon">play_arrow</i>' : ' <i class="icon">pause</i>';
					}

					let errors = false;

					for (let id in record.json.entities) {
						if (record.json.entities[id].error) {
							errors = true;
						}
					}

					if (errors) {
						s += ' <i class="icon">error</i>';
					}

					return s;
				}
			},
			{
				xtype: "datecolumn",
				header: t('Started at'),
				dataIndex: 'startedAt',
				sortable: true
			}, {
				xtype: "datecolumn",
				header: t('Finished at'),
				dataIndex: 'finishedAt',
				sortable: true
			},
			{
				header: t("Created by"),
				dataIndex: 'creator',
				renderer: function (user) {
					return user ? user.displayName : t("Unknown user");
				},
				sortable: true
			},
			actions
		];

		this.viewConfig = {
			forceFit: true,
			autoFill: true
		};

		go.modules.business.newsletters.SentItemsGrid.superclass.initComponent.call(this);

		this.on("rowdblclick", function (grid, rowIndex, e) {
			const record = grid.getStore().getAt(rowIndex);
			this.edit(record.data.id);
		}, this);

		this.on("cellclick", function (grid, rowIndex, columnIndex, e) {

			const record = grid.getStore().getAt(rowIndex);  // Get the Record
			const fieldName = grid.getColumnModel().getDataIndex(columnIndex);
			if (e.target.innerHTML == 'error') {
				return this.showErrors(record);
			}

			if (fieldName != 'paused' || record.data.numSent == record.data.numTotal) {
				return;
			}
			let paused = record.get(fieldName);
			let update = {};
			update[record.id] = {paused: !paused};

			go.Db.store("Newsletter").set({
				update: update
			});

		}, this);
	},

	showErrors: function (record) {

		let errors = "";

		for (let id in record.json.entities) {
			if (record.json.entities[id].error) {
				errors += Ext.util.Format.htmlEncode(record.json.entities[id].error) + "<br />";
			}
		}

		GO.errorDialog.show(errors, t("Errors"));

	},


	compose: function () {
		go.Db.store("AddressList").single(this.addressListId).then((addressList) => {
			if(Ext.isEmpty(addressList.entities)) {
				Ext.MessageBox.alert(t("Warning"),t("This list has no recipients. Please add some recipients.") );
				return;
			}
			let dlg = new go.modules.business.newsletters.Composer();
			dlg.setValues({
				addressListId: this.addressListId
			}).show();
		});
		// let dlg = new go.modules.business.newsletters.Composer();
		// dlg.setValues({
		// 	addressListId: this.addressListId
		// }).show();
	},

	setAddressListId: function (addressListId) {
		this.addressListId = addressListId;
		this.setDisabled(!addressListId);
	},

	initRowActions: function () {

		let actions = new Ext.ux.grid.RowActions({
			menuDisabled: true,
			hideable: false,
			draggable: false,
			fixed: true,
			header: '',
			hideMode: 'display',
			keepSelection: true,

			actions: [{
				iconCls: 'ic-more-vert'
			}]
		});

		actions.on({
			action: function (grid, record, action, row, col, e, target) {
				this.showMoreMenu(record, e);
			},
			scope: this
		});

		return actions;

	},


	showMoreMenu: function (record, e) {
		if (!this.moreMenu) {
			this.moreMenu = new Ext.menu.Menu({
				items: [
					{
						itemId: "edit",
						iconCls: 'ic-edit',
						text: t("Edit"),
						handler: function () {
							this.edit(this.moreMenu.record.id);
						},
						scope: this
					},{
						itemId: 'delete',
						iconCls: 'ic-delete',
						text: t("Delete"),
						handler: () => {
							Ext.MessageBox.confirm(t('Please confirm'),
								t('This will entirely delete your newsletter. Are you sure you wish to continue?'),
							(btn) => {
								if (btn === 'yes') {
									this.store.entityStore.destroy(this.moreMenu.record.id).catch((e) => {
										GO.errorDialog.show(e);
									});
								}
							}, this);
						},
						scope: this
					},{
						itemId: 'log',
						iconCls: 'ic-receipt',
						text: t("Shipping report","newsletters"),
						handler: (elm,evt) => {
							Ext.getBody().mask(t("Exporting..."));

							return go.Jmap.request({
								method: 'Newsletter/deliveryReport',
								params: {'id': this.moreMenu.record.id, 'extension': 'csv'}
							}).then(function (response) {
								go.util.downloadFile(go.Jmap.downloadUrl(response.blobId));
							}).catch(function(response) {
								Ext.MessageBox.alert(t("Error"), response.message);
							}).finally(function() {
								Ext.getBody().unmask();
							});
						},
						scope: this
					}
				]
			});
		}
		// Added the delete button but not sure about the actual use case. For now, it is disabled and hidden.
		this.moreMenu.getComponent("edit").setDisabled(record.get("permissionLevel") < go.permissionLevels.manage);
		this.moreMenu.getComponent("delete").setDisabled(record.get("permissionLevel") < go.permissionLevels.manage);
		this.moreMenu.getComponent("log").setDisabled(record.get("permissionLevel") < go.permissionLevels.manage);
		this.moreMenu.getComponent("log").setVisible(!go.util.empty(record.get("finishedAt")));

		this.moreMenu.record = record;

		this.moreMenu.showAt(e.getXY());
	},
	edit: function (id) {
		const dlg = new go.modules.business.newsletters.Composer();
		dlg.load(id).show();
	}

});
