go.modules.business.finance.DocumentTypeGrid = Ext.extend(go.grid.GridPanel, {
	autoHeight: true,
	viewConfig: {
		scrollOffset: 0,
		forceFit: true,
		autoFill: true,
		totalDisplay: false
	},
	title: t("Type"),
	hideHeaders: true,
	multiSelectToolbarEnabled : false,
	initComponent: function () {
		var selModel = new Ext.grid.RowSelectionModel({
			singleSelect: true
		});

		Ext.apply(this, {

			store: new Ext.data.ArrayStore({
				autoDestroy: false,
				xtype: "arraystore",
				fields: [
					'value',
					'display'
				],
				id: 0,
				data: [
					['quote', t('Quotes')],
					['salesorder', t('Sales orders')],
					['purchaseorder', t('Purchase orders')],
					['purchaseinvoice', t('Purchase invoices')],
					['salesinvoice', t('Sales invoices')],
					['payments', t('Payments')]
				]
			}),
			selModel: selModel,
			columns: [
				// selModel,
				{
					id: 'name',
					header: t('Name'),
					sortable: false,
					dataIndex: 'display',
					hideable: false,
					draggable: false,
					menuDisabled: true
				}
			],
			stateful: true
		});

		go.modules.business.finance.DocumentTypeGrid.superclass.initComponent.call(this);
	}
});
