Ext.define('go.modules.business.catalog.ArticleCombo', {
	extend: go.form.ComboBox,
	fieldLabel: t("Article"),
	hiddenName: 'articleId',
	tpl: new Ext.XTemplate(
		'<tpl for=".">',
		'<div class="x-combo-list-item">' +
		'{name} <small>{number}</small>' +
		'</div>',
		'</tpl>'
	),
	emptyText: t("Select article..."),
	displayField : 'name',
	valueField: 'id',
	triggerAction: 'all',
	pageSize: 50,
	mode:'remote',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: true,

	store: {
		xtype: "gostore",
		id: "id",
		fields: ['id', 'name', 'number', 'vatRateId', 'cost', 'price'],
		entityStore: "Article"
	},
	setBusinessId :  function(businessId) {
		this.store.setFilter("business", {businessId: businessId});
	}
});

Ext.reg("articlecombo",go.modules.business.catalog.ArticleCombo);