/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { Component } from "../Component.js";
import { DateTime } from "../../util/DateTime.js";
import { DateField } from "../form/DateField.js";
import { Form } from "../form/Form.js";
import { Frequency, RecurrenceRule } from "../../util/Recurrence.js";
import { Listener, ObservableListenerOpts } from "../Observable.js";
import { NumberField } from "../form/NumberField.js";
import { CardContainer, CardContainerEventMap } from "../CardContainer.js";
export interface RecurrencePickerEventMap<Type> extends CardContainerEventMap<Type> {
    select: (picker: Type, rule: RecurrenceRule | undefined) => false | void;
}
export interface RecurrencePicker {
    on<K extends keyof RecurrencePickerEventMap<this>, L extends Listener>(eventName: K, listener: Partial<RecurrencePickerEventMap<this>>[K], options?: ObservableListenerOpts): L;
    fire<K extends keyof RecurrencePickerEventMap<this>>(eventName: K, ...args: Parameters<RecurrencePickerEventMap<Component>[K]>): boolean;
}
type FrequencyDefaults = [text: string, plural: string, repeatDefault: number, untilDefault: string, frequencyText: string];
export declare class RecurrencePicker extends CardContainer {
    protected baseCls: string;
    form: Form;
    menu: Component;
    weekOfMonth: number;
    startDate: DateTime;
    count: NumberField;
    until: DateField;
    rule: RecurrenceRule | undefined;
    static frequencies: {
        [freq: string]: FrequencyDefaults;
    };
    constructor(startDate: DateTime);
    quickMenuItems(): (Component | import("../Button.js").Button)[];
    createCustomRule(values: any): RecurrenceRule;
    setStartDate(date: DateTime): void;
    changeFrequency(f: Frequency): void;
    private getSuffix;
    setValue(rrule: RecurrenceRule | undefined): void;
}
export {};
//# sourceMappingURL=RecurrencePicker.d.ts.map