import { Field } from "./Field";
export class InputField extends Field {
    constructor() {
        super();
        // we handle it with the native change event here
        this.fireChangeOnBlur = false;
    }
    /**
     * Get the DOM HTMLInputElement
     */
    get input() {
        return this._input;
    }
    set title(title) {
        super.title = title;
        if (this._input) {
            this._input.title = this.title;
        }
    }
    focus(o) {
        if (!this._input) {
            super.focus(o);
        }
        else {
            this._input.focus(o);
            this.fire("focus", this, o);
        }
    }
    createControl() {
        this._input = this.createInput();
        return this._input;
    }
    createInput() {
        const control = document.createElement("input");
        control.on("change", () => {
            this.fireChange();
        });
        if (this.invalidMsg) {
            this.applyInvalidMsg();
        }
        return control;
    }
    setInvalid(msg) {
        super.setInvalid(msg);
        if (this.rendered) {
            this.applyInvalidMsg();
        }
    }
    clearInvalid() {
        super.clearInvalid();
        this.applyInvalidMsg();
    }
    internalSetValue(v) {
        this._input.value = v !== undefined && v !== null ? v.toString() : "";
    }
    internalGetValue() {
        return this._input.value;
    }
    set name(name) {
        super.name = name;
        this._input.name = this.name;
    }
    get name() {
        return super.name;
    }
    set type(type) {
        if (this._input instanceof HTMLInputElement)
            this._input.type = type;
    }
    get type() {
        return this._input.type;
    }
    /**
     * Autocomplete value
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete
     *
     * @param autocomplete
     */
    set autocomplete(autocomplete) {
        this._input.autocomplete = this.autocomplete;
    }
    get autocomplete() {
        return this._input.autocomplete;
    }
    /**
     * When the field is empty this will be displayed inside the field
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/placeholder
     *
     * @param placeholder
     */
    set placeholder(placeholder) {
        if (!(this._input instanceof HTMLSelectElement))
            this._input.placeholder = placeholder;
        if (this.placeholder !== " ") {
            this.el.classList.add("no-floating-label");
        }
    }
    get placeholder() {
        if (!(this._input instanceof HTMLSelectElement))
            return this._input.placeholder;
        else
            return "";
    }
    /**
     * Make field read only
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly
     * @param readOnly
     */
    set readOnly(readOnly) {
        super.readOnly = readOnly;
        if (!(this._input instanceof HTMLSelectElement))
            this._input.readOnly = this.readOnly;
    }
    get readOnly() {
        return super.readOnly;
    }
    /**
     * Make field required
     */
    get required() {
        return super.required;
    }
    set required(required) {
        super.required = required;
        this._input.required = this.required;
    }
    get disabled() {
        return super.disabled;
    }
    set disabled(disabled) {
        this._input.disabled = disabled;
        super.disabled = disabled;
    }
    validate() {
        super.validate();
        //this implements the native browser validation
        if (this._input) {
            this.setValidityState(this._input);
        }
    }
}
//# sourceMappingURL=InputField.js.map