import { Form, Listener, Observable, Window, WindowEventMap } from "@intermesh/goui";
export interface LoginEventMap<T extends Observable> extends WindowEventMap<T> {
    cancel: () => void;
    login: () => void;
}
export interface Login extends Window {
    on<K extends keyof LoginEventMap<this>, L extends Listener>(eventName: K, listener: Partial<LoginEventMap<this>>[K]): L;
    un<K extends keyof LoginEventMap<this>>(eventName: K, listener: Partial<LoginEventMap<this>>[K]): boolean;
    fire<K extends keyof LoginEventMap<this>>(eventName: K, ...args: Parameters<LoginEventMap<this>[K]>): boolean;
}
export declare class Login extends Window {
    private loginForm;
    private otpForm;
    private loginToken;
    private cardContainer;
    private registerForm;
    private forgotPasswordForm;
    constructor();
    private showForgotPassword;
    private showRegisterForm;
    focus(o?: FocusOptions): void;
    login(form: Form): Promise<void>;
    private onLoginSuccess;
}
//# sourceMappingURL=Login.d.ts.map