import { Config } from "../Observable";
import { FieldEventMap } from "./Field";
import { InputField } from "./InputField";
/**
 * Text Area component
 *
 * @see Form
 */
export declare class TextAreaField extends InputField {
    protected baseCls: string;
    private _autoHeight;
    protected createInput(): HTMLInputElement | HTMLSelectElement | HTMLTextAreaElement;
    /**
     * Let the textarea grow to it's content
     *
     * @param v
     */
    set autoHeight(v: boolean);
    get autoHeight(): boolean;
    private resize;
}
/**
 * Shorthand function to create {@see TextAreaField}
 *
 * @param config
 */
export declare const textarea: (config?: Config<TextAreaField, FieldEventMap<TextAreaField>>) => TextAreaField;
//# sourceMappingURL=TextareaField.d.ts.map