/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { FieldEventMap } from "./Field.js";
import { Store } from "../../data/index.js";
import { Config } from "../Observable";
import { InputField } from "./InputField";
/**
 * Select component option
 *
 * By default, it should have a "value" and "name" property. This can be changed with the {@link Select.valueField} and
 * {@link Select.textRenderer}.
 */
type SelectOption = {
    [key: string]: any;
};
export interface SelectField {
    get input(): HTMLSelectElement;
}
/**
 * Select field
 *
 * @see Form
 */
export declare class SelectField extends InputField {
    baseCls: string;
    /**
     * The field of the select options that is used as value
     */
    valueField: string;
    protected fireChangeOnBlur: boolean;
    /**
     * Renderer function. Defaults to returning a 'name' property.
     *
     * @param record
     */
    textRenderer?: (record: {
        [key: string]: any;
    }) => string;
    private _store?;
    private _options?;
    protected createInput(): HTMLSelectElement;
    protected onFocusIn(e: FocusEvent): void;
    /**
     * Redraw the options. Can be useful when this.textRenderer() produces another result
     */
    drawOptions(): void;
    protected internalRender(): HTMLElement;
    /**
     * Provide select input with options
     *
     * It should have at least have a field that corresponds with {@link Select.valueField}
     *
     * By default, it should have a "value" and "name" property. This can be changed with the {@link Select.valueField} and
     * {@link Select.textRenderer}.
     *
     * @param opts
     */
    set options(opts: SelectOption[]);
    get options(): SelectOption[];
    /**
     * A store to provide the {@link Select.options}.
     * @param store
     */
    set store(store: Store);
    get store(): Store | undefined;
    set value(v: any);
    get value(): any;
}
/**
 * Shorthand function to create {@see SelectField}
 *
 * @param config
 */
export declare const select: (config?: Config<SelectField, FieldEventMap<SelectField>>) => SelectField;
export {};
//# sourceMappingURL=SelectField.d.ts.map