go.Modules.register("business", "support", {
	mainPanel: "go.modules.business.support.MainPanel",
	title: t("Support"),
	systemSettingsPanels: [
		"go.modules.business.support.SystemSettingsPanel",
	],
	userSettingsPanels: [
		"go.modules.business.support.SettingsPanel"
	],
	entities: [
		{
			name: "SupportList",
			relations: {
				group: {store: "TaskListGrouping", fk: "groupingId"},
				creator: {store: "UserDisplay", fk: "createdBy"},
				groups: {name: 'Groups'}
			}
		},
		{
			name: "SupportTicket",
			links: [{
				iconCls: "entity ic-live-help red",
				linkWindow: function (entity, entityId) {
					return new go.modules.community.tasks.TaskDialog({
						entityStore: this.support ? "SupportTicket" : "Task",
						role: "support"
					});
				},

				linkDetail: function () {
					return new go.modules.community.tasks.TaskDetail({
						entityStore: "SupportTicket",
						support: true
					});
				},

				linkDetailCards: function () {

					const incomplete = new go.modules.community.tasks.TaskLinkDetail({
						title: t("Incomplete tickets"),
						support: true,
						link: {
							entity: "SupportTicket"
						}
					});

					incomplete.store.setFilter('completed', {complete: false});

					const completed = new go.modules.community.tasks.TaskLinkDetail({

						title: t("Completed tickets"),
						support: true,
						link: {
							entity: "SupportTicket"
						}
					});
					completed.store.setFilter('completed', {complete: true});

					return [
						incomplete,

						completed]
				}
			}],
			relations: {
				creator: {store: "UserDisplay", fk: "createdBy"},
				modifier: {store: "UserDisplay", fk: "modifiedBy"},
				responsible: {store: 'UserDisplay', fk: 'responsibleUserId'},
				tasklist: {store: 'SupportList', fk: 'tasklistId'},
				categories: {store: "TaskCategory", fk: "categories"},
			},

			/**
			 * Filter definitions
			 *
			 * Will be used by query fields where you can use these like:
			 *
			 * name: Piet,John age: < 40
			 *
			 * Or when adding custom saved filters.
			 */
			filters: [
				{
					wildcards: false,
					name: 'text',
					type: "string",
					multiple: false,
					title: t("Query")
				},
				{
					title: t("Commented at"),
					name: 'commentedat',
					multiple: false,
					type: 'date'
				}, {
					title: t("Modified at"),
					name: 'modifiedat',
					multiple: false,
					type: 'date'
				}, {
					title: t("Modified by"),
					name: 'modifiedBy',
					multiple: true,
					type: 'go.users.UserCombo',
					typeConfig: {value: null}
				}, {
					title: t("Created at"),
					name: 'createdat',
					multiple: false,
					type: 'date'
				}, {
					title: t("Created by"),
					name: 'createdby',
					multiple: true,
					type: 'go.users.UserCombo',
					typeConfig: {value: null}
				},
				{
					title: t("List"),
					name: 'tasklistid',
					multiple: false,
					type: "go.modules.community.tasks.TasklistCombo"
				},
				{
					title: t("Progress"),
					name: 'progress',
					multiple: false,
					type: "go.modules.community.tasks.ProgressCombo"
				},
				{
					name: 'title',
					title: t("Title"),
					type: "string",
					multiple: true
				},{
					title: t("Due"),
					name: 'due',
					multiple: false,
					type: 'date'
				},{
					title: t("Start"),
					name: 'start',
					multiple: false,
					type: 'date'
				},{
					title: t("Responsible"),
					name: 'responsibleUserId',
					multiple: false,
					type: 'go.users.UserCombo',
					typeConfig: {value: null}
				}
				]
		}
	],
	initModule: function () {

		go.Alerts.on("beforeshow", function(alerts, alertConfig) {
			const alert = alertConfig.alert;
			if(alert.entity == "Task") {

				//replace panel promise
				alertConfig.panelPromise = alertConfig.panelPromise.then(async (panelCfg) => {
					const task =  await go.Db.store("Task").single(alert.entityId);
					const tasklist = await go.Db.store("Tasklist").single(task.tasklistId);

					if(tasklist.role == "support") {
						panelCfg.handler = function() {
							go.Router.goto("support/" + alert.entityId);
						}
					}

					return panelCfg;
				});
			}
		});


		async function showBadge() {
			const count = await go.Jmap.request({method: "SupportTicket/countMine"});

			GO.mainLayout.setNotification('support', count,'orange');
		}

		GO.mainLayout.on("authenticated", () => {
			if(go.Modules.isAvailable("business", "support")) {

				go.Db.store("SupportTicket").on("changes", () => {
					showBadge();
				});

				showBadge();
			}
		})
	}
});

