go.modules.business.studio.WizardActivationPanel = Ext.extend(Ext.Panel, {
	initComponent: function() {
		Ext.apply(this, {
			cls: 'go-form',
			layout: 'form',
			items: this.initFormItems()
		});
		go.modules.business.studio.WizardActivationPanel.superclass.initComponent.call(this);
	},

	initFormItems: function() {
		this.enableCB = new Ext.form.Checkbox({
			name: 'module.enabled',
			fieldLabel: '',
			hideLabel: true,
			boxLabel: t('Enable module'),
			hint: t('Make the module available for the end user'),
			checked: this.data.enabled

		});

		this.lockCB = new Ext.form.Checkbox({
			name: 'studio.locked',
			fieldLabel: '',
			hideLabel: true,
			boxLabel: t('Lock code generation'),
			hint: t('Disable editing module settings and regeneration of code'),
			hidden: true,
			checked: false
		});

		this.overwriteCB = new Ext.ux.form.XCheckbox({
			name: 'doOverwrite',
			fieldLabel: '',
			hideLabel: true,
			allowBlank: false,
			boxLabel: t('Overwrite existing code'),
			hint: t('Regenerate any client side code. WARNING: this will undo any manual modifications to earlier code!'),
			listeners: {
				invalid: function(cb, msg) {
					Ext.MessageBox.alert(t("Warning"), t("Please allow this wizard to overwrite the existing code", "studio", "business"));
				},
				scope: this
			}
		});

		this.betaCB = new Ext.ux.form.XCheckbox({
			name: 'moduleInBeta',
			fieldLabel: '',
			hideLabel: true,
			checked: true,
			boxLabel: t('This module is in beta-mode'),
			hint: t('When this checkbox is checked, the module is considered to be in beta or unstable mode. To remove this status, please uncheck this checkbox and regenerate the code.')
		});


		return [{
			xtype: 'fieldset',
			items: [
				this.enableCB,
				this.lockCB,
				this.betaCB
			]
		},
			{
				xtype: 'fieldset',
				items: [
					this.overwriteCB
				]
			}]
	}
});