/* global go */

go.Modules.register("{packageName}", '{moduleName}', {
    mainPanel: "{namespace}.MainPanel",
    title: t("{moduleTitle}"),

    entities: [{
        name: "{itemEntityName}",
        relations: {
            creator: { store: "UserDisplay", fk: "createdBy" },
            modifier: { store: "UserDisplay", fk: "createdBy" }
        },
        filters: [{
            name: 'text',
            type: "string",
            multiple: false,
            title: t("Query")
        },
        {
            name: 'name',
            type: "string",
            multiple: true,
            title: t("Name")
        }, {
            title: t("Modified at"),
            name: 'modifiedat',
            multiple: false,
            type: 'date'
        }, {
            title: t("Modified by"),
            name: 'modifiedBy',
            multiple: true,
            type: 'string'
        }, {
            title: t("Created at"),
            name: 'createdat',
            multiple: false,
            type: 'date'
        }, {
            title: t("Created by"),
            name: 'createdby',
            multiple: true,
            type: 'string'
        }],
        links: [{
            iconCls: 'entity ic-note yellow',
            linkWindow: function (entity, entityId) {
                return new {namespace}.{itemEntityName}Dialog();
            },
            linkDetail: function () {
                return new {namespace}.{itemEntityName}Detail();
            }
        }]
        },{ 
            name: "{ownerEntityName}",
            relations: {
                creator: { store: "UserDisplay", fk: "createdBy" },
                modifier: { store: "UserDisplay", fk: "createdBy" }
            }
        }
    ],
    initModule: function () {

    },

    /**
    * Extra custom field types this module offers
    */
    customFieldTypes: [
        "{namespace}.customfield.{itemEntityName}"
    ],
});


