go.modules.business.finance.SelectBookWindow = Ext.extend(go.Window, {

	setLinkEntity: function (config) {
		this.linkConfig = config;
	},

	initComponent : function(){

		this.list = new GO.grid.SimpleSelectList(
			{
				store: new go.data.Store({
					fields: ['id', 'name', 'type'],
					entityStore: "FinanceBook"
				})
			}
		);

		this.list.on('click', function(dataview, index){
			const book = dataview.store.getAt(index);

			const dlg = new go.modules.business.finance.FinanceDocumentDialog({
				type: book.data.type
			});

			// dlg.bookCombo.setValue(book.data.id);
			this.linkConfig.data.bookId = book.data.id;
			dlg.setLinkEntity(this.linkConfig);
			dlg.createLinkButton.addLink(this.linkConfig.entity, this.linkConfig.entityId);
			dlg.show();

			this.list.clearSelections();

			this.close();
		},this);

		Ext.apply(this, {
			title: t("Select book", "finance", "business"),
			layout:'fit',
			closable:true,
			closeAction:'close',
			modal:false,
			height:400,
			width:600,
			items: new Ext.Panel({
				items: this.list,
				autoScroll:true,
				cls: 'go-form-panel'
			})
		});


		go.modules.business.finance.SelectBookWindow.superclass.initComponent.call(this);

		this.on("show", () => {
			this.list.store.load();
		})
	}
});
