go.modules.business.finance.FinanceDocumentDetailPayments = Ext.extend(Ext.Panel, {

	title: t("Payments"),
	collapsible: true,
	stateId: 'business-finance-detail-payments',
	// autoHeight: true,
	// maxHeight: 400,
	layout: "fit",

	totalPaid: function() {
		const records = this.paymentGrid.store.getRange();
		let total = 0;
		records.forEach((r) => {
			total += r.data.amount;
		});

		return total;
	},
	initComponent: function () {

		this.items = [
			this.paymentGrid = new go.modules.business.finance.PaymentGrid({
				autoHeight: true,
				maxHeight: 400,
				forEntity: true,
				plugins: [new Ext.grid.GridSummary()]
			})
		]

		this.bbar = [
			{
				iconCls: "ic-add",
				xtype: "button",
				text: t("Add payment"),
				handler: () => {
					const dlg = new go.modules.business.finance.PaymentDialog();

					const forDoc = this.ownerCt instanceof go.modules.business.finance.FinanceDocumentDetail;

					dlg.setValues({
						amount: this.ownerCt.data.totalPrice - this.totalPaid(),
						customerId: forDoc? this.ownerCt.data.customerId : this.ownerCt.data.id,
						documentId: forDoc ? this.ownerCt.data.id : null,
						businessId: forDoc ? this.ownerCt.data.book.businessId : null
					});
					dlg.show();

				}
			}
		];

		go.modules.business.finance.FinanceDocumentDetailPayments.superclass.initComponent.call(this);
	},
	onLoad: function (detailPanel) {

		if(detailPanel instanceof go.modules.business.finance.FinanceDocumentDetail) {
			this.paymentGrid.store.setFilter('source', {
				documentId: detailPanel.currentId
			});

			// Only show payments on invoices.
			if(detailPanel.data.book.type == 'salesinvoice' || detailPanel.data.book.type == 'salesorder') {
				this.show();
				this.paymentGrid.store.load();
			} else
			{
				this.hide();
			}
		} else
		{
			// for address book
			this.paymentGrid.store.setFilter('source', {
				customerId: detailPanel.currentId
			});
			this.paymentGrid.store.load();
		}


	}
});
