/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @copyright Copyright Intermesh
 * @author {authorName} <{email}>
 */

go.modules.business.catalog.SelectArticleWindow = Ext.extend(go.Window,
	{
		id: "catalog",
		title: t("Catalog"),
		width: dp(800),
		height: dp(600),
		layout: 'border',
		modal: true,

		initComponent: function () {

			this.createArticleGrid();

			this.sidePanel = new Ext.Panel({
				layout: "anchor",
				defaults: {
					anchor: "100%"
				},
				width: dp(300),
				cls: 'go-sidenav',
				region: "west",
				split: true,
				autoScroll: true,
				items: [
					this.createBusinessPanel(),
					this.createCategoryPanel(),
					this.createFilterPanel()
				]
			});


			this.items = [
				this.sidePanel,
				this.ArticleGrid
			];

			this.sidePanel.show()


			go.modules.business.catalog.SelectArticleWindow.superclass.initComponent.call(this);

			//use viewready so load mask can show
			this.ArticleGrid.on("viewready", this.runModule, this);
		},
		runModule: function () {
			var me = this;

			this.categoryPanel.getRootNode().expand();

			this.documentBusinessGrid.store.load().then(function() {
				me.documentBusinessGrid.getSelectionModel().selectRow(0);
			});
		},

		createCategoryPanel : function() {
			this.categoryPanel = new go.modules.business.catalog.CategoryTree({
				tbar: [
					{
						xtype: "tbtitle",
						text: t("Categories")
					}
				],
			});


			this.categoryPanel.selModel.on("selectionchange",  (sm, nodes) => {
				this.ArticleGrid.store.setFilter("categories", {categories: nodes.map(n => n.attributes.data.id)});
				this.ArticleGrid.store.load();
			});

			return this.categoryPanel;
		},


		createBusinessPanel : function() {
			this.documentBusinessGrid = new go.modules.business.catalog.BusinessGrid ({
				region: "north",
				autoHeight: true,
				title: t("Business")
			});
			this.documentBusinessGrid.getSelectionModel().on('selectionchange', this.onFinanceBusinessSelectionChange, this, {buffer: 1}); //add buffer because it clears selection first

			return this.documentBusinessGrid;
		},

		onFinanceBusinessSelectionChange : function (sm) {

			var selected = sm.getSelected();
			if(!selected) {
				Ext.MessageBox.alert(t("No business", "There are no businesses defined yet in the system settings"));
				this.setDisabled(true);
			}

			go.modules.business.finance.business = selected.data;

			this.businessId = selected.id
			this.ArticleGrid.store.setFilter("business", {businessId: this.businessId});
			this.ArticleGrid.store.load();
		},

		createFilterPanel: function () {
			return new Ext.Panel({
				region: "center",
				minHeight: dp(200),
				autoScroll: true,
				tbar: [{
					xtype: 'tbtitle',
					text: t("Filters")
				},

					],
				items: [
					this.filterGrid = new go.filter.FilterGrid({
						filterStore: this.ArticleGrid.store,
						entity: "Article"
					}),{
						xtype: 'variablefilterpanel',
						filterStore: this.ArticleGrid.store,
						entity: "Article"
					}
				]
			});
		},
		createArticleGrid: function () {
			this.ArticleGrid = new go.modules.business.catalog.ArticleGrid({
				region: 'center',
				enableDragDrop: true, //for dragging contacts to address books or groups in the tree
				ddGroup: "articles",
				enableDelete: false,
				multiSelectToolbarItems: [
					'->',
					{
						xtype: "button",
						cls: "primary",
						text: t("Add"),
						handler: () => {
							this.addSelected();
						}
					}
				],
				tbar: [
					'->',
					{
						xtype: 'tbsearch'
					}
				]

			});

			this.ArticleGrid.on("rowdblclick", () => {
				this.addSelected();
			})

			return this.ArticleGrid;
		},

		addSelected : function() {
			const records = this.ArticleGrid.selModel.getSelections();

			this.handler.call(this, records);
		}
	});
