go.Modules.register("business", "catalog", {
	mainPanel: "go.modules.business.catalog.MainPanel",
	title: t("Catalog"),
	entities: [
		"CatalogCategory",
		{
		name: "Article",
		relations: {
			creator: { store: "UserDisplay", fk: "createdBy" },
			modifier: { store: "UserDisplay", fk: "createdBy" },
			business: { store: "Business", fk: "createdBy" },
			supplier: { store: "Contact", fk: "supplierOrganizationId" }
		},
		filters: [{
			name: 'text',
			type: "string",
			multiple: false,
			title: t("Query")
		},{
			title: t("Modified at"),
			name: 'modifiedat',
			multiple: false,
			type: 'date'
		},{
			title: t("Modified by"),
			name: 'modifiedBy',
			multiple: true,
			type: 'string'
		},{
			title: t("Created at"),
			name: 'createdat',
			multiple: false,
			type: 'date'
		},{
			title: t("Created by"),
			name: 'createdby',
			multiple: true,
			type: 'string'
		}, {
			title: t("Supplier"),
			name: 'supplierOrganizationId',
			multiple: true,
			type: "contactcombo",
			typeConfig: {
				isOrganization: true
			}
		}],
		links: [{
			iconCls: 'entity ic-note',
			linkWindow: function (entity, entityId) {
				return new go.modules.business.catalog.ArticleDialog();
			},
			linkDetail: function () {
				return new go.modules.business.catalog.ArticleDetail();
			}
		}]
	}],
	initModule: function () {

	}
});


go.modules.business.catalog.articleToItem =  function(article) {
	const vatRate =	article.vatRateId ? go.modules.business.finance.stores.vatRateStore.getById(article.vatRateId).data.rate : 0;

	let desc = (article.number ? article.number + " - " : "") +
		article.name;

	if(!go.util.empty(article.description)) {
		desc += "\n" + article.description;
	}

	return {
		articleId: article.id,
		description:  desc,
		vatRateId: article.vatRateId,
		categoryId: article.categoryId,
		unitCost: article.cost,
		unitPrice: article.price,
		unit: article.unit,
		unitPriceIncl: article.price * (100 + vatRate) / 100,
		margin: article.cost ? ( article.price / article.cost ) * 100 - 100 : 0
	};
}

