<?php
/**
* copyright            : (C) 2001-2019 Advanced Internet Designs Inc.
* email                : forum@prohost.org
* $Id$
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; version 2 of the License.
**/

	@set_time_limit(6000);

	require('./GLOBALS.php');
	fud_use('adm.inc', true);
	fud_use('widgets.inc', true);
	fud_use('imsg_edt.inc');
	fud_use('th.inc');
	fud_use('ipoll.inc');
	fud_use('attach.inc');
	fud_use('th_adm.inc');

	require($WWW_ROOT_DISK .'adm/header.php');
	
	if (isset($_GET['usr_id'])) {
		$usr_id = (int) $_GET['usr_id'];
	} else if (isset($_POST['usr_id'])) {
		$usr_id = (int) $_POST['usr_id'];
	} else {
		$usr_id = 0;
	}

	if (isset($_POST['btn_swap']) && !empty($_POST['msg1']) && !empty($_POST['msg2'])) {
		$a = db_sab('SELECT id, thread_id, reply_to FROM '. $DBHOST_TBL_PREFIX .'msg WHERE id='. (int)$_POST['msg1']);
		$b = db_sab('SELECT id, thread_id, reply_to FROM '. $DBHOST_TBL_PREFIX .'msg WHERE id='. (int)$_POST['msg2']);

		if ($a->thread_id != $b->thread_id) {
			echo errorify('Messages does not belong to the same thread.');
		} else {
			// Swap messages.
			q('UPDATE '. $DBHOST_TBL_PREFIX .'msg SET id = 0                                    WHERE id = '. $a->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'msg SET id ='. $a->id .', reply_to = '. $b->id .' WHERE id = '. $b->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'msg SET id ='. $b->id .', reply_to = '. $a->id .' WHERE id = 0');

			// Update title index
			q('UPDATE '. $DBHOST_TBL_PREFIX .'title_index SET msg_id = 0           WHERE msg_id = '. $a->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'title_index SET msg_id ='. $a->id .' WHERE msg_id = '. $b->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'title_index SET msg_id ='. $b->id .' WHERE msg_id = 0');

			// Update search index
			q('UPDATE '. $DBHOST_TBL_PREFIX .'index SET msg_id = 0           WHERE msg_id = '. $a->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'index SET msg_id ='. $a->id .' WHERE msg_id = '. $b->id);
			q('UPDATE '. $DBHOST_TBL_PREFIX .'index SET msg_id ='. $b->id .' WHERE msg_id = 0');
			
			echo successify('Messages '. $a->id .' and '. $b->id .' were successfully swapped around.');
			unset($_POST);
		}
	}

	if (isset($_POST['btn_prune']) && !empty($_POST['thread_age']) && !isset($_POST['btn_cancel'])) {
		$lmt = ' AND '. q_bitand('thread_opt', (2|4)) .' = 0 ';

		/* Figure out our limit if any. */
		if ($_POST['forumsel'] == '0') {
			$msg = '<font color="red">from all forums</font>';
		} else if (!strncmp($_POST['forumsel'], 'cat_', 4)) {
			$l = db_all('SELECT id FROM '. $DBHOST_TBL_PREFIX .'forum WHERE cat_id='. (int)substr($_POST['forumsel'], 4));
			if ($l) {
				$lmt .= ' AND forum_id IN('. implode(',', $l) .') ';
			}
			$msg = '<font color="red">from all forums in category "'. q_singleval('SELECT name FROM '. $DBHOST_TBL_PREFIX .'cat WHERE id='. (int)substr($_POST['forumsel'], 4)) .'"</font>';
		} else {
			$lmt .= ' AND forum_id='. (int)$_POST['forumsel'].' ';
			$msg = '<font color="red">from forum "'. q_singleval('SELECT name FROM '. $DBHOST_TBL_PREFIX .'forum WHERE id='. (int)$_POST['forumsel']) .'"</font>';
		}
		$back = __request_timestamp__ - $_POST['units'] * $_POST['thread_age'];

		if (!isset($_POST['btn_conf']) && $back > 0) {
			/* Count the number of messages & topics that will be affected. */
			if (!$usr_id) {
				$topic_cnt = q_singleval('SELECT count(*) FROM '. $DBHOST_TBL_PREFIX .'thread WHERE last_post_date<'. $back.$lmt);
				$msg_cnt = q_singleval('SELECT SUM(replies) FROM '. $DBHOST_TBL_PREFIX .'thread WHERE last_post_date<'. $back.$lmt) + $topic_cnt;
				$umsg = '';
			} else {
				$topic_cnt = q_singleval('SELECT count(*) FROM '. $DBHOST_TBL_PREFIX .'thread t INNER JOIN '. $DBHOST_TBL_PREFIX .'msg m ON t.root_msg_id=m.id WHERE m.poster_id='. $usr_id .' AND t.last_post_date<'. $back.$lmt);
				$msg_cnt = q_singleval('SELECT count(*) FROM '.$DBHOST_TBL_PREFIX.'msg m INNER JOIN '. $DBHOST_TBL_PREFIX .'thread t ON m.thread_id=t.id WHERE m.poster_id='. $usr_id .' AND t.last_post_date<'. $back.$lmt);
				$umsg = ' <font color="red">posted by "'. q_singleval('SELECT alias FROM '. $DBHOST_TBL_PREFIX .'users WHERE id='. $usr_id) .'"</font>';
			}
?>
<div align="center">You are about to delete <font color="red"><?php echo $topic_cnt; ?></font> topics and <font color="red"><?php echo $msg_cnt; ?></font> messages,
which were posted before <font color="red"><?php echo fdate($back, 'd M Y H:i'); ?></font> <?php echo trim($umsg . ' ' . $msg); ?><br /><br />
			Are you sure you want to do this?<br />
			<form method="post" action="">
			<input type="hidden" name="btn_prune" value="1" />
			<?php echo _hs; ?>
			<input type="hidden" name="thread_age" value="<?php echo $_POST['thread_age']; ?>" />
			<input type="hidden" name="units" value="<?php echo $_POST['units']; ?>" />
			<input type="hidden" name="usr_id" value="<?php echo $usr_id; ?>" />
			<input type="hidden" name="forumsel" value="<?php echo $_POST['forumsel']; ?>" />
			<input type="submit" name="btn_conf" value="Yes" />
			<input type="submit" name="btn_cancel" value="No" />
			</form>
</div>
<?php
			require($WWW_ROOT_DISK .'adm/footer.php');
			exit;
		} else if ($back > 0) {
			$frm_list = array();

			if (!$usr_id) {
				$c = q('SELECT root_msg_id, forum_id FROM '. $DBHOST_TBL_PREFIX .'thread WHERE last_post_date<'. $back.$lmt);
				while ($r = db_rowarr($c)) {
					fud_msg_edit::delete(false, $r[0], 1);
					$frm_list[$r[1]] = $r[1];
				}
			} else {
				$msg_tbl = $DBHOST_TBL_PREFIX .'msg';
				$th_tbl = $DBHOST_TBL_PREFIX .'thread';
				$c = q('SELECT '. $msg_tbl .'.id, '. $th_tbl .'.forum_id FROM '. $msg_tbl .' INNER JOIN '. $th_tbl .' ON '. $msg_tbl .'.thread_id='. $th_tbl .'.id WHERE poster_id='. $usr_id .' AND last_post_date<'. $back.$lmt);
				while ($r = db_rowarr($c)) {
					fud_msg_edit::delete(false, $r[0]);
					$frm_list[$r[1]] = $r[1];
				}
			}
			unset($r);

			foreach ($frm_list as $v) {
				rebuild_forum_view_ttl($v);
			}
			echo successify('Done. It is highly recommended that you run a <a href="consist.php?'. __adm_rsid .'">consistency check</a> after pruning.');
		} else if ($back < 1) {
			echo errorify('You\'ve selected a date too far in the past!');
		}
	}
?>
<h2>Topic Management</h2>

<h3>Topic Pruning</h3>

<p>Remove all topics, where the last message inside the topic was posted prior to the specified date.<br />
For example if you enter a value of 10 and select "days", this form will <u>offer</u> to delete topics with no messages in the last 10 days.</p>

<form id="prune" method="post" action="admtopic.php">
<table class="datatable">
<?php
	if ($usr_id) {
		echo '<tr class="field">';
		echo '<td nowrap="nowrap">By author:</td>';
		echo '<td colspan="2"><b>'. q_singleval('SELECT alias FROM '. $DBHOST_TBL_PREFIX .'users WHERE id='. $usr_id) .'</b></td>';
		echo '</tr>';
	}
?>
<tr class="field">
	<td nowrap="nowrap">Topics with last post made:</td>
	<td><input tabindex="1" type="number" name="thread_age" /></td>
	<td nowrap="nowrap"><?php draw_select('units', "Second(s)\nMinute(s)\nHour(s)\nDay(s)\nWeek(s)\nMonth(s)\nYear(s)", "1\n60\n3600\n86400\n604800\n2635200\n31622400", '86400'); ?>&nbsp;&nbsp;ago</td>
</tr>

<tr class="field">
	<td >Limit to forum:</td>
	<td colspan="2" nowrap="nowrap">
	<?php
		$oldc = '';
		$c = uq('SELECT f.id, f.name, c.name, c.id FROM '. $DBHOST_TBL_PREFIX .'forum f INNER JOIN '. $DBHOST_TBL_PREFIX .'cat c ON f.cat_id=c.id ORDER BY c.parent, c.view_order, f.view_order');
		echo '<select name="forumsel"><option value="0">- All Forums -</option>';
		while ($r = db_rowarr($c)) {
			if ($oldc != $r[3]) {
				echo '<option value="cat_'. $r[3] .'">'. $r[2] .'</option>';
				$oldc = $r[3];
			}
			echo '<option value="'. $r[0] .'">&nbsp;&nbsp;-&nbsp;'. $r[1] .'</option>';
		}
		unset($c);
		/* echo '<option value="P">- Private Messages -</option>'; */
		echo '</select>';
	?>
</td></tr>

<tr class="field">
	<td align="right" colspan="3"><input tabindex="2" type="submit" name="btn_prune" value="Prune" /></td>
</tr>
</table>
<?php echo _hs; ?>
<input type="hidden" name="usr_id" value="<?php echo $usr_id; ?>" />
</form>

<h3>Merge Topics</h3>
<p>Merge two topics into a single topic.</p>
<form id="swap" method="post" action="../'. __fud_index_name__ .'?t=mmd">
<table class="datatable">

<tr class="field">
	<td nowrap="nowrap">Topic 1:</td>
	<td><input tabindex="3" type="number" name="_sel[]" />
</tr>

<tr class="field">
	<td nowrap="nowrap">Topic 2:</td>
	<td><input tabindex="4" type="number" name="_sel[]" />
</tr>

<tr class="field">
	<td align="right" colspan="2"><input tabindex="5" type="submit" name="merge_sel_all" value="Merge" /></td>
</tr>
</table>
<?php echo _hs; ?>
</form>

<h3>Swap Messages</h3>
<p>Swap the order of two messages within a topic.</p>
<form id="swap" method="post" action="admtopic.php">
<table class="datatable">

<tr class="field">
	<td nowrap="nowrap">Message 1:</td>
	<td><input tabindex="6" type="number" name="msg1" value="<?php if (isset($_POST['msg1'])) { echo htmlspecialchars($_POST['msg1']); } ?>" />
</tr>

<tr class="field">
	<td nowrap="nowrap">Message 2:</td>
	<td><input tabindex="7" type="number" name="msg2" value="<?php if (isset($_POST['msg2'])) { echo htmlspecialchars($_POST['msg2']); } ?>" />
</tr>

<tr class="field">
	<td align="right" colspan="2"><input tabindex="8" type="submit" name="btn_swap" value="Swap" /></td>
</tr>
</table>
<?php echo _hs; ?>
</form>

<?php require($WWW_ROOT_DISK .'adm/footer.php'); ?>
