
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `fud320`
--

-- --------------------------------------------------------

--
-- Table structure for table `fud30_action_log`
--

CREATE TABLE `fud30_action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logtime` bigint(20) NOT NULL DEFAULT '0',
  `logaction` text COLLATE utf8_unicode_ci,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `a_res` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_res_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_action_log_i_ul` (`user_id`,`logtime`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_action_log`
--

INSERT INTO `fud30_action_log` VALUES
(1, [[timestamp]], 'Forum', 2, 'Installed', 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_announce`
--

CREATE TABLE `fud30_announce` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_started` bigint(20) NOT NULL DEFAULT '0',
  `date_ended` bigint(20) NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8_unicode_ci NOT NULL,
  `ann_opt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_announce_i_dd` (`date_started`,`date_ended`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_ann_forums`
--

CREATE TABLE `fud30_ann_forums` (
  `ann_id` int(11) NOT NULL DEFAULT '0',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`forum_id`,`ann_id`),
  KEY `fud30_ann_forums_i_a` (`ann_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_attach`
--

CREATE TABLE `fud30_attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `original_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(11) NOT NULL DEFAULT '0',
  `attach_opt` int(11) NOT NULL DEFAULT '0',
  `message_id` int(11) NOT NULL DEFAULT '0',
  `dlcount` int(11) NOT NULL DEFAULT '0',
  `mime_type` int(11) NOT NULL DEFAULT '0',
  `fsize` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_attach_i_mp` (`message_id`,`attach_opt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_avatar`
--

CREATE TABLE `fud30_avatar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `descr` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `gallery` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`),
  KEY `fud30_avatar_i_g` (`gallery`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=40 ;

--
-- Dumping data for table `fud30_avatar`
--

INSERT INTO `fud30_avatar` VALUES
(1, 'smiley01.jpg', 'Smiley01', 'default'),
(2, 'smiley02.jpg', 'Smiley02', 'default'),
(3, 'smiley03.jpg', 'Smiley03', 'default'),
(4, 'smiley04.jpg', 'Smiley04', 'default'),
(5, 'smiley05.jpg', 'Smiley05', 'default'),
(6, 'smiley06.jpg', 'Smiley06', 'default'),
(7, 'smiley07.jpg', 'Smiley07', 'default'),
(8, 'smiley08.jpg', 'Smiley08', 'default'),
(9, 'smiley09.jpg', 'Smiley09', 'default'),
(10, 'smiley10.jpg', 'Smiley10', 'default'),
(11, 'smiley11.jpg', 'Smiley11', 'default'),
(12, 'smiley12.jpg', 'Smiley12', 'default'),
(13, 'smiley13.jpg', 'Smiley13', 'default'),
(14, 'smiley14.jpg', 'Smiley14', 'default'),
(15, 'smiley15.jpg', 'Smiley15', 'default'),
(16, 'smiley16.jpg', 'Smiley16', 'default'),
(17, 'smiley17.jpg', 'Smiley17', 'default'),
(18, 'smiley18.jpg', 'Smiley18', 'default'),
(19, 'smiley19.jpg', 'Smiley19', 'default'),
(20, 'smiley20.jpg', 'Smiley20', 'default'),
(21, 'smiley21.jpg', 'Smiley21', 'default'),
(22, 'smiley22.jpg', 'Smiley22', 'default'),
(23, 'smiley23.jpg', 'Smiley23', 'default'),
(24, 'smiley24.jpg', 'Smiley24', 'default'),
(25, 'smiley25.jpg', 'Smiley25', 'default'),
(26, 'tux01.jpg', 'Tux01', 'Tux'),
(27, 'tux02.jpg', 'Tux02', 'Tux'),
(28, 'tux03.jpg', 'Tux03', 'Tux'),
(29, 'tux04.jpg', 'Tux04', 'Tux'),
(30, 'tux05.jpg', 'Tux05', 'Tux'),
(31, 'tux06.jpg', 'Tux06', 'Tux'),
(32, 'tux07.jpg', 'Tux07', 'Tux'),
(33, 'tux08.jpg', 'Tux08', 'Tux'),
(34, 'tux09.jpg', 'Tux09', 'Tux'),
(35, 'tux10.jpg', 'Tux10', 'Tux'),
(36, 'tux11.jpg', 'Tux11', 'Tux'),
(37, 'tux12.jpg', 'Tux12', 'Tux'),
(38, 'tux13.jpg', 'Tux13', 'Tux'),
(39, 'tux14.jpg', 'Tux14', 'Tux');

-- --------------------------------------------------------

--
-- Table structure for table `fud30_blocked_logins`
--

CREATE TABLE `fud30_blocked_logins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_bookmarks`
--

CREATE TABLE `fud30_bookmarks` (
  `user_id` int(11) NOT NULL,
  `thread_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `fud30_bookmarks`
--

INSERT INTO `fud30_bookmarks` VALUES
(2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_buddy`
--

CREATE TABLE `fud30_buddy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bud_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_buddy_i_ub` (`user_id`,`bud_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_calendar`
--

CREATE TABLE `fud30_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_day` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `event_month` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `event_year` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `descr` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fud30_calendar_i_ymd` (`event_year`,`event_month`,`event_day`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `fud30_calendar`
--

INSERT INTO `fud30_calendar` VALUES
(1, '1', '1', '*', NULL, 'New Year''s Day'),
(2, '14', '2', '*', NULL, 'Valentine''s Day'),
(3, '17', '3', '*', NULL, 'St. Patrick''s'),
(4, '1', '4', '*', NULL, 'All Fool''s Day'),
(5, '22', '4', '*', NULL, 'Earth Day'),
(6, '5', '5', '*', NULL, 'Cinco de Mayo'),
(7, '6', '6', '*', NULL, 'D-Day'),
(8, '24', '10', '*', NULL, 'United Nations Day'),
(9, '31', '10', '*', NULL, 'Halloween'),
(10, '11', '11', '*', NULL, 'Veterans Day'),
(11, '25', '12', '*', NULL, 'Christmas Day'),
(12, '2', '*', '*', NULL, 'Second day of the month, do your time sheets.');

-- --------------------------------------------------------

--
-- Table structure for table `fud30_cat`
--

CREATE TABLE `fud30_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cat_opt` int(11) NOT NULL DEFAULT '0',
  `view_order` int(11) NOT NULL DEFAULT '3',
  `parent` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_cat_p` (`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fud30_cat`
--

INSERT INTO `fud30_cat` VALUES
(1, 'Public Forums', 'A test category for demonstration purposes.', 3, 1, 0),
(2, 'Private Forums', 'Another test category for demonstration purposes.', 3, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_custom_fields`
--

CREATE TABLE `fud30_custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type_opt` int(11) NOT NULL,
  `choice` text COLLATE utf8_unicode_ci,
  `field_opt` int(11) NOT NULL,
  `vieworder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_custom_tags`
--

CREATE TABLE `fud30_custom_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_custom_tags_i_u` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_custom_tags`
--

INSERT INTO `fud30_custom_tags` VALUES
(1, 'Administrator', 2);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_email_block`
--

CREATE TABLE `fud30_email_block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_block_opt` int(11) NOT NULL DEFAULT '1',
  `string` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_email_block_i_s` (`string`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_ext_block`
--

CREATE TABLE `fud30_ext_block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ext` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fc_view`
--

CREATE TABLE `fud30_fc_view` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c` int(11) NOT NULL DEFAULT '0',
  `f` int(11) NOT NULL DEFAULT '0',
  `lvl` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_fc_view_i_f` (`f`),
  KEY `fud30_fc_view_i_c` (`c`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fud30_fc_view`
--

INSERT INTO `fud30_fc_view` VALUES
(1, 1, 1, 0),
(2, 2, 2, 0),
(3, 2, 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fl_1`
--

CREATE TABLE `fud30_fl_1` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fl_2`
--

CREATE TABLE `fud30_fl_2` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fl_3`
--

CREATE TABLE `fud30_fl_3` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fl_pg`
--

CREATE TABLE `fud30_fl_pg` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_fl_pm`
--

CREATE TABLE `fud30_fl_pm` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_forum`
--

CREATE TABLE `fud30_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `descr` text COLLATE utf8_unicode_ci,
  `parent` int(11) NOT NULL DEFAULT '0',
  `url_redirect` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `post_passwd` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forum_icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_created` bigint(20) NOT NULL DEFAULT '0',
  `thread_count` int(11) NOT NULL DEFAULT '0',
  `post_count` int(11) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `view_order` int(11) NOT NULL DEFAULT '0',
  `max_attach_size` int(11) NOT NULL DEFAULT '0',
  `max_file_attachments` int(11) NOT NULL DEFAULT '1',
  `moderators` text COLLATE utf8_unicode_ci,
  `message_threshold` int(11) NOT NULL DEFAULT '0',
  `forum_opt` int(11) NOT NULL DEFAULT '16',
  PRIMARY KEY (`id`),
  KEY `fud30_forum_i_c` (`cat_id`),
  KEY `fud30_forum_i_lpi` (`last_post_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fud30_forum`
--

INSERT INTO `fud30_forum` VALUES
(1, 1, 'First Forum', 'Test forum for demonstration purposes. Please login and navigate to <font color="darkgreen">Administration</font> -> <font color="darkgreen">Category &amp; Forum Management</font> to create your own categories and forums.', 0, NULL, NULL, NULL, [[timestamp]], 1, 1, 1, 1, 1024, 5, NULL, 0, 16),
(2, 2, 'Members', 'This is a private forum for registered users.', 0, NULL, NULL, NULL, [[timestamp]], 0, 0, 0, 2, 1024, 5, NULL, 0, 16),
(3, 2, 'Staff', 'Private forum for staff (Administrators and Moderators).', 0, NULL, NULL, NULL, [[timestamp]], 0, 0, 0, 3, 1024, 5, NULL, 0, 16);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_forum_notify`
--

CREATE TABLE `fud30_forum_notify` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`forum_id`),
  KEY `fud30_forum_notify_i_f` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_forum_read`
--

CREATE TABLE `fud30_forum_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `last_view` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_forum_read_i_fu` (`forum_id`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_forum_read`
--

INSERT INTO `fud30_forum_read` VALUES
(1, 1, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_geoip`
--

CREATE TABLE `fud30_geoip` (
  `ips` bigint(20) NOT NULL,
  `ipe` bigint(20) NOT NULL,
  `cc` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ips`,`ipe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_groups`
--

CREATE TABLE `fud30_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inherit_id` int(11) NOT NULL DEFAULT '0',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `groups_opt` int(11) NOT NULL DEFAULT '0',
  `groups_opti` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_groups_i_f` (`forum_id`),
  KEY `fud30_groups_i_i` (`inherit_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `fud30_groups`
--

INSERT INTO `fud30_groups` VALUES
(1, 'Global Anonymous Access', 0, 0, 262147, 0),
(2, 'Global Registered Access', 0, 0, 313231, 0),
(3, 'First Forum', 0, 1, 327679, 0),
(4, 'Members', 0, 2, 327679, 0),
(5, 'Staff', 0, 3, 327679, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_group_cache`
--

CREATE TABLE `fud30_group_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `resource_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `group_cache_opt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_group_cache_i_ru` (`resource_id`,`user_id`),
  KEY `fud30_group_cache_i_g` (`group_id`),
  KEY `fud30_group_cache_i_u` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `fud30_group_cache`
--

INSERT INTO `fud30_group_cache` VALUES
(1, 0, 1, 3, 262147),
(2, 2147483647, 1, 3, 313231),
(3, 0, 2, 4, 0),
(4, 2147483647, 2, 4, 313231),
(5, 0, 3, 4, 0),
(6, 2, 3, 4, 313231),
(7, 2147483647, 3, 4, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_group_members`
--

CREATE TABLE `fud30_group_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `group_members_opt` int(11) NOT NULL DEFAULT '65536',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_group_members_i_gu` (`group_id`,`user_id`),
  KEY `fud30_group_members_i_gmo` (`group_members_opt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `fud30_group_members`
--

INSERT INTO `fud30_group_members` VALUES
(1, 0, 3, 327683),
(2, 2147483647, 3, 378767),
(3, 0, 4, 65536),
(4, 2147483647, 4, 378767),
(5, 0, 5, 65536),
(6, 2, 5, 378767),
(7, 2147483647, 5, 65536);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_group_resources`
--

CREATE TABLE `fud30_group_resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `resource_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_group_resources_i_gr` (`group_id`,`resource_id`),
  KEY `fud30_group_resources_i_r` (`resource_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fud30_group_resources`
--

INSERT INTO `fud30_group_resources` VALUES
(1, 3, 1),
(2, 4, 2),
(3, 5, 3);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_index`
--

CREATE TABLE `fud30_index` (
  `word_id` int(11) NOT NULL DEFAULT '0',
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `frequency` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`word_id`,`msg_id`),
  KEY `fud30_index_i_m` (`msg_id`),
  KEY `fud30_index_i_mf` (`msg_id`,`frequency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_ip_block`
--

CREATE TABLE `fud30_ip_block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ca` int(11) NOT NULL DEFAULT '0',
  `cb` int(11) NOT NULL DEFAULT '0',
  `cc` int(11) NOT NULL DEFAULT '0',
  `cd` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_jobs`
--

CREATE TABLE `fud30_jobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `start_minute` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `start_hour` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `start_dom` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `start_month` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `start_dow` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '*',
  `cmd` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `nextrun` bigint(20) NOT NULL DEFAULT '0',
  `lastrun` bigint(20) NOT NULL DEFAULT '0',
  `locked` bigint(20) NOT NULL DEFAULT '0',
  `job_opt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_karma_rate_track`
--

CREATE TABLE `fud30_karma_rate_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `stamp` bigint(20) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `poster_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_karma_i_mu` (`msg_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_level`
--

CREATE TABLE `fud30_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `post_count` int(11) NOT NULL DEFAULT '0',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `level_opt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_level_i_p` (`post_count`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fud30_level`
--

INSERT INTO `fud30_level` VALUES
(1, 'Senior Member', 100, NULL, 0),
(2, 'Member', 30, NULL, 0),
(3, 'Junior Member', 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_mime`
--

CREATE TABLE `fud30_mime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fl_ext` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `mime_hdr` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown.gif',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_mime_f` (`fl_ext`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=44 ;

--
-- Dumping data for table `fud30_mime`
--

INSERT INTO `fud30_mime` VALUES
(1, 'aiff', 'audio/x-aiff', 'AIFF File', 'sound.gif'),
(2, 'wav', 'audio/x-wav', 'Wave File', 'sound.gif'),
(3, 'midi', 'audio/midi', 'MIDI File', 'midi.gif'),
(4, 'au', 'audio/basic', 'Sun ulaw-Compressed Audio File', 'sound.gif'),
(5, 'mp3', 'audio/mpeg', 'MP3 File', 'sound.gif'),
(6, 'rm', 'audio/x-realaudio', 'Real Audio', 'real.gif'),
(7, 'gif', 'image/gif', 'GIF Image', 'image.gif'),
(8, 'ico', 'image/ico', 'Icon File', 'image.gif'),
(9, 'jpeg', 'image/jpeg', 'JPEG Image', 'image.gif'),
(10, 'jpg', 'image/jpeg', 'JPEG Image', 'image.gif'),
(11, 'tiff', 'image/tiff', 'TIFF Image', 'image.gif'),
(12, 'tif', 'image/tiff', 'TIFF Image', 'image.gif'),
(13, 'pict', 'image/x-pict', 'Macintosh PICT format', 'image.gif'),
(14, 'bmp', 'image/x-win-bmp', 'BMP Image', 'image.gif'),
(15, 'png', 'image/png', 'PNG Image', 'image.gif'),
(16, 'mpeg', 'video/mpeg', 'MPEG Movie', 'video.gif'),
(17, 'mpg', 'video/mpeg', 'MPEG Movie', 'video.gif'),
(18, 'qt', 'video/quicktime', 'QuickTime Movie', 'video.gif'),
(19, 'mov', 'video/quicktime', 'QuickTime Movie', 'video.gif'),
(20, 'vivo', 'video/vnd.vivo', 'VIVO Movie', 'video.gif'),
(21, 'avi', 'video/x-msvideo', 'Microsoft Video', 'video.gif'),
(22, 'gz', 'application/x-gzip', 'GZIP Archive', 'tgz.gif'),
(23, 'tar', 'application/x-tar', 'TAR Archive', 'tar.gif'),
(24, 'zip', 'application/zip', 'ZIP Archive', 'tgz.gif'),
(25, 'doc', 'application/msword', 'MS Word Document', 'word.gif'),
(26, 'dot', 'application/msword', 'MS Word Document', 'word.gif'),
(27, 'xls', 'application/vnd.ms-excel', 'MS Excel', 'excel.gif'),
(28, 'ppt', 'application/vnd.ms-powerpoint', 'MS PowerPoint', 'ppt.gif'),
(29, 'pdf', 'application/pdf', 'PDF Document', 'pdf.gif'),
(30, 'rtf', 'application/rtf', 'Rich Text Format', 'txt.gif'),
(31, 'htm', 'text/html', 'HTML Page', 'html.gif'),
(32, 'html', 'text/html', 'HTML Page', 'html.gif'),
(33, 'txt', 'text/plain', 'Plain Text', 'txt.gif'),
(34, 'ps', 'application/postscript', 'Postscript', 'postscript.gif'),
(35, 'swf', 'application/x-shockwave-flash', 'ShockWave Flash', 'flash.gif'),
(36, 'exe', 'application/application', 'Binary File', 'binary.gif'),
(37, 'bin', 'application/application', 'Binary File', 'binary.gif'),
(38, 'sh', 'application/sh', 'UNIX Shell Script', 'sh.gif'),
(39, 'hqx', 'application/mac-binhex40', 'Mac Binary', 'binary.gif'),
(40, '*', 'application/octet-stream', 'Unknown', 'unknown.gif'),
(41, 'pl', 'application/x-perl', 'Perl Script', 'source.gif'),
(42, 'pm', 'application/x-perl', 'Perl Module', 'source.gif'),
(43, 'php', 'application/x-httpd-php', 'PHP Script', 'source.gif');

-- --------------------------------------------------------

--
-- Table structure for table `fud30_mlist`
--

CREATE TABLE `fud30_mlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `subject_regex_haystack` text COLLATE utf8_unicode_ci,
  `subject_regex_needle` text COLLATE utf8_unicode_ci,
  `body_regex_haystack` text COLLATE utf8_unicode_ci,
  `body_regex_needle` text COLLATE utf8_unicode_ci,
  `additional_headers` text COLLATE utf8_unicode_ci,
  `mlist_opt` int(11) NOT NULL DEFAULT '76',
  `custom_sig` text COLLATE utf8_unicode_ci,
  `mbox_server` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mbox_user` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mbox_pass` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mbox_type` int(11) NOT NULL DEFAULT '0',
  `fixed_from_address` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fud30_mlist_i_f` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_mod`
--

CREATE TABLE `fud30_mod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_mod_i_uf` (`user_id`,`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_msg`
--

CREATE TABLE `fud30_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `thread_id` int(11) NOT NULL DEFAULT '0',
  `poster_id` int(11) NOT NULL DEFAULT '0',
  `reply_to` int(11) NOT NULL DEFAULT '0',
  `ip_addr` varchar(46) COLLATE utf8_unicode_ci NOT NULL DEFAULT '::1',
  `host_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `post_stamp` bigint(20) NOT NULL DEFAULT '0',
  `update_stamp` bigint(20) NOT NULL DEFAULT '0',
  `updated_by` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `attach_cnt` int(11) NOT NULL DEFAULT '0',
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `foff` bigint(20) NOT NULL DEFAULT '0',
  `length` int(11) NOT NULL DEFAULT '0',
  `file_id` int(11) NOT NULL DEFAULT '1',
  `offset_preview` bigint(20) NOT NULL DEFAULT '0',
  `length_preview` int(11) NOT NULL DEFAULT '0',
  `file_id_preview` int(11) NOT NULL DEFAULT '0',
  `attach_cache` text COLLATE utf8_unicode_ci,
  `poll_cache` text COLLATE utf8_unicode_ci,
  `mlist_msg_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `msg_opt` int(11) NOT NULL DEFAULT '1',
  `apr` int(11) NOT NULL DEFAULT '0',
  `flag_cc` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flag_country` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fud30_msg_i_ta` (`thread_id`,`apr`),
  KEY `fud30_msg_i_ps` (`post_stamp`),
  KEY `fud30_msg_i_pa` (`poster_id`,`apr`),
  KEY `fud30_msg_i_a` (`apr`),
  KEY `fud30_msg_i_ac` (`attach_cnt`),
  KEY `fud30_msg_i_pi` (`poll_id`),
  KEY `fud30_msg_i_ip` (`ip_addr`,`post_stamp`),
  KEY `fud30_msg_i_mmi` (`mlist_msg_id`),
  KEY `fud30_msg_i_s` (`subject`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_msg`
--

INSERT INTO `fud30_msg` VALUES
(1, 1, 2, 0, '::1', NULL, [[timestamp]], 0, 0, NULL, 'Welcome to FUDforum', 0, 0, -1, 459, 1, -1, 0, 0, NULL, NULL, NULL, 1, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_msg_report`
--

CREATE TABLE `fud30_msg_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `reason` text COLLATE utf8_unicode_ci,
  `stamp` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_msg_report_i_mu` (`msg_id`,`user_id`),
  KEY `fud30_msg_report_i_u` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_msg_store`
--

CREATE TABLE `fud30_msg_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_msg_store`
--

INSERT INTO `fud30_msg_store` VALUES
(1, '<b>Congratulations!</b> You have successfully installed FUDforum and are well on your way to creating a vibrant community that you and your members can enjoy for years to come. :-)<br />\n<br />\nTo get you started, please read the documentation on our <a href="https://github.com/fudforum/FUDforum/wiki">wiki</a> and report any problems on the <a href="https://github.com/fudforum/FUDforum/discussions">support forum</a>.<br />\n<br />\nLogin and head over to the Admin Control Panel to start configuring your forum.<br />\n<br />\nThanks for using our software.<br />\n<br />\nEnjoy!<br />\nThe FUDforum team<br />\n');

-- --------------------------------------------------------

--
-- Table structure for table `fud30_nntp`
--

CREATE TABLE `fud30_nntp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `nntp_opt` int(11) NOT NULL DEFAULT '44',
  `server` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `newsgroup` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `port` int(11) NOT NULL DEFAULT '0',
  `timeout` int(11) NOT NULL DEFAULT '0',
  `login` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imp_limit` int(11) NOT NULL DEFAULT '0',
  `custom_sig` text COLLATE utf8_unicode_ci,
  `tracker` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_nntp_i_f` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_pages`
--

CREATE TABLE `fud30_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `foff` bigint(20) NOT NULL DEFAULT '0',
  `length` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `page_opt` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_pages_s` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_plugins`
--

CREATE TABLE `fud30_plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_plugins_n` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_pmsg`
--

CREATE TABLE `fud30_pmsg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `to_list` text COLLATE utf8_unicode_ci,
  `ouser_id` int(11) NOT NULL DEFAULT '0',
  `duser_id` int(11) NOT NULL DEFAULT '0',
  `pdest` int(11) NOT NULL DEFAULT '0',
  `ip_addr` varchar(46) COLLATE utf8_unicode_ci NOT NULL DEFAULT '::1',
  `host_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `post_stamp` bigint(20) NOT NULL DEFAULT '0',
  `read_stamp` bigint(20) NOT NULL DEFAULT '0',
  `icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `attach_cnt` int(11) NOT NULL DEFAULT '0',
  `foff` bigint(20) NOT NULL DEFAULT '0',
  `length` int(11) NOT NULL DEFAULT '0',
  `ref_msg_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fldr` int(11) NOT NULL DEFAULT '0',
  `pmsg_opt` int(11) NOT NULL DEFAULT '49',
  PRIMARY KEY (`id`),
  KEY `fud30_pmsg_i_dfr` (`duser_id`,`fldr`,`read_stamp`),
  KEY `fud30_pmsg_i_dfi` (`duser_id`,`fldr`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_poll`
--

CREATE TABLE `fud30_poll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `owner` int(11) NOT NULL DEFAULT '0',
  `creation_date` bigint(20) NOT NULL DEFAULT '0',
  `expiry_date` bigint(20) NOT NULL DEFAULT '0',
  `max_votes` int(11) DEFAULT NULL,
  `total_votes` int(11) NOT NULL DEFAULT '0',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_poll_i_o` (`owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_poll_opt`
--

CREATE TABLE `fud30_poll_opt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `votes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fud30_poll_opt_i_p` (`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_poll_opt_track`
--

CREATE TABLE `fud30_poll_opt_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ip_addr` varchar(46) COLLATE utf8_unicode_ci DEFAULT NULL,
  `poll_opt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_poll_opt_track_i_pu` (`poll_id`,`user_id`,`ip_addr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_read`
--

CREATE TABLE `fud30_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `thread_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `last_view` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_read_i_tu` (`thread_id`,`user_id`),
  KEY `fud30_read_i_u` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_replace`
--

CREATE TABLE `fud30_replace` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `replace_str` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `with_str` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `from_post` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to_msg` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `replace_opt` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_replace`
--

INSERT INTO `fud30_replace` VALUES
(1, '/fuck you/i', 'I love you', '//', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_search`
--

CREATE TABLE `fud30_search` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_search_i_w` (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_search_cache`
--

CREATE TABLE `fud30_search_cache` (
  `srch_query` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `query_type` int(11) NOT NULL DEFAULT '0',
  `expiry` int(11) NOT NULL DEFAULT '0',
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `n_match` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`srch_query`,`query_type`,`msg_id`),
  KEY `fud30_search_cache_i_e` (`expiry`),
  KEY `fud30_search_cache_i_qtn` (`srch_query`,`query_type`,`n_match`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_ses`
--

CREATE TABLE `fud30_ses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ses_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `sys_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `action` text COLLATE utf8_unicode_ci,
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `time_sec` bigint(20) NOT NULL DEFAULT '0',
  `ip_addr` varchar(46) COLLATE utf8_unicode_ci DEFAULT NULL,
  `useragent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `returnto` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_ses_i_s` (`ses_id`),
  UNIQUE KEY `fud30_ses_i_u` (`user_id`),
  KEY `fud30_ses_i_i` (`ip_addr`),
  KEY `fud30_ses_i_tu` (`time_sec`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `fud30_ses`
--

-- --------------------------------------------------------

--
-- Table structure for table `fud30_settings`
--

CREATE TABLE `fud30_settings` (
  `conf_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `conf_value` varchar(2048) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`conf_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_smiley`
--

CREATE TABLE `fud30_smiley` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `descr` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `vieworder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=32 ;

--
-- Dumping data for table `fud30_smiley`
--

INSERT INTO `fud30_smiley` VALUES
(1, 'icon_redface.gif', 'Embarrassed', ':blush:', 1),
(2, 'icon_razz.gif', 'Razz', ':P~:-P~:razz:', 2),
(3, 'icon_mad.gif', 'Mad', ':x~:-x~:mad:', 3),
(4, 'icon_lol.gif', 'Laughing', ':lol:', 4),
(5, 'icon_cool.gif', 'Cool', '8)~8-)~:cool:', 5),
(6, 'icon_confused.gif', 'Confused', ':?~:-?~:???:', 6),
(7, 'icon_eek.gif', 'Shocked', '8O~8-O~:shock:', 7),
(8, 'icon_surprised.gif', 'Surprised', ':o~:-o~:eek:', 8),
(9, 'icon_sad.gif', 'Sad', ':(~:-(~:sad:', 9),
(10, 'icon_smile.gif', 'Smile', ':)~:-)~:smile:', 10),
(11, 'icon_biggrin.gif', 'Very Happy', ':D~:-D~:grin:', 11),
(12, 'icon_cry.gif', 'Crying or Very Sad', ':cry:~:((~:-((', 12),
(13, 'icon_evil.gif', 'Evil or Very Mad', ':evil:', 13),
(14, 'icon_twisted.gif', 'Twisted Evil', ':twisted:', 14),
(15, 'icon_rolleyes.gif', 'Rolling Eyes', ':roll:', 15),
(16, 'icon_wink.gif', 'Wink', ';)~;-)~:wink:', 16),
(17, 'icon_exclaim.gif', 'Exclamation', ':!:', 17),
(18, 'icon_question.gif', 'Question', ':?:', 18),
(19, 'icon_idea.gif', 'Idea', ':idea:', 19),
(20, 'icon_arrow.gif', 'Arrow', ':arrow:', 20),
(21, 'icon_neutral.gif', 'Neutral', ':|~:-|~:neutral:', 21),
(22, 'icon_mrgreen.gif', 'Grin', ':]~:-]~:brgin:', 22),
(23, 'icon_dead.gif', 'Dead', 'x(~:dead:', 23),
(24, 'icon_frown.gif', 'Frown', ':frown:', 24),
(25, 'icon_nod.gif', 'Nod', ':nod:', 25),
(26, 'icon_proud.gif', 'Proud', ':proud:', 26),
(27, 'icon_smug.gif', 'Smug', ':smug:', 27),
(28, 'icon_thumbsup.gif', 'Thumbs Up', ':thumbup:', 28),
(29, 'icon_thumbdown.gif', 'Thumbs Down', ':thumbdown:', 29),
(30, 'icon_uhoh.gif', 'Uh Oh', ':uhoh:', 30),
(31, 'icon_yawn.gif', 'Bored', ':yawn:', 31);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_spiders`
--

CREATE TABLE `fud30_spiders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `botname` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `useragent` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `bot_ip` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `theme` int(11) NOT NULL,
  `bot_opts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fud30_spiders`
--

INSERT INTO `fud30_spiders` VALUES
(1, 'Google', 'Googlebot', NULL, 3, 1, 1),
(2, 'Yahoo!', 'Slurp', NULL, 4, 1, 1),
(3, 'Bing', 'msnbot', NULL, 5, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_stats_cache`
--

CREATE TABLE `fud30_stats_cache` (
  `user_count` int(11) NOT NULL DEFAULT '0',
  `last_user_id` int(11) NOT NULL DEFAULT '0',
  `online_users_reg` int(11) NOT NULL DEFAULT '0',
  `online_users_anon` int(11) NOT NULL DEFAULT '0',
  `online_users_hidden` int(11) NOT NULL DEFAULT '0',
  `online_users_text` text COLLATE utf8_unicode_ci,
  `most_online` int(11) NOT NULL DEFAULT '0',
  `most_online_time` bigint(20) NOT NULL DEFAULT '0',
  `cache_age` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `fud30_stats_cache`
--

INSERT INTO `fud30_stats_cache` VALUES
(0, 0, 0, 0, 0, '', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_themes`
--

CREATE TABLE `fud30_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pspell_lang` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme_opt` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fud30_themes_i_t` (`theme_opt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_themes`
--

INSERT INTO `fud30_themes` VALUES
(1, 'default', 'default', 'en', 'en_US.UTF-8', 'en', 3);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_thread`
--

CREATE TABLE `fud30_thread` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `root_msg_id` int(11) NOT NULL DEFAULT '0',
  `last_post_date` bigint(20) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `n_rating` int(11) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `moved_to` int(11) NOT NULL DEFAULT '0',
  `orderexpiry` bigint(20) NOT NULL DEFAULT '0',
  `thread_opt` int(11) NOT NULL DEFAULT '0',
  `tdescr` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fud30_thread_i_flm` (`forum_id`,`moved_to`),
  KEY `fud30_thread_i_t` (`thread_opt`),
  KEY `fud30_thread_i_rmi` (`root_msg_id`),
  KEY `fud30_thread_i_r` (`replies`),
  KEY `fud30_thread_i_rt` (`rating`,`n_rating`),
  KEY `fud30_thread_i_frm` (`forum_id`,`root_msg_id`,`moved_to`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_thread`
--

INSERT INTO `fud30_thread` VALUES
(1, 1, 1, [[timestamp]], 0, 1, 5, 1, 1, 0, 1000000000, 4, 'Welcome, welcome, welcome!');

-- --------------------------------------------------------

--
-- Table structure for table `fud30_thread_notify`
--

CREATE TABLE `fud30_thread_notify` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `thread_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`thread_id`),
  KEY `fud30_thread_notify_i_t` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `fud30_thread_notify`
--

INSERT INTO `fud30_thread_notify` VALUES
(2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_thread_rate_track`
--

CREATE TABLE `fud30_thread_rate_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `thread_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `stamp` bigint(20) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_thread_rate_track_i_tu` (`thread_id`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fud30_thread_rate_track`
--

INSERT INTO `fud30_thread_rate_track` VALUES
(1, 1, 2, [[timestamp]], 5);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_thr_exchange`
--

CREATE TABLE `fud30_thr_exchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `th` int(11) NOT NULL DEFAULT '0',
  `frm` int(11) NOT NULL DEFAULT '0',
  `req_by` int(11) NOT NULL DEFAULT '0',
  `reason_msg` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `fud30_thr_exchange_i_f` (`frm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_title_index`
--

CREATE TABLE `fud30_title_index` (
  `word_id` int(11) NOT NULL DEFAULT '0',
  `msg_id` int(11) NOT NULL DEFAULT '0',
  `frequency` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`word_id`,`msg_id`),
  KEY `fud30_title_index_i_m` (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_tv_1`
--

CREATE TABLE `fud30_tv_1` (
  `thread_id` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  `iss` int(11) NOT NULL,
  PRIMARY KEY (`thread_id`),
  KEY `fud30_tv_1_seq` (`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `fud30_tv_1`
--

INSERT INTO `fud30_tv_1` VALUES
(1, 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_tv_2`
--

CREATE TABLE `fud30_tv_2` (
  `thread_id` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  `iss` int(11) NOT NULL,
  PRIMARY KEY (`thread_id`),
  KEY `fud30_tv_2_seq` (`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_tv_3`
--

CREATE TABLE `fud30_tv_3` (
  `thread_id` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  `iss` int(11) NOT NULL,
  PRIMARY KEY (`thread_id`),
  KEY `fud30_tv_3_seq` (`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_users`
--

CREATE TABLE `fud30_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `passwd` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salt` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `interests` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `occupation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar` int(11) NOT NULL DEFAULT '0',
  `avatar_loc` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icq` bigint(20) DEFAULT NULL,
  `facebook` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yahoo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jabber` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `google` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `skype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `posts_ppg` int(11) NOT NULL DEFAULT '0',
  `time_zone` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'UTC',
  `birthday` char(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `join_date` bigint(20) NOT NULL DEFAULT '0',
  `conf_key` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_key` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `theme` int(11) NOT NULL DEFAULT '0',
  `posted_msg_count` int(11) NOT NULL DEFAULT '0',
  `last_visit` bigint(20) NOT NULL DEFAULT '0',
  `referer_id` int(11) NOT NULL DEFAULT '0',
  `last_read` bigint(20) NOT NULL DEFAULT '0',
  `custom_status` text COLLATE utf8_unicode_ci,
  `sig` text COLLATE utf8_unicode_ci,
  `level_id` int(11) NOT NULL DEFAULT '0',
  `karma` int(11) NOT NULL DEFAULT '0',
  `u_last_post_id` int(11) NOT NULL DEFAULT '0',
  `home_page` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bio` text COLLATE utf8_unicode_ci,
  `cat_collapse_status` text COLLATE utf8_unicode_ci,
  `custom_color` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `buddy_list` text COLLATE utf8_unicode_ci,
  `ignore_list` text COLLATE utf8_unicode_ci,
  `group_leader_list` text COLLATE utf8_unicode_ci,
  `users_opt` int(11) NOT NULL DEFAULT '4488117',
  `sq` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `registration_ip` varchar(46) COLLATE utf8_unicode_ci NOT NULL DEFAULT '::1',
  `last_used_ip` varchar(46) COLLATE utf8_unicode_ci NOT NULL DEFAULT '::1',
  `ban_expiry` bigint(20) NOT NULL DEFAULT '0',
  `ban_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `topics_per_page` int(11) NOT NULL DEFAULT '40',
  `last_login` bigint(20) NOT NULL DEFAULT '0',
  `flag_cc` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flag_country` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_fields` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_users_i_l` (`login`),
  UNIQUE KEY `fud30_users_i_e` (`email`),
  UNIQUE KEY `fud30_users_i_a` (`alias`),
  KEY `fud30_users_i_rk` (`reset_key`),
  KEY `fud30_users_i_lv` (`last_visit`),
  KEY `fud30_users_i_ck` (`conf_key`),
  KEY `fud30_users_i_ri` (`referer_id`),
  KEY `fud30_users_i_uo` (`users_opt`),
  KEY `fud30_users_i_jd` (`join_date`),
  KEY `fud30_users_i_bd` (`birthday`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `fud30_users`
--

INSERT INTO `fud30_users` VALUES
(1, 'Anonymous', 'Anonymous', '1', NULL, 'Anonymous', 'dev@null', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'America/New_York', NULL, [[timestamp]], NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4488117, NULL, '::1', '::1', 0, NULL, 40, 0, NULL, NULL, NULL),
(2, '[[admin_username]]', '[[admin_username]]', '[[admin_pass]]', '[[salt]]', 'Administrator', '[[admin_email]]', NULL, NULL, NULL, 3, '<img src="[[relativeurl]]/images/avatars/smiley03.jpg" alt="" width="64" height="64" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'America/New_York', NULL, [[timestamp]], NULL, NULL, NULL, 1, 1, 0, 0, 0, 'Administrator', NULL, 3, 0, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 13777910, NULL, '::1', '::1', 0, NULL, 40, 0, NULL, NULL, NULL),
(3, 'Google', 'Google', '[[admin_pass]]', '[[salt]]', 'Googlebot', 'Google@fud_spiders', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'America/New_York', NULL, [[timestamp]], NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1715893141, NULL, '::1', '::1', 0, NULL, 40, 0, NULL, NULL, NULL),
(4, 'Yahoo', 'Yahoo', '[[admin_pass]]', '[[salt]]', 'Yahoo!', 'Yahoo@fud_spiders', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'America/New_York', NULL, [[timestamp]], NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1715893141, NULL, '::1', '::1', 0, NULL, 40, 0, NULL, NULL, NULL),
(5, 'Bing', 'Bing', '[[admin_pass]]', '[[salt]]', 'Bing', 'Bing@fud_spiders', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 'America/New_York', NULL, [[timestamp]], NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1715893141, NULL, '::1', '::1', 0, NULL, 40, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fud30_user_ignore`
--

CREATE TABLE `fud30_user_ignore` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ignore_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fud30_user_ignore_i_ui` (`user_id`,`ignore_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fud30_xmlagg`
--

CREATE TABLE `fud30_xmlagg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `forum_id` int(11) NOT NULL DEFAULT '0',
  `xmlagg_opt` int(11) NOT NULL DEFAULT '2',
  `last_load_date` bigint(20) NOT NULL DEFAULT '0',
  `custom_sig` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `fud30_xmlagg_i_f` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
