<?php 
	// Optimisation : utiliser la fonction identicon_profile() au lieu de dupliquer le code
	// Cela évite les lectures répétées de flatDB et assure la cohérence
	$identity = '';
	if (!empty($sessionTrip)) {
		$username = HTMLForm::trip($sessionTrip, '');
		// Utiliser la fonction du plugin si disponible
		if (function_exists('identicon_profile')) {
			$identity = identicon_profile($username);
		} else {
			// Fallback si le plugin n'est pas chargé
			$size = 65;
			$user = strstr($sessionTrip, '@', true) ?: $sessionTrip;
			$identity = '<svg class="rounded-circle" width="' . $size . '" height="' . $size . '" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid slice" focusable="false" role="img" aria-label="avatar"><rect width="100%" height="100%" fill="#868e96" fill-opacity="0.2"></rect></svg>';
		}
	}
	
	// Si pas d'identité générée, utiliser le SVG par défaut
	if (empty($identity)) {
		$size = 65;
		$identity = '<svg class="rounded-circle" width="' . $size . '" height="' . $size . '" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid slice" focusable="false" role="img" aria-label="avatar"><rect width="100%" height="100%" fill="#868e96" fill-opacity="0.2"></rect></svg>';
	}
	
	// Récupération du pseudo sans le hash pour l'affichage
	$user = !empty($sessionTrip) ? (strstr($sessionTrip, '@', true) ?: $sessionTrip) : '';
	
	$welcomeBack = !empty($sessionTrip) ? 
		'Welcome back ' . htmlspecialchars($user) . ', ' . $lang['reply_this_topic'] . ' <a class="btn btn-link" href="auth.php/logout" role="button">[' . $lang['logout'] . ']</a>'
		 : 
		'<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#loginModal">' . $lang['reply_this_topic'] . '</button>';
	   	
	# Reply Form collapse	
    $out['content'] .= '	   
	<div id="replyform" class="accordion">
	  <div class="card">
	  
	    <div class="card-header" id="headingOne">
	    	<i class="mt-4 float-right fa fa-caret-down" aria-hidden="true"></i>
	        <a class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseReply" aria-expanded="true" aria-controls="collapseReply">
	        	' .$identity. '
				<span class="h6 ml-3">&nbsp;' . $welcomeBack. '</span>
	        </a>
	    </div>';
	    
	$sessionTrip!='' ? $out['content'] .= '
	    <div id="collapseReply" class="collapse" aria-labelledby="headingReply" data-parent="#replyform">
	      <div class="card-body">' .
	    	HTMLForm::form('add.php' . DS . 'reply' . DS . $_GET['topic'],'
			<div class="form-row">
			    <div class="form-group col-md-6">
			        ' .HTMLForm::password('trip', $sessionTrip). '
			    </div>
			    <div class="form-group col-md-6">
			        ' .HTMLForm::text('mail', $sessionMail, 'mail', 'form-control form-control-sm', 'not_required', 'mail_desc'). '			        
			    </div>
			</div>'. 
			HTMLForm::textarea('content', Util::isGETValidEntry('reply', 'q')? '[quote]' .$_GET['q']. '[/quote]' : '', 'form-control form-control-sm', '', 5, 'write_post').
			HTMLForm::tripCaptcha() ).
			HTMLForm::preview('content'). '
	      </div>
	    </div>':null;
	$out['content'] .= '    
	  </div>
	</div>';
?>