<?php
# ON RETOURNE LA DERNIÈRE DISCUSSION		
$out['content'] .= '
  <div class="lh-100 d-flex align-items-center p-3 my-3 rounded box-shadow">
    <div style="width:100%; word-break: break-all;">	          	          
      <div class="text-center">
          <h1 class="h4">' . Parser::title($tag . ($topicEntry['title'] ?? '')) . '</h1>	
          ' . Parser::summary(Parser::content($topicEntry['content'] ?? '', true), 30) . '
          <p class="mt-3">' . (
              !empty($topicEntry['locked']) ?
              '<a title="' . Util::lang('topic locked') . '" class="btn btn-primary btn-lg" href="view.php' . DS . 'topic' . DS . $topic . '">' . $lang['more'] . ' <i class="fa fa-lock"></i></a>' :
              '<a title="' . $lang['more'] . '" class="btn btn-primary btn-lg" href="view.php' . DS . 'topic' . DS . $topic . '">' . $lang['more'] . ' <i class="fa fa-arrow-circle-right"></i></a>'
          ) . '</p>
      </div>';

# ON LISTE LES 3 DERNIÈRES RÉPONSES S’IL Y EN A
if (!empty($topicEntry['reply']) && is_array($topicEntry['reply'])) {
    $out['content'] .= '<hr class="my-4">
    <div class="text-center text-uppercase">' . Util::pluralize(count($topicEntry['reply']), $lang['replies'], $lang['reply']) . '</div>	
    <div class="row">';

    // Optimisation : préchargement des 3 dernières réponses
    $lastReplies = array_slice($topicEntry['reply'], -3);
    $repliesData = [];
    foreach ($lastReplies as $reply) {
        $repliesData[$reply] = flatDB::readEntry('reply', $reply);
    }
    
    foreach ($lastReplies as $reply) {
        $replyEntry = $repliesData[$reply] ?? null;
        if (!$replyEntry) {
            continue;
        }
        $out['content'] .= '
        <div class="col-md-4">
            <a title="' . $lang['more'] . '" class="float-right" href="view.php' . DS . 'topic' . DS . ($replyEntry['topic'] ?? '') . DS . 'p' . DS . Util::onPage($reply, $topicEntry['reply']) . '#' . $reply . '"><i class="fa fa-external-link-square" aria-hidden="true"></i></a>
            <span class="user ' . ($replyEntry['role'] ?? 'user') . '">' . Parser::title($replyEntry['trip'] ?? '') . '</span>: 
            <div style="width:100%; word-break: break-all;">
                ' . Parser::summary(Parser::content($replyEntry['content'] ?? '', true), 20) . '
            </div>
        </div>';
    }

    $out['content'] .= '</div>';
}

$out['content'] .= '
    </div>				
  </div><!-- ./lh-100 d-flex align-items-center -->';

# TABLEAU DE SUGGESTION DES DERNIERS SUJETS & RÉPONSES		          	
$out['content'] .= '
<section id="timeline">
  <div class="my-3 p-3 rounded box-shadow">
    <h6 class="border-bottom border-gray pb-2 mb-0">'
     . Util::pluralize(!empty($topicEntry['reply']) ? count($topicEntry['reply']) : 0, $lang['last_post'] . $lang['plural'], $lang['last_post']) .
    '</h6>';

# Sort
rsort($mixes);
$pageMixes = Paginate::viewPage($mixes, $p, $nb);

// Optimisation : préchargement des topics, replies et forums pour éviter les requêtes N+1
$topicsCache = [];
$repliesCache = [];
$forumsCache = [];

// Première passe : identifier tous les éléments nécessaires
foreach ($pageMixes as $mix) {
    if (flatDB::isValidEntry('topic', $mix)) {
        $topicEntry = flatDB::readEntry('topic', $mix);
        if ($topicEntry) {
            $topicsCache[$mix] = $topicEntry;
            $forumId = $topicEntry['forum'] ?? '';
            if ($forumId && !isset($forumsCache[$forumId])) {
                $forumsCache[$forumId] = flatDB::readEntry('forum', $forumId);
            }
        }
    } else {
        $replyEntry = flatDB::readEntry('reply', $mix);
        if ($replyEntry) {
            $repliesCache[$mix] = $replyEntry;
            $topicId = $replyEntry['topic'] ?? '';
            if ($topicId && !isset($topicsCache[$topicId])) {
                $topicEntry = flatDB::readEntry('topic', $topicId);
                if ($topicEntry) {
                    $topicsCache[$topicId] = $topicEntry;
                    $forumId = $topicEntry['forum'] ?? '';
                    if ($forumId && !isset($forumsCache[$forumId])) {
                        $forumsCache[$forumId] = flatDB::readEntry('forum', $forumId);
                    }
                }
            }
        }
    }
}

// Deuxième passe : affichage avec les données en cache
foreach ($pageMixes as $mix) {
    if (flatDB::isValidEntry('topic', $mix)) {
        $topic = $mix;
        $topicEntry = $topicsCache[$topic] ?? null;
        if (!$topicEntry) {
            continue;
        }
        $forumEntry = $forumsCache[$topicEntry['forum'] ?? ''] ?? [];

        $tagMix = isset($topicEntry['tag']) ? $topicEntry['tag'] . ' ' : '';
        $privateforums = isset($forumEntry['private_forum']) ? $forumEntry['private_forum'] || User::isWorker() : '';

        $out['content'] .= '
        <div class="media text-muted pt-3">
          <figure class="mw-10">' . Plugin::hook('profile', $topicEntry['trip'] ?? '') . '</figure>
          <div class="media-body ml-3 pb-3 mb-0 small lh-125 border-bottom border-gray">
            <div class="d-flex w-100">
              <strong class="text-gray-dark">
                <a href="view.php' . DS . 'topic' . DS . $topic . '">' . Parser::title($tagMix . ($topicEntry['title'] ?? '')) . '</a>
              </strong>
            </div>

            <div class="float-right">
              ' . Util::shortNum($topicEntry['view'] ?? 0) . '&nbsp;<i class="fa fa-eye" title="' . $lang['view'] . Util::pluralize($topicEntry['view'] ?? 0, $lang['plural']) . '"></i><br />
              ' . Util::shortNum(!empty($topicEntry['reply']) ? count($topicEntry['reply']) : 0) . '&nbsp;<i class="fa fa-comment-o" title="' . Util::pluralize(!empty($topicEntry['reply']) ? count($topicEntry['reply']) : 0, $lang['replies'], $lang['reply']) . '"></i>
            </div>

            <div class="d-block">
              ' . entryLink::manageTopic($topic) . ' <span class="user ' . ($topicEntry['role'] ?? 'user') . '">' . Parser::title($topicEntry['trip'] ?? '') . '</span> ' . $lang['started'] . ' ' . Util::toDate($topic, $config['date_format']) . '
            </div>

            <p class="tile-title">
              <a class="btn btn-sm" style="background-color:' . ($forumEntry['badge_color'] ?? '#6c757d') . '!important;color:white!important" href="view.php' . DS . 'forum' . DS . ($topicEntry['forum'] ?? '') . '"><i class="' . ($forumEntry['font_icon'] ?? 'fa fa-comments') . '"></i> ' . ($forumEntry['name'] ?? 'Forum') . '</a>
            </p>
          </div>
        </div>';
    } else {
        $reply = $mix;
        $replyEntry = $repliesCache[$reply] ?? null;
        if (!$replyEntry) {
            continue;
        }
        $topicEntry = $topicsCache[$replyEntry['topic'] ?? ''] ?? null;
        if (!$topicEntry) {
            continue;
        }
        $forumEntry = $forumsCache[$topicEntry['forum'] ?? ''] ?? [];

        $tagReply = isset($topicEntry['tag']) ? $topicEntry['tag'] . ' ' : '';
        $privateforums = isset($forumEntry['private_forum']) ? $forumEntry['private_forum'] || User::isWorker() : '';

        $out['content'] .= '
        <div class="media text-muted pt-3">
          <figure class="mw-10">' . Plugin::hook('profile', $replyEntry['trip'] ?? '') . '</figure>
          <div class="media-body ml-3 pb-3 mb-0 small lh-125 border-bottom border-gray">
            <div class="d-flex w-100">
              <strong class="text-gray-dark">
                <a href="view.php' . DS . 'topic' . DS . ($replyEntry['topic'] ?? '') . DS . 'p' . DS . Util::onPage($reply, $topicEntry['reply'] ?? []) . '#' . $reply . '">' . Parser::title($tagReply . ($topicEntry['title'] ?? '')) . '</a>
              </strong>
            </div>

            <div class="float-right">
              ' . Util::shortNum($topicEntry['view'] ?? 0) . '&nbsp;<i class="fa fa-eye" title="' . $lang['view'] . Util::pluralize($topicEntry['view'] ?? 0, $lang['plural']) . '"></i><br />
              ' . Util::shortNum(!empty($topicEntry['reply']) ? count($topicEntry['reply']) : 0) . '&nbsp;<i class="fa fa-comment-o" title="' . Util::pluralize(!empty($topicEntry['reply']) ? count($topicEntry['reply']) : 0, $lang['replies'], $lang['reply']) . '"></i>
            </div>

            <div class="d-block">
              ' . entryLink::manageReply($reply) . ' <span class="user ' . ($replyEntry['role'] ?? 'user') . '">' . Parser::title($replyEntry['trip'] ?? '') . '</span> ' . $lang['replied'] . ' ' . Util::toDate($reply, $config['date_format']) . '
            </div>

            <p class="tile-title">
              <a class="btn btn-sm" style="background-color:' . ($forumEntry['badge_color'] ?? '#6c757d') . '!important;color:white!important" href="view.php' . DS . 'forum' . DS . ($topicEntry['forum'] ?? '') . '"><i class="' . ($forumEntry['font_icon'] ?? 'fa fa-comments') . '"></i> ' . ($forumEntry['name'] ?? 'Forum') . '</a>
            </p>
          </div>
        </div>';
    }
}

$out['content'] .= '	        
  </div>
  ' . Paginate::pageLink($p, $total, 'index.php' . DS . 'news' . DS . 'o') . '		
</section>
<!-- /.container -->';
?>