<?php

/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

$out['self'] = 'search';
require_once __DIR__ . '/' . 'header.php';

$cur = 'search'; // Indicateur de page
$out['subtitle'] = $lang['search'];

function getQVar($key) {
    return isset($_GET[$key]) ? HTMLForm::clean($_GET[$key]) : (isset($_POST[$key]) ? HTMLForm::clean($_POST[$key]) : null);
}

if (HTMLForm::sessionTrip() && HTMLForm::check('topic') && CSRF::check($token)) {
    $wordSearch = getQVar('topic');
    $foundTopics = [];

    if ($wordSearch !== null && !empty(trim($wordSearch))) {
        // Normaliser le terme de recherche (minuscules pour comparaison)
        $wordSearchLower = mb_strtolower($wordSearch);
        $wordSearchLength = mb_strlen($wordSearch);
        
        // Limite de résultats pour éviter de traiter tous les topics (configurable, défaut: 100)
        $maxResults = 100;
        $resultCount = 0;
        
        // Optimisation : on ne charge que les topics nécessaires, pas les forums
        // Les forums ne sont pas utilisés dans la recherche, donc on évite de les charger
        foreach (flatDB::listEntry('topic') as $topic) {
            // Arrêter si on a atteint la limite de résultats
            if ($resultCount >= $maxResults) {
                break;
            }
            
            $topicEntry = flatDB::readEntry('topic', $topic);
            if (!$topicEntry) {
                continue;
            }
            
            $tag = $topicEntry['tag'] ?? '';
            $matchScore = 0; // Score de pertinence (plus élevé = plus pertinent)
            $isMatch = false;

            // Optimisation : vérifier d'abord les champs les plus rapides et les plus pertinents
            // 1. Titre (le plus pertinent, score 4)
            if (isset($topicEntry['title'])) {
                $titleLower = mb_strtolower($topicEntry['title']);
                if (mb_stripos($titleLower, $wordSearchLower) !== false) {
                    $isMatch = true;
                    // Bonus si le titre commence par le terme de recherche
                    if (mb_strpos($titleLower, $wordSearchLower) === 0) {
                        $matchScore = 5;
                    } else {
                        $matchScore = 4;
                    }
                }
            }
            
            // 2. Tag (très pertinent, score 3)
            if (!$isMatch && !empty($tag)) {
                $tagLower = mb_strtolower($tag);
                if (mb_stripos($tagLower, $wordSearchLower) !== false) {
                    $isMatch = true;
                    $matchScore = 3;
                }
            }
            
            // 3. Auteur (pertinent, score 2)
            if (!$isMatch && isset($topicEntry['trip'])) {
                if (mb_stripos(mb_strtolower($topicEntry['trip']), $wordSearchLower) !== false) {
                    $isMatch = true;
                    $matchScore = 2;
                }
            }
            
            // 4. Contenu (moins pertinent mais important, score 1)
            // Optimisation : limiter la recherche au début du contenu (premiers 500 caractères)
            // pour éviter de traiter des contenus très longs
            if (!$isMatch && isset($topicEntry['content'])) {
                $contentPreview = mb_substr($topicEntry['content'], 0, 500);
                if (mb_stripos(mb_strtolower($contentPreview), $wordSearchLower) !== false) {
                    $isMatch = true;
                    $matchScore = 1;
                }
            }
            
            if ($isMatch) {
                $foundTopics[$topic] = [
                    'title' => $topicEntry['title'] ?? '',
                    'score' => $matchScore
                ];
                $resultCount++;
            }
        }
        
        // Trier par score de pertinence (du plus pertinent au moins pertinent)
        uasort($foundTopics, function($a, $b) {
            return $b['score'] - $a['score'];
        });
    }

    $out['content'] .= '
    <div class="row">
        <div class="col">';
    if ($foundTopics) {
        $resultCount = count($foundTopics);
        $out['content'] .= '<h6>' . $lang['search_term_found'] . ' (' . $resultCount . ')</h6>
        <div class="divider"></div>
        <ol>';
        foreach ($foundTopics as $topic => $data) {
            $title = is_array($data) ? $data['title'] : $data;
            $out['content'] .= '
            <li>' . entryLink::manageTopic($topic) . '
                <a href="view.php' . DS . 'topic' . DS . $topic . '">
                    ' . Parser::title($title) . '
                </a>
            </li>';
        }
        $out['content'] .= '</ol>';
    } else {
        $out['content'] .= '<div class="alert alert-primary" role="alert"><h5>' . $lang['none'] . '</h5></div>';
    }
    $out['content'] .= '
        </div>
    </div>';
}

// Liste des tags
$tagsList = flatDB::readEntry('config', 'tags');
$tagsOption = '';
$hasVisibleTags = false;

// Vérifier s'il y a des tags visibles
if (!empty($tagsList) && is_array($tagsList)) {
    foreach ($tagsList as $tag) {
        if (!empty($tag['hidden_tag'])) {
            continue; // Ignorer les tags cachés
        }
        $hasVisibleTags = true;
        $tagsOption .= '<button type="button" class="btn btn-outline-primary btn-sm m-1" onclick="document.forms[\'form\'][\'topic\'].value += \'' . htmlspecialchars($tag['title'], ENT_QUOTES, 'UTF-8') . '\'">' . htmlspecialchars($tag['title'], ENT_QUOTES, 'UTF-8') . '</button>';
    }
}

// Fix pour récupérer le hash s'il y a
$url = HTMLForm::clean(isset($_REQUEST['topic']) ? $_REQUEST['topic'] : null);

// Template search.tpl.php
require THEME_DIR . $config['theme'] . DS . 'search.tpl.php';
require PATH_ROOT . DS . 'footer.php';
?>