<?php 
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 *
 * @string  ?u=[username] 	(requis)
 * @integer	?sz=[size]	  	(optionnel)
 * @option	?d=dot		  	(optionnel) carré par défaut
 *
 * Exemple : avatar.php?u=username&sz=80&d=dot
*/

// Définir le chemin de base de manière sécurisée
define('PATH_GEN_AVATAR', __DIR__ . '/../../uploads/avatars/generates/');

###############################
#                             #
#  ░░░░  ░   ░░  ░░░░  ░░░░░░ #
#   ░░   ░░  ░░   ░░   ░ ░░ ░ #
#   ░░   ░░░ ░░   ░░     ░░   #
#   ░░   ░░░░░░   ░░     ░░   #
#   ░░   ░░ ░░░   ░░     ░░   #
#   ░░   ░░  ░░   ░░     ░░   #
#  ░░░░  ░░   ░  ░░░░   ░░░░  #
#                             #
###############################

// Validation et sécurisation des paramètres
$avatar_filename = '';
$f = PATH_GEN_AVATAR; // Utiliser le chemin défini en constante
$size = 80;
$d = '';

// Vérifier que le répertoire existe
if (!is_dir($f)) {
    @mkdir($f, 0777, true);
}

// Taille en px avec validation (10-200px)
if (!empty($_GET['sz'])) {
    $size = max(10, min(200, intval($_GET['sz'])));
}

// Point ou carré
if (!empty($_GET['d']) && $_GET['d'] === 'dot') {
    $d = 'dot';
}

// Nom de fichier une fois généré
$avatar_filename = 'x' . $size . $avatar_filename . $d . '.png';

// On réduit la taille des points avec validation
$dotsize = max(1, $size / 9);

##################################################################
#                                                                #
# ░░░░░░ ░░  ░░ ░   ░░  ░░░░  ░░░░░░  ░░░░   ░░░░  ░   ░░  ░░░░  #
# ░░     ░░  ░░ ░░  ░░ ░░  ░░ ░ ░░ ░   ░░   ░░  ░░ ░░  ░░ ░░  ░░ #
# ░░     ░░  ░░ ░░░ ░░ ░░       ░░     ░░   ░░  ░░ ░░░ ░░  ░░    #
# ░░░░░  ░░  ░░ ░░░░░░ ░░       ░░     ░░   ░░  ░░ ░░░░░░   ░░   #
# ░░     ░░  ░░ ░░ ░░░ ░░       ░░     ░░   ░░  ░░ ░░ ░░░    ░░  #
# ░░     ░░  ░░ ░░  ░░ ░░  ░░   ░░     ░░   ░░  ░░ ░░  ░░ ░░  ░░ #
# ░░      ░░░░  ░░   ░  ░░░░   ░░░░   ░░░░   ░░░░  ░░   ░  ░░░░  #
#                                                                #
##################################################################

function separatRGB($color){
    $color=str_replace('#','',$color);
    if (strlen($color)==3){
        $color=$color[0].$color[0].$color[1].$color[1].$color[2].$color[2];
    }
    $RGB=array();
    $RGB['r']=hexdec(substr($color, 0,2));
    $RGB['g']=hexdec(substr($color, 2,2));
    $RGB['b']=hexdec(substr($color, 4,2));  
    return $RGB;
}

function drawLine($linenb,$pattern,$size,$dots=false){
	global $image,$couleur_avatar,$couleur_fond;
	for ($i=0;$i<9;$i++){
		$x=$i*$size;
		$y=$linenb*$size;
		if ($pattern[$i]==1){
			if (!$dots)
				imagefilledrectangle ( $image , $x,$y  , $x+$size ,$y+$size , $couleur_avatar );
			else
				imagefilledellipse ( $image , $x+($size/2),$y+($size/2)  , $size ,$size , $couleur_avatar );
		}else{
			imagefilledrectangle ( $image , $x,$y  , $x+$size ,$y+$size ,$couleur_fond);
		}
	}
}

###########################################################
#                                                         #
#  ░░░░  ░░░░░░ ░   ░░ ░░░░░░ ░░░░░   ░░░░  ░░░░░░ ░░░░░░ #
# ░░  ░░ ░░     ░░  ░░ ░░     ░░  ░░ ░░  ░░ ░ ░░ ░ ░░     #
# ░░     ░░     ░░░ ░░ ░░     ░░  ░░ ░░  ░░   ░░   ░░     #
# ░░ ░░░ ░░░░░  ░░░░░░ ░░░░░  ░░░░░  ░░░░░░   ░░   ░░░░░  #
# ░░  ░░ ░░     ░░ ░░░ ░░     ░░  ░░ ░░  ░░   ░░   ░░     #
# ░░  ░░ ░░     ░░  ░░ ░░     ░░  ░░ ░░  ░░   ░░   ░░     #
#  ░░░░  ░░░░░░ ░░   ░ ░░░░░░ ░░  ░░ ░░  ░░  ░░░░  ░░░░░░ #
#                                                         #
###########################################################

if (!empty($_GET['u'])){
	$username = urldecode($_GET['u']);
	// Validation de sécurité : limiter la longueur du username
	if (strlen($username) > 255) {
		http_response_code(400);
		exit('Username too long');
	}
	
	# Formatage numérique du pseudo
	$h1 = hash('crc32', $username);
	$h2 = hash('crc32b', $username);
	# Génération des couleurs de fond et de l'avatar
	$c1 = separatRGB($h1);
	$c2 = separatRGB($h2);
	# Pseudo formaté
	$s = $h1 . ($h2[0] ?? '0');
	# Path du fichier formatté
	$file = $f . $s . $avatar_filename;
	
	# Si l'image est déjà générée, envoi au navigateur avec cache
	if (is_file($file)){
		header("Content-type: image/png");
		header("Cache-Control: public, max-age=31536000"); // Cache 1 an
		header("Expires: " . gmdate('D, d M Y H:i:s', time() + 31536000) . " GMT");
		header("Last-Modified: " . gmdate('D, d M Y H:i:s', filemtime($file)) . " GMT");
		readfile($file);
		exit;
	}
	
	# Sinon création de l'image avec gestion d'erreur
	if (!function_exists('ImageCreate')) {
		http_response_code(500);
		exit('GD library not available');
	}
	
	$image = @ImageCreate($size, $size);
	if ($image === false) {
		http_response_code(500);
		exit('Error creating image');
	}
	
	$couleur_fond   = ImageColorAllocate($image, $c1['r'], $c1['g'], $c1['b']);
	$couleur_avatar = ImageColorAllocate($image, $c2['r'], $c2['g'], $c2['b']);
	
	if ($couleur_fond === false || $couleur_avatar === false) {
		imagedestroy($image);
		http_response_code(500);
		exit('Error allocating colors');
	}

	// Génération du pattern
	$a = [];
	$a[dechex(0)] = '000010000';
	$a[dechex(16)] = '111111111';
	
	for ($i = 1; $i <= 15; $i++) {
		$bin = decbin($i);
		$bin = str_repeat('0', 4 - strlen($bin)) . $bin;
		$a[dechex($i)] = $bin . '1' . strrev($bin);
	}
	
	// Dessiner les lignes
	for ($i = 0; $i < 9; $i++) {
		$char = $s[$i] ?? '0';
		$pattern = $a[$char] ?? $a[dechex(0)];
		drawLine($i, $pattern, $dotsize, $d);
	}
	
	// Créer le répertoire si nécessaire
	$dir = dirname($file);
	if (!is_dir($dir)) {
		@mkdir($dir, 0777, true);
	}
	
	// Envoyer l'image
	header("Content-type: image/png");
	header("Cache-Control: public, max-age=31536000"); // Cache 1 an
	header("Expires: " . gmdate('D, d M Y H:i:s', time() + 31536000) . " GMT");
	
	// Sauvegarder et afficher
	if (@imagepng($image, $file)) {
		@chmod($file, 0644);
	}
	imagepng($image);
	imagedestroy($image);
} else {
	http_response_code(400);
	exit('Missing username parameter');
}
?>