<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['image']['tmp_name'];
        $fileName = $_FILES['image']['name'];
        $fileSize = $_FILES['image']['size'];
        $fileType = $_FILES['image']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        $allowedfileExtensions = ['jpg', 'gif', 'png'];
        $maxFileSize = 5 * 1024 * 1024; // 5 Mo

        if ($fileSize > $maxFileSize) {
            echo 'La taille du fichier dépasse la limite de 5 Mo.';
            exit;
        }

        if (in_array($fileExtension, $allowedfileExtensions)) {
            // Chemin d'accès modifié pour pointer vers Racine/uploads/
            $uploadFileDir = dirname(__DIR__) . '/uploads/';
            $newFileName = md5(time() . $fileName) . '.' . $fileExtension;
            $dest_path = $uploadFileDir . $newFileName;

            if (move_uploaded_file($fileTmpPath, $dest_path)) {
                echo 'Fichier téléchargé avec succès : ' . $dest_path;
            } else {
                echo 'Erreur lors du déplacement du fichier.';
            }
        } else {
            echo 'Échec du téléchargement. Types de fichiers autorisés : ' . implode(',', $allowedfileExtensions);
        }
    } else {
        echo 'Il y a eu une erreur lors du téléchargement du fichier.';
    }
}
?>