<?php
/*
 * Project name: Chinese version of Flatboard
 * Project URL: https://github.com/arleycn/Flatboard_Chinese
 * Author: Arley
 * Last update: 2025.02.08
 * All Flatboard code is released under the MIT license.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
# SetLocal
setlocale(LC_ALL, "zh-CN");
# Définit le décalage horaire par défaut de toutes les fonctions date/heure  
date_default_timezone_set("Asia/ShangHai");
# Definit l'encodage interne
mb_internal_encoding("UTF-8");

$lang = array(
'fr-FR'             => 'French',
'en-US'             => 'English',
'ru-RU'             => 'Russian',
'de-DE'             => 'German',
'it-IT'             => 'Italian',
'es-ES'             => 'Español',
'zh-CN'             => 'Chinese',

'in'  => ' <i class="fa fa-clock-o"></i>',
/************* install.php ***************/
'php_version' => '你必须有一台装有 <b>PHP 5.2</b> 或更高版本的服务器来安装 <b>Flatboard</b>!',
'flatBoard_installer' => 'FlatBoard论坛的安装程序',
'welcome_installer' => '欢迎使用Flatboard安装程序',
'site_title' => '您的网站标题',
'site_slogan' => '副标题/网站描述',
'your_admin_psw' => '必须是以下类型：user@mypassword',
'site_mail' => '输入你的管理员电子邮件地址',
'install' => '安装',
'installed_title' => '<i class="fa fa-bullhorn"></i> 耶~ Flatboard已经安装成功啦~',
'installed_msg' => '现在，您可以创建论坛了，并开始与大家讨论! 如需帮助请 <a href="https://flatboard.org/view.php/plugin/page/p/docs">阅读DOC </a>.',

/************* config.php ***************/
'homepage' => '首页',
'footer_text' => '页脚文本',
'announcement' => '公告',
'announcement_desc' => '留空，不显示公告（允许使用HTML）。',
'ItemByPage' => '每页的帖子数量',
'date_format' => '日期格式',
'date_format_desc' => '当地时间/日期的格式 => <a href="http://php.net/manual/en/function.date.php">PHP doc</a>. 支持 strftime 格式 (%A, %d, %B 等) 和 DateTime 格式 (l, d, F 等).',
'date_format_placeholder' => 'Y/m/d H:i',
'default_date_format' => 'l jS F o, H:i:s',
'short_date_format' => '短日期格式',
'date_format_full' => '完整 (strftime)',
'date_format_standard' => '标准',
'date_format_european' => '欧洲',
'date_format_iso' => 'ISO 8601',
'date_format_us' => '美国格式',
'date_format_short_european' => '欧洲',
'date_format_short_standard' => '标准',
'date_format_short_iso' => 'ISO',
'date_format_short_us' => '美国',
'date_format_preview' => '预览',
'date_format_preset' => '预设格式',
'date_format_custom' => '自定义格式',
'maintenance' => '维护',
'maintenance_desc' => ' 论坛页面因维护而处于离线状态。请稍后再来。:-)',
'ban_list' => '禁用名单',
'ban_ok'  => '这个IP地址现在是未经授权的。',
'ban_fail' => '这个IP地址已经被禁止了。',
'invalid_ip' => '无效的IP地址或CIDR范围',
'ban_help' => '您可以禁止单个IP（例如：192.168.1.1）或CIDR范围（例如：192.168.1.0/24）',
'ban_ip_desc' => '输入IP地址或CIDR范围（例如：192.168.1.0/24）',
'confirm_unban' => '您确定要从禁用列表中删除此IP吗？',
'add_ban' => '添加要禁止的IP',
'no_results' => '未找到结果',
'filtered' => '已过滤',
'ban_cidr_help' => '您可以使用CIDR表示法禁止IP范围（例如：192.168.1.0/24）',
'type' => '类型',
'ip_address' => 'IP地址',
'ip_addresses' => 'IP地址',
'actions' => '操作',
'visibility' => '可见性',
'visible' => '可见',
'hidden' => '隐藏',
'tag' => '标签',
'workers' => '版主',
'to_get_started' => '开始',
'confirm_delete' => '您确定要删除此项目吗？',
'dashboard' => '仪表板',
'add_worker' => '添加一个版主',
'save' => '保存',
'update' => '更新 ',
'theme' => '主题 ',
'theme_desc' => '<a href="config.php/deletecache" class="btn btn-primary btn-sm"><i class="fa fa-trash" aria-hidden="true"></i> 清除缓存</a>',
'cache_clean' => '缓存已清理',
'folder_deleted' => '目录已成功删除',
'folder_error' => '目录删除时出错',
'lang' => '语言',
'editor' => '编辑',
'bbcode' => 'BBcode',
'markdown' => 'Markdown',
'editor_desc' => 'BBcode或Markdown格式',
'style' => '颜色方案 ' .Util::Help('允许你自定义导航栏的颜色。'),
'style_placeholder' => 'slateblue, #000000…',
'nb_page_scroll_infinite' => '自动滚动的页面数',
'nb_page_scroll_desc' => '设为1，禁用自动滚动。',
'salt' => '安全密钥',
'salt_desc' => '留空以生成一个密钥',
'manage_tags' => '管理标签',
'tags' => '标签',
'tags_help' => '标签允许您"标记"您的讨论的标题。它们使标题更有吸引力，然后作为你在论坛上搜索的一个过滤器。<br/>要显示它们，在下面的列表中至少插入一个。
<br/>在新讨论的形式中，你会看到一个标签选择器出现。<div class="divider"></div>当方框被选中时，当讨论被发布时，该关键词仍然从列表中不可见。这个关键词起到对用户名进行过滤的作用，成为一个经过验证的身份。我们提供了一个示例代码，但你可以自由修改它。',
'tags_empty' => '标签列表为空!',
'replace' => '替换',
'tags_result' => '结果',
'blog' => '博客',
'blog_new' => '选择一个能向你的博客发送新闻的论坛。',
'disable_blog' => '禁用博客',
'post_summary' => '文章摘要字数',
'hidden_tag' => '隐藏这个标签',
'title_tag' => '[我的标签]',
'user' => '用户',
'username_check' => '验证用户名',
'user_checked' => '已验证用户',
'back_to_site' => '返回站点',
'good-morning' => '早上好',
'good-afternoon' => '下午好',
'good-evening' => '晚上好',
'good-night' => '晚安',
'hello' => '你好',
'note' => '注意事项',

/************* dashboard ***************/
'pro_edition' => 'PRO - 感谢支持Flatboard',
'standard_edition' => '标准 - <a class="btn btn-link" href="https://flatboard.org/download.php" onclick="window.open(this.href); return false;">升级到Flatboard PRO</a>',

/************* Msg System ***************/
'warning_installation_file' => 'install.php文件仍然可以在你的Flatboard根目录下找到。<br />出于安全考虑，强烈建议 <a class="badge badge-danger" href="config.php/delinstallfile" title="delete now?">删除它</a>.',
'new_version' => '新的版本可用',
'theme_not_found' => '未找到主要的Flatboard主题',

/************* add.php ***************/
'topic_added' => '主题已添加!',
'reply_added' => '回复已添加!',
'forum_added' => '论坛已添加！',
'write_post' => '写一篇文章...',
'modo_added' => '新版主加入!',
'trip' => '匿名 ' .Util::Help('不需要 "注册"，只要每次都输入你选择的相同的名字@密码。为了安全起见，你的密码将显示为加密和散列给访问者!'),
'badge_color' => '徽章颜色',
'badge_color_desc' => '输入一个十六进制的颜色。',
'font_icon' => '图标分类',
'font_icon_placeholder' => 'fa-folder',
'font_icon_desc' => '前往 <a href="http://fontawesome.io/icons/">Font Awesome</a> 网站选择图标。',
'email_sent' => '邮件发送成功',
'email_nosent' => '无法发送电子邮件',
'report_desc' => '注意：版主将被告知你所报告的页面的链接。<br />此表格仅用于报告不良内容，不应作为其他原因与版主沟通的手段。',
'your_email' => '你的电子邮件地址，以防万一',
'click_to_view_post' => '点击这里查看帖子',
'order' => 'Order',
'flood_start' => '帖子之间至少要有60秒的间隔。请等待 %s 分钟，然后再尝试发帖',
'private' => '启用私人访问网站',
'restrict_access' => '将网站的访问权限制在论坛小组。',
'private_msg' => '对不起，你没有权限打开这个页面。',
'unauthorized_access' => '未经授权的访问',
'no_tag' => '无标签',
'more_info' => '点击此处了解更多详情',
'cancel' => '取消',
'choose_pic' => '选择一张图片',
'upload' => '上传',
'private_forum' => '私人论坛',
'private_forum_desc' => '只有论坛小组人员才能进入论坛。',
'the_specified_color_is_not_valid' => '錯誤：指定的顏色無效',

/************* delete.php ***************/
'topic_deleted' => '主题已删除!',
'reply_deleted' => '回复已删除!',
'forum_deleted' => '论坛已被删除!',
'worker_deleted' => '版主已删除!',
'ip_not_banned' => '这个IP地址没有被禁止。',
'ip_removed' => '该IP地址已被删除。',

/************* edit.php ***************/
'topic_edited' => '主题已编辑!',
'reply_edited' => '回复已编辑！',
'forum_edited' => '论坛已编辑！',
'pinned_homepage' => '固定在首页',
'pick_font' => '选择一个图标',
'useSpace' => true,
'home' => '首页',
'thread_sug'  => '建议的主题',
'change_pwd'  => '更改我的密码',
'topic' => '主题',
'newthread' => '开始讨论',
'reply' => '回复',
'replies' => '回答',
'newreply' => '新的回复',
'quote_reply' => '引用中的回复',
'quote_by' => '引用',
'add_forum'   => '添加论坛',
'plugin' => '插件 ',
'config' => '配置',
'logout' => '登出',
'login' => '登录',
'redirect' => '返回到',
'add' => '添加',
'edit' => '编辑',
'delete' => '删除',
'title' => '标题',
'content' => '内容',
'name' => '姓名',
'mail' => 'Email',
'mail_desc' => '不公开',
'not_required' => '(不需要)',
'search' => '搜索',
'forum' => '论坛 ',
'password' => '密码',
'confirm_password' => '确认密码',
'powered' => '创建 <a href="https://flatboard.org" onclick="window.open(this.href); return false;">Flatboard' .(defined('FLATBOARD_PRO')?' Pro':''). '</a> 和 <i class="fa fa-heart"></i>.',
'feed' => 'Feed',
'none' => '迄今为止，没有任何帖子',
'info' => '资料',
'date' => '日期',
'activity' => '活动',
'view' => '查看',
'count' => '发布',
'new' => 'New',
'more' => '更多',
'submit' => '提交',
'admin' => '管理员',
'worker' => '用户',
'sort_forums' => '论坛分类',
'yes' => '是',
'no' => '否',
'locked' => '已锁定',
'no_reply' => '不能回复',
'locked_discussion' => '讨论已关闭',
'report' => 'Report',
'day' => 'day',
'hour' => 'hour',
'minute' => 'minute',
'second' => 'second',
'plural' => 's',
'ago' => 'ago',
'errLen' => '太短/太长',
'errBot' => '验证码不正确',
'errNb' => '这不是一个正整数。',
'ErrContentFilter' => '你至少插入了一个被禁止的词，请注意！',
'pinned' => 'Pinned',
'stickied_discussion' => '讨论已加标签',
'replied' => '<i class="fa fa-share-square"></i> 回答 ',
'started' => '<i class="fa fa-bolt"></i> 发起 ',
'notFound' => '哎呀! 该页面不存在 :(',
'errNotMatch' => '密码错误或账号不正确',
'captcha' => '验证码',
'enter_code' => '输入安全码',
'math_result' => '这道题的答案',
'math_captcha' => '使用数字验证码？',
'r_captcha'   => '重新加载图片',
'quickNav' => '快速浏览',
'invalid_token' => '无效令牌!',
'mail_available' => '邮件发送功能可用',
'mail_not_available' => '邮件发送功能不可用',
'statistics' => '统计数据',
'start' => '<div class="alert alert-primary" role="alert"><h6>祝贺您! Flatboard现在已经正确安装。</h6>首先，你必须添加一个论坛。<a href="add.php/forum" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i></a></div>',
'no-forum' => '没有显示的论坛。',

/************* view.php ***************/
'permalink' => '热烈祝贺',
'solved' => '解决了',
'original_message' => '讨论来源',
'last_modified' => '最后一次修改是由 %s 在',
'last_post' => '最后一个帖子',
'user_activity' => '查看他的活动。',
'error' => 'ERROR',
'no_plugin' => '此插件不存在或未被启用!',
'want_more' => '想了解更多信息吗？ <a href="index.php' . DS . 'forum">浏览所有分类</a> or <a href="' .HTML_BASEPATH. '">查看最新主题</a>.',
'close_del_content' => '点击这个按钮关闭此窗口并删除内容。',
'reply_this_topic' => '加入讨论',

/************* search.php ***************/
'search_term_found' => '找到的搜索关键词。',
'search_desc' => '可用作者、标题、标签和主题的内容来搜索',
'search_holder' => '作者、标题、标签或内容。',
'click_tag_search' => '点击要插入搜索的标签。',

/************* Plugin ***************/
'state'        => '开启/关闭插件',
'state_on'     => '开启',
'state_off'    => '关闭',
'data_save'    => '已保存!',
'description'  => '描述',
'author'       => '作者',
'check_all'    => '查看全部',
'plugin_help'    => '<i class="fa fa-warning"></i> 帮助',
'manage_plugin'    => '管理插件',
'cantDisable'  => '该插件不能被禁用。',
'click_to_active'=>'启动该插件。',
'click_to_disable'=>'禁用该插件。',

/************* auth.php ***************/
'password_changed' => '您的密码已修改成功！',
'edit_password' => '更改密码',
'login_confirm' => '登录成功，欢迎回来~',
'logout_confirm' => '已注销',
'incorrect_password' => '密码不正确',
'error_maxlogin' => '登录失败次数过多。请在 %s 分钟后重试。',
'already_logged' => '你已经登录了!',
'already_logged_msg' => '你已经以 <b>%s</b> 的身份登录, 你需要在以不同的用户身份登录前退出。',
'bad_user_syntax' => '你的用户名必须包含以下字符： <b>name@password</b>',
'previous_page' => '上一页',

/************* services.php ***************/
'ban_user' => '禁止此IP',
'unban_user' => '解除对该IP的封禁',
'banned' => '你已经被禁止了!',
'your_banned' => '您已经被永久性进入此论坛 <br/>如有疑问请联系论坛管理员。<br/>禁令原因：已违规<br />您的 ip: ',
'has_banned' => ' 已被禁止!',
'ban' => 'IP地址/ IP地址范围'

);
?>
