<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * Last update: 2025.02.08
 * All Flatboard code is released under the MIT license.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
# SetLocal
setlocale(LC_ALL, "en_US");
# Définit le décalage horaire par défaut de toutes les fonctions date/heure  
date_default_timezone_set("Europe/London");
# Definit l'encodage interne
mb_internal_encoding("ISO-8859-1");

$lang = array(
'fr-FR'             => 'French',
'en-US'             => 'English',
'ru-RU'             => 'Russian',
'de-DE'             => 'German',
'it-IT'             => 'Italian',
'es-ES'             => 'Español',
'zh-CN'             => 'Chinese',

'in'  => ' <i class="fa fa-clock-o"></i>',
/************* install.php ***************/
'php_version' => 'You must have a server with <b>PHP 5.2</b> or later to install <b>Flatboard</b>!',
'flatBoard_installer' => 'FlatBoard Installer',
'welcome_installer' => 'Welcome to the Flatboard installer',
'site_title' => 'Your site title',
'site_slogan' => 'Subtitle / Site description',
'your_admin_psw' => 'Must be the type: user@mypassword',
'site_mail' => 'Your admin mail account here',
'install' => 'Install',
'installed_title' => '<i class="fa fa-bullhorn"></i> Yeah! Flatboard is now installed',
'installed_msg' => 'Now, create forums and start discussing with the world! Need help? Please <a href="https://flatboard.org/view.php/plugin/page/p/docs">read the DOC</a>.',

/************* config.php ***************/
'homepage' => 'Home Page',
'footer_text' => 'Footer text',
'announcement' => 'Announcement',
'announcement_desc' => 'Leave blank to not display announcement (HTML allowed).',
'ItemByPage' => 'Item by page',
'date_format' => 'Date Format',
'date_format_desc' => 'Format a local time/date => <a href="http://php.net/manual/en/function.date.php">PHP doc</a>. Supports strftime format (%A, %d, %B, etc.) and DateTime format (l, d, F, etc.).',
'date_format_placeholder' => 'Y/m/d H:i',
'default_date_format' => 'l jS F o, H:i:s',
'short_date_format' => 'Short date format',
'date_format_full' => 'Full (strftime)',
'date_format_standard' => 'Standard',
'date_format_european' => 'European',
'date_format_iso' => 'ISO 8601',
'date_format_us' => 'US Format',
'date_format_short_european' => 'European',
'date_format_short_standard' => 'Standard',
'date_format_short_iso' => 'ISO',
'date_format_short_us' => 'US',
'date_format_preview' => 'Preview',
'date_format_preset' => 'Preset format',
'date_format_custom' => 'Custom format',
'maintenance' => 'Maintenance',
'maintenance_desc' => ' Forums are down for maintenance. Please check back shortly. :)',
'ban_list' => 'Ban List',
'ban_ok'  => 'This IP address is now unauthorized.',
'ban_fail' => 'This IP address is already banned.',
'invalid_ip' => 'Invalid IP address or CIDR range',
'ban_help' => 'You can ban a single IP (e.g., 192.168.1.1) or a CIDR range (e.g., 192.168.1.0/24)',
'ban_ip_desc' => 'Enter an IP address or CIDR range (e.g., 192.168.1.0/24)',
'confirm_unban' => 'Are you sure you want to remove this IP from the ban list?',
'add_ban' => 'Add IP to ban',
'no_results' => 'No results found',
'filtered' => 'filtered',
'ban_cidr_help' => 'You can ban IP ranges using CIDR notation (e.g., 192.168.1.0/24)',
'type' => 'Type',
'ip_address' => 'IP Address',
'ip_addresses' => 'IP Addresses',
'actions' => 'Actions',
'visibility' => 'Visibility',
'visible' => 'Visible',
'hidden' => 'Hidden',
'tag' => 'Tag',
'workers' => 'Moderators',
'to_get_started' => 'to get started',
'confirm_delete' => 'Are you sure you want to delete this item?',
'dashboard' => 'Dashboard',
'add_worker' => 'Add a moderator',
'save' => 'Save',
'update' => 'Update ',
'theme' => 'Theme',
'theme_desc' => '<a href="config.php/deletecache" class="btn btn-primary btn-sm"><i class="fa fa-trash" aria-hidden="true"></i> Clear cache</a>',
'cache_clean' => 'Cache Cleaned',
'folder_deleted' => 'Folder sucessfully deleted',
'folder_error' => 'Error during the folder deletion',
'lang' => 'Language',
'editor' => 'Editor',
'bbcode' => 'BBcode',
'markdown' => 'Markdown',
'editor_desc' => 'BBcode or markdown format',
'style' => 'Color scheme ' .Util::Help('Allows you to customize the color of the navigation bar.'),
'style_placeholder' => 'slateblue, #000000…',
'nb_page_scroll_infinite' => 'How many pages to scroll automatically',
'nb_page_scroll_desc' => 'Set to 1 to disable automatic scrolling.',
'salt' => 'Key security',
'salt_desc' => 'Leave blank to generate a key',
'manage_tags' => 'Manage Tags',
'tags' => 'Tags',
'tags_help' => 'Tags allow you to "mark" the titles of your discussions. They make the title more attractive and then serve as a filter in your searches on the forum.<br />To display them, insert at least one in the list below.<br />In the form of a new discussion, you will see a tags selector appear.<div class="divider"></div>When the box is checked, the keyword remains invisible from the list when a discussion is published. This keyword plays the role of filtering on user names, to become a verified identity. A sample code is provided, but free to you to modify it.',
'tags_empty' => 'Tags list empty!',
'replace' => 'Replacement',
'tags_result' => 'Result',
'blog' => 'Blog',
'blog_new' => 'Select a forum that will serve news to your blog.',
'disable_blog' => 'Disable the blog',
'post_summary' => 'Number words of the post for summary.',
'hidden_tag' => 'Hidden this tag',
'title_tag' => '[My Tag]',
'user' => 'User',
'username_check' => 'Username to check',
'user_checked' => 'User checked',
'back_to_site' => 'Back to site',
'good-morning' => 'Good morning',
'good-afternoon' => 'Good afternoon',
'good-evening' => 'Good evening',
'good-night' => 'Good night',
'hello' => 'Hello',
'note' => 'Note',

/************* dashboard ***************/
'pro_edition' => 'PRO - Thanks for support Flatboard',
'standard_edition' => 'Standard - <a class="btn btn-link" href="https://flatboard.org/download.php" onclick="window.open(this.href); return false;">Upgrade to Flatboard PRO</a>',

/************* Msg System ***************/
'warning_installation_file' => 'install.php file can still be found at your Flatboard root.<br />For security reasons, it is strongly recommended to <a class="badge badge-danger" href="config.php/delinstallfile" title="delete now?">delete it</a>.',
'new_version' => 'New version available',
'theme_not_found' => 'Main Flatboard theme not found',

/************* add.php ***************/
'topic_added' => 'Topic added!',
'reply_added' => 'Reply added!',
'forum_added' => 'Forum added!',
'write_post' => 'Write a Post…',
'modo_added' => 'New moderator added!',
'trip' => 'Pseudo ' .Util::Help('There is no need to “register”, just enter the same name@password of your choice every time. Your password will be displayed encrypted and hashed to visitors for security reasons!'),
'badge_color' => 'Badge color',
'badge_color_desc' => 'Enter a hexadecimal color.',
'font_icon' => 'Icon category',
'font_icon_placeholder' => 'fa-folder',
'font_icon_desc' => 'Go to <a href="http://fontawesome.io/icons/">Font Awesome</a> website for choose a icon',
'email_sent' => 'Email sent successfully',
'email_nosent' => 'Could not send email',
'report_desc' => 'Note: The moderator will be made aware link to the page you are reporting.<br />This form is ONLY for reporting objectionable content and should not be used as a means of communicating with moderators for other reasons.',
'your_email' => 'Your email address just in case',
'click_to_view_post' => 'Click here to view the post',
'order' => 'Order',
'flood_start' => 'At least 60 seconds have to pass between posts. Please wait %s minutes and try posting again.',
'private' => 'Make private access to the site.',
'restrict_access' => 'Restrict access to the site to the forum team.',
'private_msg' => 'Sorry, you don\'t have permissions to open this page.',
'unauthorized_access' => 'Unauthorized access',
'no_tag' => 'NO TAG',
'more_info' => 'Click here for more details',
'cancel' => 'Cancel',
'choose_pic' => 'Choose a picture',
'upload' => 'Upload',
'private_forum' => 'Private forum',
'private_forum_desc' => 'Forum accessible only to the site team.',
'the_specified_color_is_not_valid' => 'Error: The specified color is not valid.',

/************* delete.php ***************/
'topic_deleted' => 'Topic deleted!',
'reply_deleted' => 'Reply deleted!',
'forum_deleted' => 'Forum deleted!',
'worker_deleted' => 'Moderator deleted!',
'ip_not_banned' => 'This IP address was not banned.',
'ip_removed' => 'The IP address has been removed.',

/************* edit.php ***************/
'topic_edited' => 'Topic edited!',
'reply_edited' => 'Reply edited!',
'forum_edited' => 'Forum edited!',
'pinned_homepage' => 'Pinned in home',
'pick_font' => 'Pick a icon',
'useSpace' => true,
'home' => 'Home',
'thread_sug'  => 'Suggested Topics',
'change_pwd'  => 'Change my password',
'topic' => 'Topic',
'newthread' => 'Start a Discussion',
'reply' => 'Reply',
'replies' => 'Replies',
'newreply' => 'New reply',
'quote_reply' => 'Reply in quote',
'quote_by' => 'Quote by',
'add_forum'   => 'Add Forum',
'plugin' => 'Plugin',
'config' => 'Config',
'logout' => 'Logout',
'login' => 'Login',
'redirect' => 'Go back to',
'add' => 'Add',
'edit' => 'Edit',
'delete' => 'Delete',
'title' => 'Title',
'content' => 'Content',
'name' => 'Name',
'mail' => 'Email',
'mail_desc' => 'never shown to the public',
'not_required' => '(not required)',
'search' => 'Search',
'forum' => 'Forum',
'password' => 'Password',
'confirm_password' => 'confirm password',
'powered' => 'Created with <a href="https://flatboard.org" onclick="window.open(this.href); return false;">Flatboard' .(defined('FLATBOARD_PRO')?' Pro':''). '</a> and <i class="fa fa-heart"></i>.',
'feed' => 'Feed',
'none' => 'No entry so far',
'info' => 'Information',
'date' => 'Date',
'activity' => 'Activity',
'view' => 'View',
'count' => 'Post',
'new' => 'New',
'more' => 'Continue reading',
'submit' => 'Submit',
'admin' => 'Administrator',
'worker' => 'Moderator',
'sort_forums' => 'Sort forums',
'yes' => 'Yes',
'no' => 'No',
'locked' => 'Locked',
'no_reply' => 'Can\'t Reply',
'locked_discussion' => 'locked the discussion.',
'report' => 'Report',
'day' => 'day',
'hour' => 'hour',
'minute' => 'minute',
'second' => 'second',
'plural' => 's',
'ago' => 'ago',
'errLen' => 'Too short / long',
'errBot' => 'Incorrect CAPTCHA',
'errNb' => 'This is not a positive whole number',
'ErrContentFilter' => 'You have inserted at least one censored word, please be polite.',
'pinned' => 'Pinned',
'stickied_discussion' => 'stickied the discussion.',
'replied' => '<i class="fa fa-share-square"></i> replied ',
'started' => '<i class="fa fa-bolt"></i> started ',
'notFound' => 'Oops! The page does not exist :(',
'errNotMatch' => 'Mismatched password',
'captcha' => 'Captcha',
'enter_code' => 'Enter security code',
'math_result' => 'Answer to this simple math question',
'math_captcha' => 'Use Math captcha?',
'r_captcha'   => 'Reload picture',
'quickNav' => 'Quick Navigation',
'invalid_token' => 'Invalid token!',
'mail_available' => 'Mail sending function available',
'mail_not_available' => 'Mail sending function unavailable',
'statistics' => 'Statistics',
'start' => '<div class="alert alert-primary" role="alert"><h6>Congratulations ! Flatboard is now correctly installed.</h6>To start, you must add a forum. <a href="add.php/forum" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i></a></div>',
'no-forum' => 'No forum to display.',

/************* view.php ***************/
'permalink' => 'Permalink',
'solved' => 'solved',
'original_message' => 'DISCUSSION OF ORIGIN',
'last_modified' => 'Last modified by %s on ',
'last_post' => 'Last post',
'user_activity' => 'See their activity.',
'error' => 'ERROR',
'no_plugin' => 'This plugin does not exist OR is not enabled!',
'want_more' => 'Want to read more? <a href="index.php' . DS . 'forum">Browse all categories</a> or <a href="' .HTML_BASEPATH. '">view latest topics</a>.',
'close_del_content' => 'By closing this window with this button will delete the contents.',
'reply_this_topic' => 'Join the conversation',

/************* search.php ***************/
'search_term_found' => 'Search term found.',
'search_desc' => 'The research is done on: the author, the title, the tag and the content of a topic.',
'search_holder' => 'author, title, tag or content.',
'click_tag_search' => 'Click a tag to insert in the search.',

/************* Plugin ***************/
'state'        => 'On/Off plugin',
'state_on'     => 'On',
'state_off'    => 'Off',
'data_save'    => 'Datas Save !',
'description'  => 'Description',
'author'       => 'Author',
'check_all'    => 'Check All',
'plugin_help'    => '<i class="fa fa-warning"></i> Help',
'manage_plugin'    => 'Manage plugin',
'cantDisable'  => 'This plugin can not be disabled.',
'click_to_active'=>'Activate the plugin.',
'click_to_disable'=>'Disable the plugin.',

/************* auth.php ***************/
'password_changed' => 'Your password was modified successfully!',
'edit_password' => 'Change your password',
'login_confirm' => 'Logged in successfully.',
'logout_confirm' => 'Logged out.',
'incorrect_password' => 'Incorrect password.',
'error_maxlogin' => 'Too many failed login. Retry in % s minutes.',
'already_logged' => 'You are already logged in!',
'already_logged_msg' => 'You are already logged in as <b>%s</b>, you need to log out before logging in as different user.',
'bad_user_syntax' => 'Your username must have the following syntax: <b>name@password</b>',
'previous_page' => 'the previous page.',

/************* services.php ***************/
'ban_user' => 'Ban this IP',
'unban_user' => 'Unban this IP',
'banned' => 'You have been banned!',
'your_banned' => 'You have been permanently banned from this forum.<br />Contact the administrator of the forum for more info.<br />Reason for ban: as part of our policy active against spam,<br />your ip: ',
'has_banned' => ' has been banned!',
'ban' => 'IP address / IP address ranges'

);
?>