<?php

/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
*/

$out['self'] = 'config';
require_once __DIR__  . DIRECTORY_SEPARATOR .  'header.php';

 /**
  * GESTION DES MODÉRATEURS
  **/
if(Util::isGET('worker') && User::isAdmin())
{
	$cur = 'worker'; # Indicateur de page
	$out['subtitle'] = $lang['worker'];
	$out['sub_prefix'] = '<a href="add.php' . DS . 'worker" class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="top" title="' .$lang['add_worker']. '"><i class="fa fa-plus-circle"></i> ' . $lang['add_worker'] . '</a>&nbsp;';
	
	$workers = $config['worker'] ?? [];
	
	if (!empty($workers) && is_array($workers)) {
		$out['content'] .= '<div class="table-responsive">
			<table class="table table-striped table-hover">
				<thead>
					<tr>
						<th scope="col">#</th>
						<th scope="col">' . $lang['username'] . '</th>
						<th scope="col">' . $lang['mail'] . '</th>
						<th scope="col" class="text-center">' . $lang['actions'] . '</th>
					</tr>
				</thead>
				<tbody>';
		$index = 1;
		foreach ($workers as $key => $mail) {
			# Récupération du pseudo sans le hash
			$user = strstr($key, '@', true) ?: $key;
			$out['content'] .= '
				<tr>
					<td>' . $index++ . '</td>
					<td><i class="fa fa-user-o" aria-hidden="true"></i> <a class="text-primary" data-toggle="tooltip" data-placement="top" title="' . htmlspecialchars($key) . '">' . htmlspecialchars($user) . '</a></td>
					<td><i class="fa fa-envelope-o" aria-hidden="true"></i> ' . htmlspecialchars($mail) . '</td>
					<td class="text-center"><a class="btn btn-sm btn-danger" href="delete.php' . DS . 'worker' . DS . htmlspecialchars($key) . '" data-toggle="tooltip" data-placement="top" title="' .$lang['delete']. '" onclick="return confirm(\'' . $lang['confirm_delete'] . '\');"><i class="fa fa-trash-o"></i></a></td>
				</tr>';
		}
		$out['content'] .= '
				</tbody>
			</table>
		</div>
		<p class="text-muted small">' . count($workers) . ' ' . (count($workers) > 1 ? $lang['workers'] : $lang['worker']) . '</p>';
	} else {
		$out['content'] .= '<div class="alert alert-info" role="alert">
			<i class="fa fa-info-circle"></i> ' . $lang['none'] . '
			<br /><small>' . $lang['add_worker'] . ' ' . $lang['to_get_started'] . '</small>
		</div>';
	}
}
/**
 * GESTION DES PLUGINS
 **/
else if (Util::isGET('plugin') && User::isAdmin()) {
    if (Plugin::isValidHook('config', $_GET['plugin'])) {
        $cur = isset($_GET['plugin']) ? $_GET['plugin'] : null; // Indicateur de page
        $out['subtitle'] = $lang['config'] . ' ' . $lang[$_GET['plugin'] . 'name'] ?? '';
        $plugin = $_GET['plugin'];
        $out['content'] .= '
        <div class="row">   
            <div class="col-12">    
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><i class="fa fa-plug" aria-hidden="true"></i>&nbsp;<a href="config.php' . DS . 'plugin">' . $lang['plugin'] . $lang['plural'] . '</a></li>
                    <li class="breadcrumb-item">' . ($lang[$_GET['plugin'] . 'name'] ?? '') . '</li>
                </ul>                       
                ' . Plugin::myHook('config', $_GET['plugin']) . '
            </div>
        </div>';
    }
    /**
     * TABLEAU RETOURNANT LA LISTE DES PLUGINS
     **/
    else {
        $cur = 'plugin'; // Indicateur de page
        $out['subtitle'] = $lang['manage_plugin'];
        
        $nb = PLUGS_PAGINATION;
        $total = Paginate::countPage($plugins, $nb);
        $p = Paginate::pid($total);
                
        $out['content'] .= '
        <h2 class="mb-5">
            ' . $lang['plugin'] . Util::pluralize(count($plugins)) . ' <small class="badge badge-secondary">' . count($plugins) . '</small>
        </h2>
        ' .Paginate::pageLink($p, $total, 'config.php' . DS . 'plugin' . DS . 'o'). ' 
        <div class="row">
            <div class="col-12">
                <div class="card-columns">';              
                sort($plugins);              
                if ($plugins) {
                    // Cache des fichiers de langue pour éviter les require_once répétés
                    $langCache = [];
                    $defaultLangFile = PLUGIN_DIR . 'core' . DS . 'lang' . DS . 'en-US.php';
                    
                    foreach (Paginate::viewPage($plugins, $p, $nb) as $plugin) {
                        // Optimisation : charger la langue une seule fois par plugin
                        $langKey = $plugin . '_' . $config['lang'];
                        if (!isset($langCache[$langKey])) {
                            $infoLANG = PLUGIN_DIR . $plugin . DS . 'lang' . DS . $config['lang'] . '.php';
                            if (file_exists($infoLANG)) {
                                require_once $infoLANG;
                                $langCache[$langKey] = true;
                            } else {
                                $fallbackLang = PLUGIN_DIR . $plugin . DS . 'lang' . DS . 'en-US.php';
                                if (file_exists($fallbackLang)) {
                                    require_once $fallbackLang;
                                    $langCache[$langKey] = true;
                                }
                            }
                        }

                        $data = flatDB::readEntry('plugin', $plugin);
                        $statut = ($data[$plugin . 'state'] ?? false) ? 'success' : 'secondary';
                        $statutLang = ($data[$plugin . 'state'] ?? false) ? '<i class="fa fa-cog" aria-hidden="true"></i> ' . $lang['config'] : '<i class="fa fa-plus-square" aria-hidden="true"></i> ' . $lang['install'];
                        $statutCheckbox = ($data[$plugin . 'state'] ?? false) ? 'checked' : '';
                        $updateInfo = ($lang[$plugin . 'update'] ?? false) ? ' <button type="button" class="btn btn-dark" data-toggle="tooltip" data-placement="top" title="' . $lang['update'] . ': ' . $lang[$plugin . 'update'] . '"><i class="fa fa-info" aria-hidden="true"></i></button>' : '';  
                        // DEBUGGED !             
                        $disablePlug = (is_array($data) && array_key_exists('cantDisable', $data) && $data['cantDisable']);
                        $cantDisable = $disablePlug ? 'disabled' : '';
                        $langStat = $disablePlug ? $lang['cantDisable'] : (!($data[$plugin . 'state'] ?? false) ? $lang['click_to_active'] : $lang['click_to_disable']);

                        $out['content'] .= '
                        <div id="plugin-' . $statut . '" class="card border-' . $statut . '" data-pluginid="' . htmlspecialchars($plugin) . '" data-plugincardroot="true">
                            <div class="card-header text-uppercase small">
                                <div class="custom-control custom-switch float-right" data-toggle="tooltip" data-placement="top" title="' . $langStat . '" data-plugincardtooltip="true">
                                    <input type="checkbox" class="custom-control-input" id="switch_' . htmlspecialchars($plugin) . '" ' . $statutCheckbox . ' data-corepluginswitch="true" data-corepluginid="' . htmlspecialchars($plugin) . '" ' . $cantDisable . '>
                                    <label class="custom-control-label" for="switch_' . htmlspecialchars($plugin) . '"></label>
                                </div>
                                ' . htmlspecialchars($lang[$plugin . 'name'] ?? '') . '
                            </div>
                            <div class="card-body" style="min-height:180px;max-height:180px;overflow:auto">
                                <figure class="figure float-right">
                                    <figcaption class="figure-caption">
                                        ' . (!empty($lang[$plugin . 'author_mail']) ? User::protect_email($lang[$plugin . 'author_mail'], $lang['mail']) : '') . '
                                        <span class="badge badge-info">v.' . htmlspecialchars($lang[$plugin . 'version'] ?? '') . '</span>
                                    </figcaption>
                                    <hr>                            
                                    <img src="' . HTML_PLUGIN_DIR . htmlspecialchars($plugin) . DS . 'icon.png" class="img-thumbnail" alt="icone" style="width:80px">
                                </figure>                       
                                <p class="text-uppercase small text-primary">
                                    ' . $lang['author'] . ' ' . (empty($lang[$plugin . 'author_site']) ? htmlspecialchars($lang[$plugin . 'author'] ?? '') : '<a href="' . htmlspecialchars($lang[$plugin . 'author_site'] ?? '') . '">' . htmlspecialchars($lang[$plugin . 'author'] ?? '') . '</a>') . '<br/>
                                </p>                                  
                                <p class="card-text text-muted">' . htmlspecialchars($lang[$plugin . 'description'] ?? '') . '</p>                                
                            </div>
                            <div class="card-footer" data-plugincardbutton="true">
                                ' . (Plugin::isValidHook('config', $plugin) ? '<a href="config.php' . DS . 'plugin' . DS . htmlspecialchars($plugin) . '" class="btn btn-' . $statut . '">' . $statutLang . '</a>' : '') . $updateInfo . '                                                                  
                            </div>
                        </div>';
                    }
                } else {
                    $out['content'] .= '<p>' . $lang['none'] . '</p>';
                }
        $out['content'] .= ' 
                </div>
            </div><!-- /.column col-12 -->
        </div><!-- /.row -->' .
        Paginate::pageLink($p, $total, 'config.php' . DS . 'plugin' . DS . 'o');
    }
}
/**
 * CENTRE DE NOTIFICATIONS (DASHBOARD)
 **/
else if (Util::isGET('notifications') && User::isAdmin()) {
    $cur = 'notifications'; // Indicateur de page
    $out['subtitle'] = $lang['dashboard'];
    
    // On vérifie la présence éventuelle du fichier d'installation
    if (is_file('install.php')) {
        $out['content'] .= '<div class="alert alert-danger" role="alert"><i class="fa fa-warning"></i> ' . $lang['warning_installation_file'] . '</div>';
    }
    
    $memory = '';
    if (function_exists('sys_getloadavg')) {
        $load = @sys_getloadavg();
        if ($load !== false && is_array($load)) {
            $stats = implode(', ', array_map(function($val) {
                return number_format($val, 2);
            }, $load));
            $memory .= '<tr>
                <td>System Resources</td>
                <td>
                    <strong>Memory:</strong> ' . Util::getMemory('usage') . ' (' . Util::getMemory('peak') . ') / ' . Util::getMemory('available') . '
                    <br /><strong>CPU Load:</strong> ' . $stats . ' (1min, 5min, 15min)
                </td>
            </tr>';
        }
    }
    
    // Ajout des informations mémoire même si sys_getloadavg n'est pas disponible
    if (empty($memory)) {
        $memory .= '<tr>
            <td>Memory</td>
            <td>
                Current: ' . Util::getMemory('usage') . ' | Peak: ' . Util::getMemory('peak') . ' | Available: ' . Util::getMemory('available') . '
            </td>
        </tr>';
    }

    if (defined('FLATBOARD_PRO')) {
        $flatboardEdition = '<span class="text-primary">' . $lang['pro_edition'] . '</span>';
    } else {
        $flatboardEdition = '<span class="text-warning">' . $lang['standard_edition'] . '</span>';
    }
    
    $out['content'] .= '
    <div class="table-responsive-md">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th scope="col"></th>
                    <th scope="col"></th>
                </tr>
            </thead>    
            <tbody>
                <tr>
                    <td>Flatboard edition</td>
                    <td>' . $flatboardEdition . '</td>
                </tr>
                <tr>
                    <td>Flatboard version</td>
                    <td>' . VERSION . '</td>
                </tr>        
                <tr>
                    <td>Flatboard codename</td>
                    <td>' . CODENAME . '</td>
                </tr>
                <tr>
                    <td>Flatboard build</td>
                    <td>' . BUILD . ' <small class="text-muted">(' . 
                    (($buildDate = DateTime::createFromFormat('ymd', BUILD)) !== false 
                        ? $buildDate->format('F j, Y') 
                        : BUILD) . ')</small></td>
                </tr>            
                <tr>
                    <td>CHARSET</td>
                    <td>' . CHARSET . '</td>
                </tr>
                <tr>
                    <td>PHP version</td>
                    <td>' . phpversion() . '</td>
                </tr>
                <tr>
                    <td>SERVER SOFTWARE</td>
                    <td>' . (!empty($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : '') . '</td>
                </tr>
                <tr>
                    <td>PHP modules</td>
                    <td>' . implode(', ', get_loaded_extensions()) . '</td>
                </tr>
                ' . Util::testMail(true, '<tr><td>PHP mail</td><td>#message</td></tr>') . 
                $memory . '
            </tbody>
        </table>
    </div>';
}
/**
 * SUPPRESSION DU FICHIER D'INSTALLATION
 **/
else if (Util::isGET('delinstallfile') && User::isAdmin()) {
    if (@unlink('install.php')) {
        Util::redirect('config.php' . DS . 'notifications');
        exit();
    } else {
        $out['content'] .= Plugin::redirectMsg($lang['file_error'], 'config.php', $lang['notifications'], 'alert alert-danger');
    }
}
/**
 * SUPPRESSION DU CACHE DES FICHIERS CSS DU THÈME
 **/
else if (Util::isGET('deletecache') && User::isAdmin()) {
    $out['subtitle'] = '';
    $out['content'] = '';
    $css = PATH_ROOT . DS . 'theme' . DS . $config['theme'] . DS . 'cache' . DS . 'style.min.css';
    if (@unlink($css)) {
        $out['content'] .= Plugin::redirectMsg($lang['cache_clean'], 'config.php', $lang['config'], 'alert alert-success');
    } else {
        $out['content'] .= Plugin::redirectMsg($lang['folder_error'], 'config.php', $lang['config'], 'alert alert-danger');
    }
}
/**
 * LISTE DES UTILISATEURS BANNIS
 **/
else if (Util::isGET('ban') && User::isAdmin()) {
    $cur = 'ban'; // Indicateur de page
    $out['subtitle'] = $lang['ban_list'];
    
    // Création du fichier s'il n'existe pas
    if (!file_exists(BAN_FILE)) {
        $banDir = dirname(BAN_FILE);
        if (!is_dir($banDir)) {
            @mkdir($banDir, 0777, true);
        }
        @file_put_contents(BAN_FILE, '');
    }
    
    // Recherche/filtre (optionnel)
    $search = isset($_GET['search']) ? trim($_GET['search']) : '';
    
    // Lecture et traitement optimisé des IPs bannies avec support CIDR
    $ips = @file_get_contents(BAN_FILE);
    $adresses = [];
    
    if ($ips !== false && !empty($ips)) {
        $lines = explode("\n", $ips);
        foreach ($lines as $line) {
            $line = trim($line);
            if (!empty($line) && User::isValidIpOrCidr($line)) {
                // Filtrer par recherche si demandé
                if (empty($search) || stripos($line, $search) !== false) {
                    $adresses[] = $line;
                }
            }
        }
    }
    
    // Tri des adresses
    usort($adresses, function($a, $b) {
        // Séparer les IPs simples des plages CIDR
        $aIsCidr = strpos($a, '/') !== false;
        $bIsCidr = strpos($b, '/') !== false;
        
        if ($aIsCidr !== $bIsCidr) {
            return $aIsCidr ? 1 : -1; // IPs simples en premier
        }
        
        return strcmp($a, $b);
    });
    
    $out['content'] .= '
    <div class="row mb-3">
        <div class="col-md-6">
            <form method="GET" action="config.php' . DS . 'ban" class="form-inline">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="' . ($lang['search'] ?? 'Rechercher') . '..." value="' . htmlspecialchars($search) . '">
                    <div class="input-group-append">
                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i></button>
                        ' . (!empty($search) ? '<a href="config.php' . DS . 'ban" class="btn btn-secondary"><i class="fa fa-times"></i></a>' : '') . '
                    </div>
                </div>
            </form>
        </div>
        <div class="col-md-6 text-right">
            <a href="add.php' . DS . 'ban" class="btn btn-danger"><i class="fa fa-ban"></i> ' . ($lang['add_ban'] ?? 'Ajouter une IP') . '</a>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">' . $lang['ip_address'] . '</th>
                    <th scope="col">' . ($lang['type'] ?? 'Type') . '</th>
                    <th scope="col" class="text-center">' . $lang['actions'] . '</th>
                </tr>
            </thead>
            <tbody>';
    
    if (!empty($adresses)) {
        foreach ($adresses as $index => $ip) {
            $isCidr = strpos($ip, '/') !== false;
            $typeBadge = $isCidr 
                ? '<span class="badge badge-info" data-toggle="tooltip" title="Plage CIDR"><i class="fa fa-network-wired"></i> CIDR</span>'
                : '<span class="badge badge-secondary" data-toggle="tooltip" title="IP unique"><i class="fa fa-server"></i> IP</span>';
            
            $out['content'] .= '
                <tr>
                    <td>' . ($index + 1) . '</td>
                    <td><code>' . htmlspecialchars($ip) . '</code></td>
                    <td>' . $typeBadge . '</td>
                    <td class="text-center">' . entryLink::userBan($ip) . '</td>
                </tr>';
        }
    } else {
        $out['content'] .= '<tr><td colspan="4" class="text-center text-muted">' . 
            (!empty($search) ? ($lang['no_results'] ?? 'Aucun résultat') : $lang['none']) . '</td></tr>';
    }
    
    $out['content'] .= '
            </tbody>
        </table>
    </div>
    <div class="row mt-3">
        <div class="col-md-6">
            <p class="text-muted small">
                <i class="fa fa-info-circle"></i> ' . count($adresses) . ' ' . 
                (count($adresses) > 1 ? $lang['ip_addresses'] : ($lang['ip_address'] ?? 'IP address')) . 
                (!empty($search) ? ' (' . ($lang['filtered'] ?? 'filtrées') . ')' : '') . '
            </p>
        </div>
        <div class="col-md-6 text-right">
            <small class="text-muted">
                <i class="fa fa-lightbulb-o"></i> ' . 
                ($lang['ban_cidr_help'] ?? 'Vous pouvez bannir des plages IP avec CIDR (ex: 192.168.1.0/24)') . '
            </small>
        </div>
    </div>';
}
/**
 * GESTION DES TAGS
 **/
else if (Util::isGET('tags') && User::isAdmin()) {
    $cur = 'tags'; // Indicateur de page
    $out['subtitle'] = $lang['manage_tags'];
    $tags = flatDB::readEntry('config', 'tags');
    
    if (HTMLForm::check('title') && HTMLForm::check('replace', 0, 250) && CSRF::check($token)) {
        $tagEntry = [
            'title' => HTMLForm::clean($_POST['title']),
            'replace' => HTMLForm::clean($_POST['replace']),
            'hidden_tag' => isset($_POST['hidden_tag']) ? $_POST['hidden_tag'] : '',
            'id' => flatDB::newEntry(),
        ];
        $id = $tagEntry['id'];
        
        $tags[$id] = $tagEntry;
        flatDB::saveEntry('config', 'tags', $tags);
        
        $out['content'] .= Plugin::redirectMsg($lang['data_save'], 'config.php' . DS . 'tags', $lang['tags'], 'alert alert-success');
    } else {
        $out['content'] .= HTMLForm::form('config.php' . DS . 'tags', '
        <div class="row">
            <div class="col-12">
                <div class="alert alert-info" role="alert"><i class="fa fa-info-circle fa-3" aria-hidden="true"></i> ' . $lang['tags_help'] . '</div>
            </div>
        </div>
        <div class="row">
            <div class="col-5">' .
                HTMLForm::text('title', '', 'text', '', 'title_tag') .
            '</div>
            <div class="col-7"><br /><br />' .
                HTMLForm::checkBox('hidden_tag', '') . 
            '</div>
        </div>' .
        HTMLForm::textarea('replace', '', '', '', 2) .
        HTMLForm::simple_submit('add', '', 'fa fa-tags'));
        
        if ($tags && is_array($tags)) {
            $out['content'] .= '
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th scope="col">' . $lang['tags'] . '</th>
                            <th scope="col">' . $lang['replace'] . '</th>
                            <th scope="col">' . $lang['tags_result'] . '</th>
                            <th scope="col" class="text-center">' . $lang['visibility'] . '</th>
                        </tr>
                    </thead>
                    <tbody>';
                foreach ($tags as $tagEntry) {
                    if (!is_array($tagEntry) || !isset($tagEntry['id'])) {
                        continue; // Ignore les entrées invalides
                    }
                    $out['content'] .= '
                    <tr>
                        <td>' . entryLink::manageTag($tagEntry['id']) . '<pre class="mb-0">' . htmlspecialchars($tagEntry['title'] ?? '') . '</pre></td>
                        <td><code>' . htmlspecialchars($tagEntry['replace'] ?? '') . '</code></td>
                        <td>' . Parser::htmlDecode($tagEntry['replace'] ?? '') . '</td>
                        <td class="text-center">' . (isset($tagEntry['hidden_tag']) && $tagEntry['hidden_tag'] ? '<i style="color:red" class="fa fa-eye-slash fa-2x" aria-hidden="true" data-toggle="tooltip" title="' . $lang['hidden'] . '"></i>' : '<i class="fa fa-eye fa-2x text-success" aria-hidden="true" data-toggle="tooltip" title="' . $lang['visible'] . '"></i>') . '</td>
                    </tr>';
                }
                $out['content'] .= '
                    </tbody>
                </table>
            </div>
            <p class="text-muted small">' . count($tags) . ' ' . (count($tags) > 1 ? $lang['tags'] : ($lang['tag'] ?? 'tag')) . '</p>';
        } else {
            $out['content'] .= '<div class="alert alert-light" role="alert"><i class="fa fa-tag"></i> ' . $lang['tags_empty'] . '</div>';
        }
        
        $out['content'] .= '
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            var myswitch = document.getElementById("hidden_tag");
            var mytextarea = document.getElementById("replace");
            var myinput = document.getElementById("title");
            if (myswitch && mytextarea && myinput) {
                myswitch.addEventListener("change", function() {
                    if (this.checked) {
                        mytextarea.value = \'<span class="badge badge-success" data-toggle="tooltip" data-placement="top" title="' . $lang['user_checked'] . '"><i class="fa fa-certificate"></i></span> ' . $lang['user'] . '\';
                        myinput.value = \'' . $lang['username_check'] . '\';
                    } else {
                        mytextarea.value = \'\';
                        myinput.value = \'' . $lang['title_tag'] . '\';
                    }
                });
            }
        });
        </script>';
    }
}
/**
 * PAGE DES PARAMÈTRES DU FORUM
 * UNIQUEMENT ACCESSIBLE PAR L'ADMINISTRATEUR
 **/
else {
    if (User::isAdmin()) {
        $cur = 'config'; // Indicateur de page
        $out['subtitle'] = $lang['config'];

        if (HTMLForm::check('title') && HTMLForm::check('description', 0, 250) &&
            Util::isPOST('theme') && flatDB::indir($_POST['theme'], THEME_DIR) && HTMLForm::check('style', 3, 120) &&
            Util::isPOST('lang') && flatDB::indir($_POST['lang'], LANG_DIR, '.php') && HTMLForm::check('date_format') && HTMLForm::check('short_date_format') && HTMLForm::check('mail') && HTMLForm::check('footer_text', 1, 250) && HTMLForm::checkNb('ItemByPage') && HTMLForm::checkNb('nb_page_scroll_infinite') && CSRF::check($token)) {
            
            $config['title'] = HTMLForm::clean($_POST['title']);
            $config['description'] = HTMLForm::transNL(HTMLForm::clean($_POST['description']));
            $config['theme'] = $_POST['theme'];
            $config['style'] = HTMLForm::clean($_POST['style']);
            $config['lang'] = HTMLForm::clean($_POST['lang']);
            $config['editor'] = isset($_POST['editor']) ? HTMLForm::clean($_POST['editor']) : '';
            $config['date_format'] = HTMLForm::clean($_POST['date_format']);
            $config['short_date_format'] = HTMLForm::clean($_POST['short_date_format']);
            $config['mail'] = HTMLForm::clean($_POST['mail']);
            $config['footer_text'] = HTMLForm::transNL(Parser::htmlDecode(HTMLForm::clean($_POST['footer_text'])));
            $config['announcement'] = HTMLForm::transNL(Parser::htmlDecode(HTMLForm::clean($_POST['announcement'])));
            $config['ItemByPage'] = HTMLForm::clean($_POST['ItemByPage']);
            $config['nb_page_scroll_infinite'] = HTMLForm::clean($_POST['nb_page_scroll_infinite']);
            $config['private'] = isset($_POST['private']) ? $_POST['private'] : '';
            $config['math_captcha'] = isset($_POST['math_captcha']) ? $_POST['math_captcha'] : '';
            $config['homepage'] = HTMLForm::clean($_POST['homepage']);
            $config['blog_new'] = HTMLForm::clean($_POST['blog_new']);
            $config['post_summary'] = HTMLForm::clean($_POST['post_summary']);
            flatDB::saveEntry('config', 'config', $config);
            $out['content'] .= Plugin::redirectMsg($lang['data_save'], 'config.php', $lang['config']);
        } else {
            $themes = flatDB::fdir('theme');
            // Sélection du forum à afficher pour le blog
            $forums = flatDB::readEntry('config', 'forumOrder');
            $forumOptions = [];
            foreach (array_values($forums) as $forum) {
                $forumEntry = flatDB::readEntry('forum', $forum);
                $forumOptions[$forum] = $forumEntry['name'];
            }
            $forumOptions[''] = $lang['disable_blog'];

            $out['content'] .= HTMLForm::form('config.php', '
            <div class="row">
                <div class="col-8">' .
                HTMLForm::text('title', $config['title'], 'text') . '
                </div>
                <div class="col-4">' .
                HTMLForm::text('style', $config['style'], 'text', 'color') . '
                </div>
            </div>' .
            HTMLForm::textarea('description', $config['description'], '', '', 3) . '
            <hr class="my-2">
            <div class="row">
                <div class="col">' .
                HTMLForm::select('theme', array_combine($themes, $themes), $config['theme'], '', 'theme_desc') . '
                </div>
                <div class="col">' .
                HTMLForm::select('lang', langpack(), $config['lang']) . '
                </div>
                <div class="col">' .
                HTMLForm::select('editor', array('bbcode' => $lang['bbcode'], 'markdown' => $lang['markdown']), $config['editor'], '', 'editor_desc', false) . '
                </div>
            </div>
            <div class="row">
                <div class="col">
                <label for="date_format_preset" class="form-label">' . ($lang['date_format'] ?? 'Date Format') . '</label>
                <select id="date_format_preset" name="date_format" class="form-control" onchange="
                    var select = this;
                    var customInput = document.getElementById(\'date_format_custom\');
                    if (select.value === \'custom\') {
                        customInput.style.display = \'block\';
                        customInput.disabled = false;
                        select.disabled = true;
                        select.name = \'date_format_preset_disabled\';
                        customInput.focus();
                    } else {
                        customInput.style.display = \'none\';
                        customInput.disabled = true;
                        customInput.name = \'date_format_custom_disabled\';
                        updateDatePreview(select.value, \'date_format_preview\');
                    }
                ">
                    <option value="%A %d %B %Y, %T" ' . ($config['date_format'] === '%A %d %B %Y, %T' ? 'selected' : '') . '>' . $lang['date_format_full'] . ' (%A %d %B %Y, %T)</option>
                    <option value="l d F Y, H:i:s" ' . ($config['date_format'] === 'l d F Y, H:i:s' ? 'selected' : '') . '>' . $lang['date_format_standard'] . ' (l d F Y, H:i:s)</option>
                    <option value="d/m/Y H:i" ' . ($config['date_format'] === 'd/m/Y H:i' ? 'selected' : '') . '>' . $lang['date_format_european'] . ' (d/m/Y H:i)</option>
                    <option value="Y-m-d H:i:s" ' . ($config['date_format'] === 'Y-m-d H:i:s' ? 'selected' : '') . '>' . $lang['date_format_iso'] . ' (Y-m-d H:i:s)</option>
                    <option value="F j, Y, g:i a" ' . ($config['date_format'] === 'F j, Y, g:i a' ? 'selected' : '') . '>' . $lang['date_format_us'] . ' (F j, Y, g:i a)</option>
                    <option value="custom" ' . (!in_array($config['date_format'], ['%A %d %B %Y, %T', 'l d F Y, H:i:s', 'd/m/Y H:i', 'Y-m-d H:i:s', 'F j, Y, g:i a']) ? 'selected' : '') . '>' . $lang['date_format_custom'] . '</option>
                </select>
                <input type="text" id="date_format_custom" name="date_format_custom_disabled" value="' . htmlspecialchars($config['date_format']) . '" class="form-control mt-2" placeholder="' . ($lang['date_format_placeholder'] ?? 'Y/m/d H:i') . '" style="display: ' . (!in_array($config['date_format'], ['%A %d %B %Y, %T', 'l d F Y, H:i:s', 'd/m/Y H:i', 'Y-m-d H:i:s', 'F j, Y, g:i a']) ? 'block' : 'none') . ';" oninput="
                    var select = document.getElementById(\'date_format_preset\');
                    select.disabled = true;
                    select.name = \'date_format_preset_disabled\';
                    this.name = \'date_format\';
                    updateDatePreview(this.value, \'date_format_preview\');
                ">
                <small class="form-text text-muted">' . ($lang['date_format_desc'] ?? '') . '</small>
                <small class="text-muted d-block mt-1">' . $lang['date_format_preview'] . ': <span id="date_format_preview">' . Util::toDate(date('Y-m-dHis') . 'abcde', $config['date_format'], false) . '</span></small>
                </div>
                <div class="col">
                <label for="short_date_format_preset" class="form-label">' . ($lang['short_date_format'] ?? 'Short date format') . '</label>
                <select id="short_date_format_preset" name="short_date_format" class="form-control" onchange="
                    var select = this;
                    var customInput = document.getElementById(\'short_date_format_custom\');
                    if (select.value === \'custom\') {
                        customInput.style.display = \'block\';
                        customInput.disabled = false;
                        select.disabled = true;
                        select.name = \'short_date_format_preset_disabled\';
                        customInput.focus();
                    } else {
                        customInput.style.display = \'none\';
                        customInput.disabled = true;
                        customInput.name = \'short_date_format_custom_disabled\';
                        updateDatePreview(select.value, \'short_date_format_preview\');
                    }
                ">
                    <option value="%d/%m/%Y, %T" ' . ($config['short_date_format'] === '%d/%m/%Y, %T' ? 'selected' : '') . '>' . $lang['date_format_short_european'] . ' (%d/%m/%Y, %T)</option>
                    <option value="d/m/Y H:i" ' . ($config['short_date_format'] === 'd/m/Y H:i' ? 'selected' : '') . '>' . $lang['date_format_short_standard'] . ' (d/m/Y H:i)</option>
                    <option value="Y-m-d H:i" ' . ($config['short_date_format'] === 'Y-m-d H:i' ? 'selected' : '') . '>' . $lang['date_format_short_iso'] . ' (Y-m-d H:i)</option>
                    <option value="m/d/Y H:i" ' . ($config['short_date_format'] === 'm/d/Y H:i' ? 'selected' : '') . '>' . $lang['date_format_short_us'] . ' (m/d/Y H:i)</option>
                    <option value="custom" ' . (!in_array($config['short_date_format'], ['%d/%m/%Y, %T', 'd/m/Y H:i', 'Y-m-d H:i', 'm/d/Y H:i']) ? 'selected' : '') . '>' . $lang['date_format_custom'] . '</option>
                </select>
                <input type="text" id="short_date_format_custom" name="short_date_format_custom_disabled" value="' . htmlspecialchars($config['short_date_format']) . '" class="form-control mt-2" placeholder="' . ($lang['date_format_placeholder'] ?? 'Y/m/d H:i') . '" style="display: ' . (!in_array($config['short_date_format'], ['%d/%m/%Y, %T', 'd/m/Y H:i', 'Y-m-d H:i', 'm/d/Y H:i']) ? 'block' : 'none') . ';" oninput="
                    var select = document.getElementById(\'short_date_format_preset\');
                    select.disabled = true;
                    select.name = \'short_date_format_preset_disabled\';
                    this.name = \'short_date_format\';
                    updateDatePreview(this.value, \'short_date_format_preview\');
                ">
                <small class="form-text text-muted">' . ($lang['date_format_desc'] ?? '') . '</small>
                <small class="text-muted d-block mt-1">' . $lang['date_format_preview'] . ': <span id="short_date_format_preview">' . Util::toDate(date('Y-m-dHis') . 'abcde', $config['short_date_format'], false) . '</span></small>
                </div>
                <div class="col">' .
                HTMLForm::text('ItemByPage', $config['ItemByPage'], 'number') . '
                </div>
                <div class="col">' .
                HTMLForm::text('nb_page_scroll_infinite', $config['nb_page_scroll_infinite'], 'number', '', '', 'nb_page_scroll_desc') . '
                </div>
            </div>
            <hr class="my-2">            
            <div class="row">
                <div class="col">' .
                HTMLForm::checkBox('private', $config['private'], 'restrict_access') . '
                </div>
                <div class="col">' .
                HTMLForm::checkBox('math_captcha', isset($config['math_captcha']) ? $config['math_captcha'] : '') . '
                </div>
            </div>
            <hr class="my-2">
            <div class="row">
                <div class="col">' .
                HTMLForm::select('homepage', array('index.php' => $lang['last_post'], 'index.php/forum' => $lang['forum'], 'blog.php' => $lang['blog']), $config['homepage']) . '
                </div>
                <div class="col">' .
                HTMLForm::text('mail', $config['mail'], 'email') . '
                </div>
            </div>' .
            HTMLForm::textarea('footer_text', $config['footer_text'], '', '', 4) .
            HTMLForm::textarea('announcement', $config['announcement'], '', 'announcement_desc', 5) . '
            <hr class="my-2">        
            <h6 class="small text-center text-uppercase">' . $lang['blog'] . '</h6>
            <hr class="my-2">
            <div class="row">
                <div class="col">' .
                HTMLForm::select('blog_new', $forumOptions, isset($config['blog_new']) ? $config['blog_new'] : '') . '
                </div>
                <div class="col">' .
                HTMLForm::text('post_summary', $config['post_summary'], 'number') . '
                </div>
            </div>' .
            HTMLForm::simple_submit('save', 'btn btn-success btn-lg btn-block mt-3 mb-2', 'fa fa-floppy-o') . '
            <script>
            function updateDatePreview(formatValue, previewId) {
                var preview = document.getElementById(previewId);
                if (preview && formatValue) {
                    preview.textContent = "Preview will update on save";
                }
            }
            
            // Initialise l\'état des champs au chargement
            document.addEventListener("DOMContentLoaded", function() {
                // Initialise l\'état initial des champs custom
                var dateFormatPreset = document.getElementById("date_format_preset");
                var dateFormatCustom = document.getElementById("date_format_custom");
                var shortDateFormatPreset = document.getElementById("short_date_format_preset");
                var shortDateFormatCustom = document.getElementById("short_date_format_custom");
                
                if (dateFormatPreset && dateFormatPreset.value === "custom" && dateFormatCustom) {
                    dateFormatPreset.disabled = true;
                    dateFormatPreset.name = "date_format_preset_disabled";
                    dateFormatCustom.name = "date_format";
                    dateFormatCustom.disabled = false;
                } else if (dateFormatCustom) {
                    dateFormatCustom.name = "date_format_custom_disabled";
                }
                
                if (shortDateFormatPreset && shortDateFormatPreset.value === "custom" && shortDateFormatCustom) {
                    shortDateFormatPreset.disabled = true;
                    shortDateFormatPreset.name = "short_date_format_preset_disabled";
                    shortDateFormatCustom.name = "short_date_format";
                    shortDateFormatCustom.disabled = false;
                } else if (shortDateFormatCustom) {
                    shortDateFormatCustom.name = "short_date_format_custom_disabled";
                }
            });
            </script>');
        }

    } 
    /**
     * Si non connecté on quitte
     **/
    else {    
        Util::redirect('auth.php');
        exit();
    }
}

require PATH_ROOT . DS . 'footer.php';
?>